/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.geometry;

import de.intarsys.tools.geometry.IShapeWrapper;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class TransformedShape
implements Shape,
IShapeWrapper,
Cloneable {
    protected static final AffineTransform IDENTITY = new AffineTransform();
    private final Shape baseShape;
    private Shape resultShape;

    protected TransformedShape(Shape shape) {
        this.baseShape = shape;
        this.resultShape = null;
    }

    protected TransformedShape(TransformedShape transformedShape) {
        this.baseShape = transformedShape.baseShape;
        this.resultShape = transformedShape.resultShape;
    }

    protected abstract Shape apply();

    public abstract Object clone();

    @Override
    public boolean contains(double d, double d2) {
        return this.getShape().contains(d, d2);
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        return this.getShape().contains(d, d2, d3, d4);
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.getShape().contains(point2D);
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.getShape().contains(rectangle2D);
    }

    @Override
    public Shape getBaseShape() {
        return this.baseShape;
    }

    @Override
    public Rectangle getBounds() {
        return this.getShape().getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getShape().getBounds2D();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return this.getShape().getPathIterator(affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getShape().getPathIterator(affineTransform, d);
    }

    public Shape getShape() {
        if (this.resultShape == null) {
            this.resultShape = this.apply();
        }
        return this.resultShape;
    }

    public abstract AffineTransform getTransform();

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.getShape().intersects(d, d2, d3, d4);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.getShape().intersects(rectangle2D);
    }

    public void invalidate() {
        this.resultShape = null;
    }
}

