/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.locator.AbstractLocatorLookup;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DelegatingLocatorLookup
extends AbstractLocatorLookup {
    private List<ILocatorFactory> factories = new ArrayList<ILocatorFactory>();

    public boolean addLocatorFactory(ILocatorFactory iLocatorFactory) {
        if (iLocatorFactory == this) {
            throw new IllegalArgumentException("can not delegate to myself");
        }
        return this.factories.add(iLocatorFactory);
    }

    @Override
    public ILocator createLocator(String string) throws IOException {
        for (ILocatorFactory iLocatorFactory : this.factories) {
            try {
                return iLocatorFactory.createLocator(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw ExceptionTools.createIOException("", exception);
            }
        }
        throw new FileNotFoundException(string);
    }

    public void clear() {
        this.factories.clear();
    }

    public List<ILocatorFactory> getLocatorFactories() {
        return new ArrayList<ILocatorFactory>(this.factories);
    }

    public boolean removeLocatorFactory(ILocatorFactory iLocatorFactory) {
        return this.factories.remove(iLocatorFactory);
    }
}

