/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.locator.DelegatingLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import java.io.File;
import java.io.IOException;

public class ExpandingLocatorFactory
extends DelegatingLocatorFactory {
    private final IStringEvaluator evaluator;
    private final File parent;

    public ExpandingLocatorFactory(ILocatorFactory iLocatorFactory, IStringEvaluator iStringEvaluator, File file) {
        super(iLocatorFactory);
        this.evaluator = iStringEvaluator;
        this.parent = file;
    }

    @Override
    public ILocator createLocator(String string) throws IOException {
        String string2;
        try {
            string2 = (String)this.evaluator.evaluate(string, Args.create());
        }
        catch (EvaluationException evaluationException) {
            string2 = string;
        }
        string2 = FileTools.trimPath(string2);
        if (this.parent != null) {
            File file = FileTools.resolvePath(this.parent, string2);
            return super.createLocator(file.getAbsolutePath());
        }
        return super.createLocator(string2);
    }
}

