/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.logging.CommonDumpObject;
import de.intarsys.tools.logging.CompositeHandler;
import de.intarsys.tools.logging.DelegatingHandler;
import de.intarsys.tools.logging.IDumpObject;
import de.intarsys.tools.logging.LogConfigurator;
import de.intarsys.tools.logging.ThreadFilter;
import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LogTools {
    private static IDumpObject DumpObject = new CommonDumpObject();
    public static final String INDENT = "    ";

    public static void closeFileLogger(Logger logger) {
        Handler[] handlerArray = logger.getHandlers();
        int n = 0;
        while (n < handlerArray.length) {
            handlerArray[n].close();
            ++n;
        }
    }

    public static Logger createFileLogger(String string, String string2, boolean bl) throws SecurityException, IOException {
        Logger logger = Logger.getLogger(string);
        FileHandler fileHandler = new FileHandler(string2, bl);
        logger.addHandler(fileHandler);
        return logger;
    }

    public static void dumpLogFiles() {
        File[] fileArray;
        File[] fileArray2 = fileArray = LogTools.getFilesThreadLocal();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            if (file.exists()) {
                Logger.getLogger("").log(Level.WARNING, "dump " + file.getAbsolutePath(), file);
            }
            ++n2;
        }
    }

    public static List<String> dumpObject(String string, Object object) {
        return LogTools.dumpObject(string, object, DumpObject);
    }

    public static List<String> dumpObject(String string, Object object, IDumpObject iDumpObject) {
        return DumpObject.dump(string, object, iDumpObject);
    }

    public static File[] getFiles(Handler handler) {
        try {
            handler.flush();
            Field field = FileHandler.class.getDeclaredField("files");
            field.setAccessible(true);
            return (File[])field.get(handler);
        }
        catch (Exception exception) {
            return new File[0];
        }
    }

    public static File[] getFilesThreadLocal() {
        ArrayList<File> arrayList = new ArrayList<File>();
        Logger logger = Logger.getLogger("");
        Handler[] handlerArray = logger.getHandlers();
        LogTools.getFilesThreadLocal(handlerArray, arrayList);
        return arrayList.toArray(new File[arrayList.size()]);
    }

    protected static void getFilesThreadLocal(Handler handler, List<File> list) {
        if (handler == null) {
            return;
        }
        Filter filter = handler.getFilter();
        if (filter instanceof ThreadFilter && !((ThreadFilter)filter).isActive()) {
            return;
        }
        if (handler instanceof FileHandler) {
            list.addAll(Arrays.asList(LogTools.getFiles(handler)));
        } else if (handler instanceof CompositeHandler) {
            LogTools.getFilesThreadLocal(((CompositeHandler)handler).getHandlers(), list);
        } else if (handler instanceof DelegatingHandler) {
            LogTools.getFilesThreadLocal(((DelegatingHandler)handler).getBaseHandler(), list);
        }
    }

    protected static void getFilesThreadLocal(Handler[] handlerArray, List<File> list) {
        Handler[] handlerArray2 = handlerArray;
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray2[n2];
            LogTools.getFilesThreadLocal(handler, list);
            ++n2;
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        Logger logger = Logger.getLogger(LogTools.toLoggerName(clazz));
        LogConfigurator.get().configure(logger);
        return logger;
    }

    public static Logger getLogger(String string) {
        Logger logger = Logger.getLogger(string);
        LogConfigurator.get().configure(logger);
        return logger;
    }

    public static void reconfigure(ClassLoader classLoader, String string) {
        InputStream inputStream;
        block13: {
            inputStream = null;
            try {
                try {
                    inputStream = classLoader.getResourceAsStream(string);
                    if (inputStream != null) {
                        LogManager.getLogManager().readConfiguration(inputStream);
                    }
                }
                catch (Exception exception) {
                    StreamTools.close(inputStream);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                StreamTools.close(inputStream);
                throw throwable;
            }
            StreamTools.close(inputStream);
        }
        try {
            try {
                inputStream = classLoader.getResourceAsStream(string);
                if (inputStream != null) {
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        String string2 = (String)entry.getKey();
                        if (!string2.endsWith(".level")) continue;
                        String string3 = string2.substring(0, string2.length() - 6);
                        Logger.getLogger(string3);
                    }
                }
            }
            catch (Exception exception) {
                StreamTools.close(inputStream);
            }
        }
        finally {
            StreamTools.close(inputStream);
        }
    }

    protected static void setFileHandlerLevel(Handler handler, Level level) {
        if (handler instanceof FileHandler) {
            handler.setLevel(level);
        } else if (handler instanceof CompositeHandler) {
            LogTools.setFileHandlerLevel(((CompositeHandler)handler).getHandlers(), level);
        } else if (handler instanceof DelegatingHandler) {
            LogTools.setFileHandlerLevel(((DelegatingHandler)handler).getBaseHandler(), level);
        }
    }

    protected static void setFileHandlerLevel(Handler[] handlerArray, Level level) {
        Handler[] handlerArray2 = handlerArray;
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray2[n2];
            LogTools.setFileHandlerLevel(handler, level);
            ++n2;
        }
    }

    public static void setFileHandlerLevel(Logger logger, Level level) {
        logger.setLevel(level);
        Handler[] handlerArray = logger.getHandlers();
        LogTools.setFileHandlerLevel(handlerArray, level);
    }

    public static String toLoggerName(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n > -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private LogTools() {
    }
}

