/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.monitor.AbstractMonitorTrace;
import de.intarsys.tools.monitor.ISample;
import de.intarsys.tools.monitor.Monitor;
import de.intarsys.tools.monitor.MonitorSample;
import java.io.StringWriter;
import java.text.Format;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public abstract class MonitorTrace
extends AbstractMonitorTrace {
    private long start = 0L;
    private long stop = 0L;
    private int concurrent = 0;
    private List samples = null;

    public MonitorTrace(Monitor monitor) {
        super(monitor);
    }

    @Override
    protected ISample basicSample(String string) {
        if (this.samples == null) {
            this.samples = new ArrayList();
        }
        ISample iSample = this.createMonitorSample(string);
        this.samples.add(iSample);
        return iSample;
    }

    @Override
    protected void basicStart() {
        ISample iSample = this.createMonitorSample("start");
        this.start = iSample.getValue();
        this.stop = -1L;
        if (this.samples != null && this.samples.size() > 0) {
            this.samples.clear();
        }
        this.setConcurrent(((Monitor)this.getOwner()).getActive());
        super.basicStart();
    }

    @Override
    protected void basicStop() {
        ISample iSample = this.samples == null ? this.createMonitorSample("stop") : this.sample(Level.INFO, "stop");
        this.stop = iSample.getValue();
        super.basicStop();
    }

    protected ISample createMonitorSample(String string) {
        return new MonitorSample(this, string, this.createSampleValue());
    }

    protected abstract long createSampleValue();

    public int getConcurrent() {
        return this.concurrent;
    }

    public long getDifference() {
        return this.stop - this.start;
    }

    protected Format getFormat() {
        return ((Monitor)this.getOwner()).getFormat();
    }

    public String getFormattedValue(long l) {
        return this.getFormat().format(new Long(l));
    }

    public List getSamples() {
        return this.samples;
    }

    public long getStart() {
        return this.start;
    }

    public long getStop() {
        return this.stop;
    }

    protected boolean isRelative() {
        return ((Monitor)this.getOwner()).isRelative();
    }

    protected void setConcurrent(int n) {
        this.concurrent = n;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("[Trace=");
        stringWriter.write(this.getOwner().getName());
        stringWriter.write("][");
        stringWriter.write("start=");
        stringWriter.write(this.getFormattedValue(this.getStart()));
        stringWriter.write(";");
        long l = this.getStart();
        if (this.getSamples() != null) {
            for (ISample iSample : this.getSamples()) {
                stringWriter.write(iSample.getDescription());
                stringWriter.write("=");
                long l2 = iSample.getValue();
                if (this.isRelative()) {
                    l = iSample.getValue();
                    if ((l2 -= l) > 0L) {
                        stringWriter.write("+");
                    }
                    stringWriter.write(String.valueOf(l2));
                } else {
                    stringWriter.write(this.getFormattedValue(l2));
                }
                stringWriter.write(";");
            }
        }
        stringWriter.write("stop=");
        long l3 = this.getStop();
        if (this.isRelative()) {
            l3 -= l;
            l = this.getStop();
            if (l3 > 0L) {
                stringWriter.write("+");
            }
            stringWriter.write(String.valueOf(l3));
        } else {
            stringWriter.write(this.getFormattedValue(l3));
        }
        stringWriter.write("]");
        stringWriter.write("[");
        if (this.isRelative()) {
            stringWriter.write("total=");
            l3 = this.getStop() - this.getStart();
            if (l3 > 0L) {
                stringWriter.write("+");
            }
            stringWriter.write(String.valueOf(l3));
            stringWriter.write(";");
        }
        stringWriter.write("concurrent=");
        stringWriter.write(String.valueOf(this.getConcurrent()));
        if (this.getTags() != null) {
            Iterator iterator = this.getTags().entrySet().iterator();
            if (iterator.hasNext()) {
                stringWriter.write(";");
            }
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                stringWriter.write(String.valueOf(entry.getKey()));
                stringWriter.write("=");
                stringWriter.write(String.valueOf(entry.getValue()));
                if (!iterator.hasNext()) continue;
                stringWriter.write(";");
            }
        }
        stringWriter.write("]");
        return stringWriter.toString();
    }

    @Override
    protected void traceLog() {
        if (this.getOwner().getLogger() != null) {
            this.getOwner().getLogger().logp(this.getOwner().getLevel(), "", "", this.toString());
        }
    }
}

