/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeTools;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeByteType;
import de.intarsys.nativec.type.NativeNumber;
import de.intarsys.nativec.type.NativeType;

public class NativeByte
extends NativeNumber {
    public static final NativeByteType META = new NativeByteType();

    static {
        NativeType.register(NativeByte.class, META);
    }

    public static NativeByte createFromAddress(long l) {
        return (NativeByte)META.createNative(NativeTools.toHandle(l));
    }

    public NativeByte() {
        this.allocate();
    }

    public NativeByte(byte by) {
        this.allocate();
        this.setValue(by);
    }

    protected NativeByte(INativeHandle iNativeHandle) {
        super(iNativeHandle);
    }

    @Override
    public byte byteValue() {
        return this.handle.getByte(0);
    }

    @Override
    public INativeType getNativeType() {
        return META;
    }

    @Override
    public Object getValue() {
        return new Byte(this.byteValue());
    }

    @Override
    public int intValue() {
        return this.byteValue();
    }

    @Override
    public long longValue() {
        return this.byteValue();
    }

    public void setValue(byte by) {
        this.handle.setByte(0, by);
    }

    @Override
    public void setValue(Object object) {
        this.setValue(((Number)object).byteValue());
    }

    @Override
    public short shortValue() {
        return this.byteValue();
    }

    public String toString() {
        if (this.getNativeHandle().getAddress() == 0L) {
            return "nope - null pointer";
        }
        return String.valueOf(this.byteValue());
    }
}

