/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import proguard.Configuration;
import proguard.ConfigurationChecker;
import proguard.ConfigurationParser;
import proguard.ConfigurationWriter;
import proguard.GPL;
import proguard.Initializer;
import proguard.InputReader;
import proguard.OutputWriter;
import proguard.SeedPrinter;
import proguard.Targeter;
import proguard.UpToDateChecker;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.editor.ClassElementSorter;
import proguard.classfile.editor.LineNumberTableAttributeTrimmer;
import proguard.classfile.editor.NamedAttributeDeleter;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassPrinter;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.obfuscate.Obfuscator;
import proguard.optimize.Optimizer;
import proguard.optimize.peephole.LineNumberLinearizer;
import proguard.preverify.Preverifier;
import proguard.preverify.SubroutineInliner;
import proguard.shrink.Shrinker;

public class ProGuard {
    public static final String VERSION = "ProGuard, version 5.2";
    private final Configuration configuration;
    private ClassPool programClassPool = new ClassPool();
    private final ClassPool libraryClassPool = new ClassPool();

    public ProGuard(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute() throws IOException {
        System.out.println(VERSION);
        GPL.check();
        if (this.configuration.printConfiguration != null) {
            this.printConfiguration();
        }
        new ConfigurationChecker(this.configuration).check();
        if (this.configuration.programJars != null && this.configuration.programJars.hasOutput() && new UpToDateChecker(this.configuration).check()) {
            return;
        }
        this.readInput();
        if (this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate || this.configuration.preverify) {
            this.clearPreverification();
        }
        if (this.configuration.printSeeds != null || this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate || this.configuration.preverify) {
            this.initialize();
        }
        if (this.configuration.targetClassVersion != 0) {
            this.target();
        }
        if (this.configuration.printSeeds != null) {
            this.printSeeds();
        }
        if (this.configuration.shrink) {
            this.shrink();
        }
        if (this.configuration.preverify) {
            this.inlineSubroutines();
        }
        if (this.configuration.optimize) {
            for (int i = 0; i < this.configuration.optimizationPasses && this.optimize(); ++i) {
                if (!this.configuration.shrink) continue;
                this.configuration.printUsage = null;
                this.configuration.whyAreYouKeeping = null;
                this.shrink();
            }
        }
        if (this.configuration.optimize) {
            this.linearizeLineNumbers();
        }
        if (this.configuration.obfuscate) {
            this.obfuscate();
        }
        if (this.configuration.optimize) {
            this.trimLineNumbers();
        }
        if (this.configuration.preverify) {
            this.preverify();
        }
        if (this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate || this.configuration.preverify) {
            this.sortClassElements();
        }
        if (this.configuration.programJars.hasOutput()) {
            this.writeOutput();
        }
        if (this.configuration.dump != null) {
            this.dump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printConfiguration() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Printing configuration to [" + this.fileName(this.configuration.printConfiguration) + "]...");
        }
        PrintStream printStream = this.createPrintStream(this.configuration.printConfiguration);
        try {
            new ConfigurationWriter(printStream).write(this.configuration);
        }
        finally {
            this.closePrintStream(printStream);
        }
    }

    private void readInput() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Reading input...");
        }
        new InputReader(this.configuration).execute(this.programClassPool, this.libraryClassPool);
    }

    private void initialize() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Initializing...");
        }
        new Initializer(this.configuration).execute(this.programClassPool, this.libraryClassPool);
    }

    private void target() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Setting target versions...");
        }
        new Targeter(this.configuration).execute(this.programClassPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSeeds() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Printing kept classes, fields, and methods...");
        }
        PrintStream printStream = this.createPrintStream(this.configuration.printSeeds);
        try {
            new SeedPrinter(printStream).write(this.configuration, this.programClassPool, this.libraryClassPool);
        }
        finally {
            this.closePrintStream(printStream);
        }
    }

    private void shrink() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Shrinking...");
            if (this.configuration.whyAreYouKeeping != null) {
                System.out.println("Explaining why classes and class members are being kept...");
            }
            if (this.configuration.printUsage != null) {
                System.out.println("Printing usage to [" + this.fileName(this.configuration.printUsage) + "]...");
            }
        }
        this.programClassPool = new Shrinker(this.configuration).execute(this.programClassPool, this.libraryClassPool);
    }

    private void inlineSubroutines() {
        if (this.configuration.verbose) {
            System.out.println("Inlining subroutines...");
        }
        new SubroutineInliner(this.configuration).execute(this.programClassPool);
    }

    private boolean optimize() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Optimizing...");
        }
        return new Optimizer(this.configuration).execute(this.programClassPool, this.libraryClassPool);
    }

    private void obfuscate() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Obfuscating...");
            if (this.configuration.applyMapping != null) {
                System.out.println("Applying mapping [" + this.fileName(this.configuration.applyMapping) + "]");
            }
            if (this.configuration.printMapping != null) {
                System.out.println("Printing mapping to [" + this.fileName(this.configuration.printMapping) + "]...");
            }
        }
        new Obfuscator(this.configuration).execute(this.programClassPool, this.libraryClassPool);
    }

    private void linearizeLineNumbers() {
        this.programClassPool.classesAccept(new LineNumberLinearizer());
    }

    private void trimLineNumbers() {
        this.programClassPool.classesAccept(new AllAttributeVisitor(true, new LineNumberTableAttributeTrimmer()));
    }

    private void clearPreverification() {
        this.programClassPool.classesAccept(new ClassVersionFilter(0x320000, new AllMethodVisitor(new AllAttributeVisitor(new NamedAttributeDeleter("StackMapTable")))));
    }

    private void preverify() {
        if (this.configuration.verbose) {
            System.out.println("Preverifying...");
        }
        new Preverifier(this.configuration).execute(this.programClassPool);
    }

    private void sortClassElements() {
        this.programClassPool.classesAccept(new ClassElementSorter());
    }

    private void writeOutput() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Writing output...");
        }
        new OutputWriter(this.configuration).execute(this.programClassPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Printing classes to [" + this.fileName(this.configuration.dump) + "]...");
        }
        PrintStream printStream = this.createPrintStream(this.configuration.dump);
        try {
            this.programClassPool.classesAccept(new ClassPrinter(printStream));
        }
        finally {
            this.closePrintStream(printStream);
        }
    }

    private PrintStream createPrintStream(File file) throws FileNotFoundException {
        return file == Configuration.STD_OUT ? System.out : new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    private void closePrintStream(PrintStream printStream) {
        if (printStream == System.out) {
            printStream.flush();
        } else {
            printStream.close();
        }
    }

    private String fileName(File file) {
        if (file == Configuration.STD_OUT) {
            return "standard output";
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getPath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println(VERSION);
            System.out.println("Usage: java proguard.ProGuard [options ...]");
            System.exit(1);
        }
        Configuration configuration = new Configuration();
        try {
            ConfigurationParser configurationParser = new ConfigurationParser(stringArray, System.getProperties());
            try {
                configurationParser.parse(configuration);
            }
            finally {
                configurationParser.close();
            }
            new ProGuard(configuration).execute();
        }
        catch (Exception exception) {
            if (configuration.verbose) {
                exception.printStackTrace();
            } else {
                System.err.println("Error: " + exception.getMessage());
            }
            System.exit(1);
        }
        System.exit(0);
    }
}

