/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.CombiningIterator;
import ch.interlis.ili2c.metamodel.Contract;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.GraphicParameterDef;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Importable;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.MetaDataUseDef;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TypeModel;
import ch.interlis.ili2c.metamodel.Unit;
import java.beans.PropertyVetoException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class Model
extends Importable<Element> {
    protected List<Element> contents = new LinkedList<Element>();
    protected List<GraphicParameterDef> runtimeParameters = new LinkedList<GraphicParameterDef>();
    protected List<ModelImport> imports = new ArrayList<ModelImport>();
    private final List<Contract> contracts = new LinkedList<Contract>();
    private String language = null;
    private boolean contracted = false;
    private String issuer = null;
    private String modelVersion = null;
    private String modelVersionExpl = null;
    private String iliVersion = "2.3";
    public static final String ILI1 = "1";
    public static final String ILI2_2 = "2.2";
    public static final String ILI2_3 = "2.3";
    public static final String ILI2_4 = "2.4";
    private String filename = null;

    public void addPreLast(Element o) {
        if (!((ElementDelegate)this.elements).checkChildElement(o)) {
            return;
        }
        try {
            o.setBeanContext(this);
        }
        catch (PropertyVetoException pve) {
            throw new IllegalArgumentException(pve.getLocalizedMessage());
        }
        if (o instanceof GraphicParameterDef) {
            this.runtimeParameters.add((GraphicParameterDef)o);
        }
        this.contents.add(this.contents.size() - 1, o);
    }

    public void addBefore(Element o, Element last) {
        int idx;
        if (!((ElementDelegate)this.elements).checkChildElement(o)) {
            return;
        }
        try {
            o.setBeanContext(this);
        }
        catch (PropertyVetoException pve) {
            throw new IllegalArgumentException(pve.getLocalizedMessage());
        }
        if (o instanceof GraphicParameterDef) {
            this.runtimeParameters.add((GraphicParameterDef)o);
        }
        if ((idx = this.contents.indexOf(last)) > -1) {
            this.contents.add(idx, o);
        } else {
            this.contents.add(o);
        }
    }

    protected Model() {
        this.name = "";
    }

    @Override
    protected Collection<Element> createElements() {
        return new ElementDelegate();
    }

    public Element getImportedElement(Class<?> aclass, String name) {
        Element e = this.getElement(aclass, name);
        if (e != null) {
            return e;
        }
        for (ModelImport mi : this.imports) {
            Model i;
            if (!mi.isUnqualified() || (e = (i = mi.getModel()).getElement(aclass, name)) == null) continue;
            return e;
        }
        return null;
    }

    private Element getElement(String name) {
        if (name != null) {
            for (Element e : this.contents) {
                if (!name.equals(e.getName())) continue;
                return e;
            }
        }
        return null;
    }

    private Element getRuntimeParameter(String name) {
        if (name != null) {
            for (GraphicParameterDef e : this.runtimeParameters) {
                if (!name.equals(e.getName())) continue;
                return e;
            }
        }
        return null;
    }

    @Override
    public boolean isDependentOn(Element e) {
        if (e instanceof Model) {
            return this.isImporting((Model)e);
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) throws PropertyVetoException {
        String oldValue = this.name;
        String newValue = name;
        Model.checkNameSanity(newValue, false);
        this.fireVetoableChange("name", oldValue, newValue);
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    public boolean isContracted() {
        return this.contracted || !this.contracts.isEmpty();
    }

    public void setContracted(boolean contracted1) {
        this.contracted = contracted1;
    }

    public void setIssuer(String issuer1) {
        this.issuer = issuer1;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setModelVersion(String modelVersion1) {
        this.modelVersion = modelVersion1;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public void setModelVersionExpl(String modelVersionExpl1) {
        this.modelVersionExpl = modelVersionExpl1;
    }

    public String getModelVersionExpl() {
        return this.modelVersionExpl;
    }

    public void addContract(Contract contract) {
        this.contracts.add(contract);
    }

    public Contract[] getContracts() {
        return this.contracts.toArray(new Contract[this.contracts.size()]);
    }

    public Model[] getImporting() {
        ArrayList<Model> importing = new ArrayList<Model>();
        for (ModelImport mi : this.imports) {
            importing.add(mi.getModel());
        }
        return importing.toArray(new Model[importing.size()]);
    }

    public void addImport(Model importing, boolean unqualified) {
        this.imports.add(new ModelImport(importing, unqualified));
        importing.importedBy.add(importing);
    }

    public boolean isImporting(Model importing) {
        for (ModelImport mi : this.imports) {
            if (mi.getModel() != importing) continue;
            return true;
        }
        return false;
    }

    public boolean isImporting(Model importing, boolean qualifiedImport) {
        for (ModelImport mi : this.imports) {
            if (mi.isUnqualified() != !qualifiedImport || mi.getModel() != importing) continue;
            return true;
        }
        return false;
    }

    public void setLanguage(String v) {
        this.language = v;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setFileName(String filename) {
        this.filename = filename;
    }

    public String getFileName() {
        return this.filename;
    }

    public String getIliVersion() {
        return this.iliVersion;
    }

    public void setIliVersion(String string) {
        this.iliVersion = string;
    }

    public boolean isIli23() {
        return ILI2_3.equals(this.iliVersion);
    }

    protected class ElementDelegate
    extends AbstractCollection<Element> {
        protected ElementDelegate() {
        }

        @Override
        public Iterator<Element> iterator() {
            return new CombiningIterator<Element>(new Iterator[]{Model.this.runtimeParameters.iterator(), Model.this.contents.iterator()});
        }

        @Override
        public int size() {
            return Model.this.runtimeParameters.size() + Model.this.contents.size();
        }

        @Override
        public boolean add(Element o) {
            if (!this.checkChildElement(o)) {
                return false;
            }
            if (o instanceof GraphicParameterDef) {
                return Model.this.runtimeParameters.add((GraphicParameterDef)o);
            }
            return Model.this.contents.add(o);
        }

        public boolean checkChildElement(Element e) {
            if (e instanceof MetaDataUseDef) {
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_nonuniqueMetaDataUseDefName", e.getName(), Model.this.toString()));
                }
                return true;
            }
            if (e instanceof Unit) {
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_duplicateUnitName", e.getName(), Model.this.toString()));
                }
                return true;
            }
            if (e instanceof Function) {
                if (Model.this.isIli23() && !Model.this.isContracted() && !(Model.this instanceof PredefinedModel)) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_model_functionButNoContract", e.toString(), Model.this.toString()));
                }
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_function_duplicateName", e.getName(), Model.this.toString(), conflicting.toString()));
                }
                return true;
            }
            if (e instanceof LineForm) {
                if (!Model.this.isContracted() && !(Model.this instanceof PredefinedModel)) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_lineForm_inUnconctractedModel", Model.this.toString()));
                }
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_lineForm_duplicateName", e.getName(), Model.this.toString(), conflicting.toString()));
                }
                return true;
            }
            if (e instanceof Domain) {
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_duplicateDomainName", e.getName(), Model.this.toString()));
                }
                return true;
            }
            if (e instanceof GraphicParameterDef) {
                Element conflicting = Model.this.getRuntimeParameter(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_graphicparam_nonunique", e.getName(), Model.this.toString()));
                }
                return true;
            }
            if (e instanceof Topic) {
                if (Model.this instanceof TypeModel) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_typeModel_addTopic", e.toString(), Model.this.toString()));
                }
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_topic_nonunique", e.getName(), Model.this.toString()));
                }
                return true;
            }
            if (e instanceof Table) {
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_table_nonunique", e.getName(), Model.this.toString()));
                }
                return true;
            }
            throw new ClassCastException(Element.formatMessage("err_container_cannotContain", Model.this.toString(), e.toString()));
        }
    }

    private class ModelImport {
        private Model model;
        private boolean unqualified;

        public ModelImport(Model model1, boolean unqualified1) {
            this.model = model1;
            this.unqualified = unqualified1;
        }

        public Model getModel() {
            return this.model;
        }

        public boolean isUnqualified() {
            return this.unqualified;
        }
    }
}

