/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.uml;

import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.enums.ElementId;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.NewGridElement;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.element.facet.Settings;
import com.baselet.element.settings.SettingsAutoresize;
import com.baselet.element.sticking.StickingPolygon;
import com.baselet.element.sticking.polygon.StickingPolygonGenerator;

public class Interface
extends NewGridElement {
    private static final int TOP_DISTANCE = 10;
    private static final int CIRCLE_SIZE = 20;
    private final StickingPolygonGenerator interfacePolygonGenerator = new StickingPolygonGenerator(){

        @Override
        public StickingPolygon generateStickingBorder(Rectangle rectangle) {
            StickingPolygon stickingPolygon = new StickingPolygon(rectangle.x, rectangle.y);
            stickingPolygon.addRectangle(Interface.this.circleRect());
            return stickingPolygon;
        }
    };

    @Override
    public ElementId getId() {
        return ElementId.UMLInterface;
    }

    @Override
    protected void drawCommonContent(PropertiesParserState propertiesParserState) {
        DrawHandler drawHandler = propertiesParserState.getDrawer();
        propertiesParserState.getBuffer().setTopMin(30.0);
        Rectangle rectangle = this.circleRect();
        drawHandler.drawCircle((double)rectangle.x + 10.0, (double)rectangle.y + 10.0, 10.0);
        propertiesParserState.setStickingPolygonGenerator(this.interfacePolygonGenerator);
    }

    private Rectangle circleRect() {
        int n = (int)((double)this.getRealSize().getWidth() * 0.5 - 10.0);
        return new Rectangle(n, 10, 20, 20);
    }

    @Override
    protected Settings createSettings() {
        return new SettingsAutoresize();
    }
}

