/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation.helper;

import com.baselet.control.SharedUtils;
import com.baselet.control.basics.geom.GeometricFunctions;
import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.element.relation.helper.RelationPoint;
import com.baselet.element.sticking.PointChange;
import com.baselet.element.sticking.PointDoubleIndexed;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class RelationPointList {
    List<RelationPoint> points = new ArrayList<RelationPoint>();
    Map<Integer, Rectangle> textBoxSpaces = new HashMap<Integer, Rectangle>();

    public void add(double d, double d2) {
        this.points.add(new RelationPoint(this.points.size(), d, d2));
    }

    public List<RelationPoint> getPointHolders() {
        return Collections.unmodifiableList(this.points);
    }

    public PointDoubleIndexed addPointOnLine(Line line, double d, double d2) {
        RelationPoint relationPoint = null;
        PointDouble pointDouble = line.getStart();
        ListIterator<RelationPoint> listIterator = this.points.listIterator();
        while (listIterator.hasNext()) {
            PointDoubleIndexed pointDoubleIndexed = listIterator.next().getPoint();
            if (!pointDoubleIndexed.equals(pointDouble)) continue;
            relationPoint = new RelationPoint(listIterator.nextIndex(), d, d2);
            listIterator.add(relationPoint);
        }
        this.rebuildpointIndexes();
        if (relationPoint == null) {
            throw new RuntimeException("Point " + pointDouble + " not found in list " + this.points);
        }
        return relationPoint.getPoint();
    }

    private void rebuildpointIndexes() {
        ArrayList<RelationPoint> arrayList = new ArrayList<RelationPoint>();
        for (int i = 0; i < this.points.size(); ++i) {
            arrayList.add(new RelationPoint(i, this.points.get(i).getPoint().getX(), this.points.get(i).getPoint().getY()));
        }
        this.points.clear();
        this.points.addAll(arrayList);
    }

    public void applyChangesToPoints(List<PointChange> list) {
        this.applyPointChange(list);
        this.revertChangesIfOnly2PointsOverlap(list);
    }

    private void revertChangesIfOnly2PointsOverlap(List<PointChange> list) {
        if (this.points.size() == 2 && this.points.get(0).getPoint().getX().equals(this.points.get(1).getPoint().getX()) && this.points.get(0).getPoint().getY().equals(this.points.get(1).getPoint().getY())) {
            ArrayList<PointChange> arrayList = new ArrayList<PointChange>();
            for (PointChange pointChange : list) {
                arrayList.add(new PointChange(pointChange.getIndex(), -pointChange.getDiffX(), -pointChange.getDiffY()));
            }
            this.applyPointChange(arrayList);
        }
    }

    private void applyPointChange(List<PointChange> list) {
        ListIterator<RelationPoint> listIterator = this.points.listIterator();
        while (listIterator.hasNext()) {
            RelationPoint relationPoint = listIterator.next();
            PointDoubleIndexed pointDoubleIndexed = relationPoint.getPoint();
            for (PointChange pointChange : list) {
                if (!pointDoubleIndexed.getIndex().equals(pointChange.getIndex())) continue;
                listIterator.set(new RelationPoint(pointDoubleIndexed.getIndex(), pointDoubleIndexed.getX() + (double)pointChange.getDiffX(), pointDoubleIndexed.getY() + (double)pointChange.getDiffY(), relationPoint.getSize()));
            }
        }
    }

    void moveRelationPointsAndTextSpacesByToUpperLeftCorner() {
        Rectangle rectangle = this.createRectangleContainingAllPointsAndTextSpace();
        int n = SharedUtils.realignToGrid(false, rectangle.getX(), false);
        int n2 = SharedUtils.realignToGrid(false, rectangle.getY(), false);
        this.moveRelationPointsAndTextSpacesBy(-n, -n2);
    }

    void moveRelationPointsAndTextSpacesBy(int n, int n2) {
        Iterator<Object> iterator = this.points.listIterator();
        while (iterator.hasNext()) {
            RelationPoint object = iterator.next();
            iterator.set(new RelationPoint(object.getPoint().getIndex(), object.getPoint().getX() + (double)n, object.getPoint().getY() + (double)n2, object.getSize()));
        }
        for (Map.Entry entry : this.textBoxSpaces.entrySet()) {
            Rectangle rectangle = (Rectangle)entry.getValue();
            entry.setValue(new Rectangle(rectangle.getX() + n, rectangle.getY() + n2, rectangle.getWidth(), rectangle.getHeight()));
        }
    }

    public boolean removeRelationPointIfOnLineBetweenNeighbourPoints() {
        boolean bl = false;
        if (this.points.size() > 2) {
            ListIterator<RelationPoint> listIterator = this.points.listIterator();
            PointDoubleIndexed pointDoubleIndexed = listIterator.next().getPoint();
            PointDoubleIndexed pointDoubleIndexed2 = listIterator.next().getPoint();
            while (listIterator.hasNext()) {
                PointDoubleIndexed pointDoubleIndexed3 = listIterator.next().getPoint();
                if (GeometricFunctions.getDistanceBetweenLineAndPoint(pointDoubleIndexed, pointDoubleIndexed3, pointDoubleIndexed2) < 5.0) {
                    bl = true;
                    listIterator.previous();
                    listIterator.previous();
                    listIterator.remove();
                    pointDoubleIndexed2 = listIterator.next().getPoint();
                    continue;
                }
                pointDoubleIndexed = pointDoubleIndexed2;
                pointDoubleIndexed2 = pointDoubleIndexed3;
            }
        }
        if (bl) {
            this.rebuildpointIndexes();
        }
        return bl;
    }

    public List<Line> getRelationPointLines() {
        ArrayList<Line> arrayList = new ArrayList<Line>();
        for (int i = 1; i < this.points.size(); ++i) {
            arrayList.add(new Line(this.points.get(i - 1).getPoint(), this.points.get(i).getPoint()));
        }
        return arrayList;
    }

    public Line getFirstLine() {
        return new Line(this.points.get(0).getPoint(), this.points.get(1).getPoint());
    }

    public Line getMiddleLine() {
        PointDoubleIndexed pointDoubleIndexed = this.points.get(this.points.size() / 2).getPoint();
        PointDoubleIndexed pointDoubleIndexed2 = this.points.get(this.points.size() / 2 - 1).getPoint();
        return new Line(pointDoubleIndexed, pointDoubleIndexed2);
    }

    public Line getLastLine() {
        return new Line(this.points.get(this.points.size() - 2).getPoint(), this.points.get(this.points.size() - 1).getPoint());
    }

    public Collection<PointDoubleIndexed> getStickablePoints() {
        return Arrays.asList(this.points.get(0).getPoint(), this.points.get(this.points.size() - 1).getPoint());
    }

    public Rectangle getDragBox() {
        PointDouble pointDouble = this.getMiddleLine().getCenter();
        double d = 5.0;
        Rectangle rectangle = new Rectangle(pointDouble.x - d, pointDouble.y - d, d * 2.0, d * 2.0);
        return rectangle;
    }

    public String toAdditionalAttributesString() {
        StringBuilder stringBuilder = new StringBuilder("");
        for (RelationPoint relationPoint : this.points) {
            stringBuilder.append(relationPoint.getPoint().getX()).append(";").append(relationPoint.getPoint().getY()).append(";");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return "Relationpoints: " + SharedUtils.listToString(",", this.points);
    }

    public PointDoubleIndexed get(int n) {
        return this.points.get(n).getPoint();
    }

    public void setSize(int n, Rectangle rectangle) {
        for (RelationPoint relationPoint : this.points) {
            if (relationPoint.getPoint().getIndex() != n) continue;
            relationPoint.setSize(rectangle);
            return;
        }
        throw new RuntimeException("Unknown Point Index " + n);
    }

    public void setTextBox(int n, Rectangle rectangle) {
        if (rectangle == null) {
            this.textBoxSpaces.remove(n);
        } else {
            this.textBoxSpaces.put(n, rectangle);
        }
    }

    public Set<Integer> getTextBoxIndexes() {
        return this.textBoxSpaces.keySet();
    }

    public Rectangle createRectangleContainingAllPointsAndTextSpace() {
        Rectangle rectangle = null;
        for (RelationPoint object : this.points) {
            rectangle = this.addWithNullCheck(rectangle, object.getSizeAbsolute());
        }
        for (Rectangle rectangle2 : this.textBoxSpaces.values()) {
            rectangle = this.addWithNullCheck(rectangle, rectangle2);
        }
        return rectangle;
    }

    private Rectangle addWithNullCheck(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null) {
            rectangle = rectangle2;
        } else {
            rectangle.merge(rectangle2);
        }
        return rectangle;
    }
}

