/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.StringTokenizer;
import javax.accessibility.AccessibleContext;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.GNOME.Accessibility.EditableTextOperations;
import org.GNOME.Accessibility.EditableTextPOATie;
import org.GNOME.Accessibility.JavaBridge;
import org.GNOME.Accessibility.TextImpl;

public class EditableTextImpl
extends TextImpl
implements EditableTextOperations {
    public EditableTextImpl(AccessibleContext accessibleContext) {
        super(accessibleContext);
        this.tie = new EditableTextPOATie(this, JavaBridge.getRootPOA());
        try {
            JavaBridge.getRootPOA().activate_object(this.tie);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    @Override
    public boolean setTextContents(String string) {
        if (this.accEditableText != null) {
            this.accEditableText.setTextContents(string);
            return true;
        }
        return false;
    }

    @Override
    public boolean insertText(int n, String string, int n2) {
        if (this.accEditableText != null && string != null) {
            if (n < 0) {
                n = 0;
            }
            this.accEditableText.insertTextAtIndex(n, string);
            return true;
        }
        return false;
    }

    private AttributeSet convertStringToAttributeSet(String string) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        String string2 = string.replaceAll(",\\s+", "|");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (stringTokenizer.hasMoreElements()) {
            int n;
            int n2;
            int n3;
            StringTokenizer stringTokenizer2;
            String string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer3 = new StringTokenizer(string3, ": ");
            if (stringTokenizer3.countTokens() != 2) continue;
            String string4 = stringTokenizer3.nextToken();
            String string5 = stringTokenizer3.nextToken();
            if (string4.equals("family-name")) {
                StyleConstants.setFontFamily(simpleAttributeSet, string5);
                continue;
            }
            if (string4.equals("size")) {
                try {
                    StyleConstants.setFontSize(simpleAttributeSet, Integer.parseInt(string5));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (string4.equals("style")) {
                if (string5.equals("italic") || string5.equals("oblique")) {
                    StyleConstants.setItalic(simpleAttributeSet, true);
                    continue;
                }
                StyleConstants.setItalic(simpleAttributeSet, false);
                continue;
            }
            if (string4.equals("weight")) {
                try {
                    int n4 = Integer.parseInt(string5);
                    switch (n4) {
                        case 500: 
                        case 600: 
                        case 700: 
                        case 800: 
                        case 900: {
                            StyleConstants.setBold(simpleAttributeSet, true);
                            break;
                        }
                        default: {
                            StyleConstants.setBold(simpleAttributeSet, false);
                            break;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (!string5.equals("medium") && !string5.equals("demibold") && !string5.equals("semibold") && !string5.equals("bold") && !string5.equals("extrabold") && !string5.equals("ultrabold") && !string5.equals("heavy") && !string5.equals("black")) continue;
                    StyleConstants.setBold(simpleAttributeSet, true);
                }
                continue;
            }
            if (string4.equals("fg-color")) {
                try {
                    StyleConstants.setForeground(simpleAttributeSet, new Color(Integer.decode(string5)));
                }
                catch (NumberFormatException numberFormatException) {
                    stringTokenizer2 = new StringTokenizer(string5, ",");
                    if (stringTokenizer2.countTokens() != 3) continue;
                    try {
                        n3 = Integer.parseInt(stringTokenizer2.nextToken()) / 256;
                        n2 = Integer.parseInt(stringTokenizer2.nextToken()) / 256;
                        n = Integer.parseInt(stringTokenizer2.nextToken()) / 256;
                        StyleConstants.setForeground(simpleAttributeSet, new Color(n3, n2, n));
                    }
                    catch (NumberFormatException numberFormatException2) {}
                }
                continue;
            }
            if (string4.equals("bg-color")) {
                try {
                    StyleConstants.setBackground(simpleAttributeSet, new Color(Integer.decode(string5)));
                }
                catch (NumberFormatException numberFormatException) {
                    stringTokenizer2 = new StringTokenizer(string5, ",");
                    if (stringTokenizer2.countTokens() != 3) continue;
                    try {
                        n3 = Integer.parseInt(stringTokenizer2.nextToken()) / 256;
                        n2 = Integer.parseInt(stringTokenizer2.nextToken()) / 256;
                        n = Integer.parseInt(stringTokenizer2.nextToken()) / 256;
                        StyleConstants.setBackground(simpleAttributeSet, new Color(n3, n2, n));
                    }
                    catch (NumberFormatException numberFormatException3) {}
                }
                continue;
            }
            if (string4.equals("underline")) {
                if (string5.equals("none")) {
                    StyleConstants.setUnderline(simpleAttributeSet, false);
                    continue;
                }
                StyleConstants.setUnderline(simpleAttributeSet, true);
                continue;
            }
            if (string4.equals("strikethrough")) {
                StyleConstants.setStrikeThrough(simpleAttributeSet, Boolean.valueOf(string5));
                continue;
            }
            simpleAttributeSet.addAttribute(string4, string5);
        }
        return simpleAttributeSet;
    }

    @Override
    public boolean setAttributes(String string, int n, int n2) {
        if (this.accEditableText != null) {
            int n3 = this.accEditableText.getCharCount();
            if (n < 0) {
                n = 0;
            }
            if (n2 >= n3 || n2 == -1) {
                n2 = n3;
            } else if (n2 < -1) {
                n2 = 0;
            }
            AttributeSet attributeSet = this.convertStringToAttributeSet(string);
            if (attributeSet != null) {
                this.accEditableText.setAttributes(n, n2, attributeSet);
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyText(int n, int n2) {
        if (this.accEditableText != null) {
            int n3 = this.accEditableText.getCharCount();
            if (n < 0) {
                n = 0;
            }
            if (n2 >= n3 || n2 == -1) {
                n2 = n3;
            } else if (n2 < -1) {
                n2 = 0;
            }
            String string = this.accEditableText.getTextRange(n, n2);
            if (string != null) {
                StringSelection stringSelection = new StringSelection(string);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            }
        }
    }

    @Override
    public boolean cutText(int n, int n2) {
        if (this.accEditableText != null) {
            int n3 = this.accEditableText.getCharCount();
            if (n < 0) {
                n = 0;
            }
            if (n2 >= n3 || n2 == -1) {
                n2 = n3;
            } else if (n2 < -1) {
                n2 = 0;
            }
            this.accEditableText.cut(n, n2);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteText(int n, int n2) {
        if (this.accEditableText != null) {
            int n3 = this.accEditableText.getCharCount();
            if (n < 0) {
                n = 0;
            }
            if (n2 >= n3 || n2 == -1) {
                n2 = n3;
            } else if (n2 < -1) {
                n2 = 0;
            }
            this.accEditableText.delete(n, n2);
            return true;
        }
        return false;
    }

    @Override
    public boolean pasteText(int n) {
        if (this.accEditableText != null) {
            if (n < 0) {
                n = 0;
            }
            this.accEditableText.paste(n);
            return true;
        }
        return false;
    }

    @Override
    public void unImplemented5() {
    }

    @Override
    public void unImplemented6() {
    }

    @Override
    public void unImplemented9() {
    }

    @Override
    public void unImplemented10() {
    }

    @Override
    public void unImplemented11() {
    }

    @Override
    public void unImplemented12() {
    }
}

