/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.util;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.remote.security.NotificationAccessController;
import com.sun.jmx.remote.util.ClassLogger;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class EnvHelp {
    private static final String DEFAULT_CLASS_LOADER = "jmx.remote.default.class.loader";
    private static final String DEFAULT_CLASS_LOADER_NAME = "jmx.remote.default.class.loader.name";
    public static final String BUFFER_SIZE_PROPERTY = "jmx.remote.x.notification.buffer.size";
    public static final String MAX_FETCH_NOTIFS = "jmx.remote.x.notification.fetch.max";
    public static final String FETCH_TIMEOUT = "jmx.remote.x.notification.fetch.timeout";
    public static final String NOTIF_ACCESS_CONTROLLER = "com.sun.jmx.remote.notification.access.controller";
    public static final String DEFAULT_ORB = "java.naming.corba.orb";
    public static final String HIDDEN_ATTRIBUTES = "jmx.remote.x.hidden.attributes";
    public static final String DEFAULT_HIDDEN_ATTRIBUTES = "java.naming.security.* jmx.remote.authenticator jmx.remote.context jmx.remote.default.class.loader jmx.remote.message.connection.server jmx.remote.object.wrapping jmx.remote.rmi.client.socket.factory jmx.remote.rmi.server.socket.factory jmx.remote.sasl.callback.handler jmx.remote.tls.socket.factory jmx.remote.x.access.file jmx.remote.x.password.file ";
    private static final SortedSet<String> defaultHiddenStrings = new TreeSet<String>();
    private static final SortedSet<String> defaultHiddenPrefixes = new TreeSet<String>();
    public static final String SERVER_CONNECTION_TIMEOUT = "jmx.remote.x.server.connection.timeout";
    public static final String CLIENT_CONNECTION_CHECK_PERIOD = "jmx.remote.x.client.connection.check.period";
    public static final String JMX_SERVER_DAEMON = "jmx.remote.x.daemon";
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "EnvHelp");

    public static ClassLoader resolveServerClassLoader(Map<String, ?> env, MBeanServer mbs) throws InstanceNotFoundException {
        if (env == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        Object loader = env.get(DEFAULT_CLASS_LOADER);
        Object name = env.get(DEFAULT_CLASS_LOADER_NAME);
        if (loader != null && name != null) {
            String msg = "Only one of jmx.remote.default.class.loader or jmx.remote.default.class.loader.name should be specified.";
            throw new IllegalArgumentException("Only one of jmx.remote.default.class.loader or jmx.remote.default.class.loader.name should be specified.");
        }
        if (loader == null && name == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        if (loader != null) {
            if (loader instanceof ClassLoader) {
                return (ClassLoader)loader;
            }
            String msg = "ClassLoader object is not an instance of " + ClassLoader.class.getName() + " : " + loader.getClass().getName();
            throw new IllegalArgumentException(msg);
        }
        if (!(name instanceof ObjectName)) {
            String msg = "ClassLoader name is not an instance of " + ObjectName.class.getName() + " : " + name.getClass().getName();
            throw new IllegalArgumentException(msg);
        }
        ObjectName on = (ObjectName)name;
        if (mbs == null) {
            throw new IllegalArgumentException("Null MBeanServer object");
        }
        return mbs.getClassLoader(on);
    }

    public static ClassLoader resolveClientClassLoader(Map<String, ?> env) {
        if (env == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        Object loader = env.get(DEFAULT_CLASS_LOADER);
        if (loader == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        if (loader instanceof ClassLoader) {
            return (ClassLoader)loader;
        }
        String msg = "ClassLoader object is not an instance of " + ClassLoader.class.getName() + " : " + loader.getClass().getName();
        throw new IllegalArgumentException(msg);
    }

    public static <T extends Throwable> T initCause(T throwable, Throwable cause) {
        throwable.initCause(cause);
        return throwable;
    }

    public static Throwable getCause(Throwable t) {
        Throwable ret = t;
        try {
            Method getCause = t.getClass().getMethod("getCause", null);
            ret = (Throwable)getCause.invoke(t, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret != null ? ret : t;
    }

    public static int getNotifBufferSize(Map<String, ?> env) {
        int defaultQueueSize = 1000;
        String oldP = "jmx.remote.x.buffer.size";
        try {
            GetPropertyAction act = new GetPropertyAction(BUFFER_SIZE_PROPERTY);
            String s = AccessController.doPrivileged(act);
            if (s != null) {
                defaultQueueSize = Integer.parseInt(s);
            } else {
                act = new GetPropertyAction("jmx.remote.x.buffer.size");
                s = AccessController.doPrivileged(act);
                if (s != null) {
                    defaultQueueSize = Integer.parseInt(s);
                }
            }
        }
        catch (RuntimeException e) {
            logger.warning("getNotifBufferSize", "Can't use System property jmx.remote.x.notification.buffer.size: " + e);
            logger.debug("getNotifBufferSize", e);
        }
        int queueSize = defaultQueueSize;
        try {
            queueSize = env.containsKey(BUFFER_SIZE_PROPERTY) ? (int)EnvHelp.getIntegerAttribute(env, BUFFER_SIZE_PROPERTY, defaultQueueSize, 0L, Integer.MAX_VALUE) : (int)EnvHelp.getIntegerAttribute(env, "jmx.remote.x.buffer.size", defaultQueueSize, 0L, Integer.MAX_VALUE);
        }
        catch (RuntimeException e) {
            logger.warning("getNotifBufferSize", "Can't determine queuesize (using default): " + e);
            logger.debug("getNotifBufferSize", e);
        }
        return queueSize;
    }

    public static int getMaxFetchNotifNumber(Map<String, ?> env) {
        return (int)EnvHelp.getIntegerAttribute(env, MAX_FETCH_NOTIFS, 1000L, 1L, Integer.MAX_VALUE);
    }

    public static long getFetchTimeout(Map<String, ?> env) {
        return EnvHelp.getIntegerAttribute(env, FETCH_TIMEOUT, 60000L, 0L, Long.MAX_VALUE);
    }

    public static NotificationAccessController getNotificationAccessController(Map<String, ?> env) {
        return env == null ? null : (NotificationAccessController)env.get(NOTIF_ACCESS_CONTROLLER);
    }

    public static long getIntegerAttribute(Map<String, ?> env, String name, long defaultValue, long minValue, long maxValue) {
        long result;
        Object o;
        if (env == null || (o = env.get(name)) == null) {
            return defaultValue;
        }
        if (o instanceof Number) {
            result = ((Number)o).longValue();
        } else if (o instanceof String) {
            result = Long.parseLong((String)o);
        } else {
            String msg = "Attribute " + name + " value must be Integer or String: " + o;
            throw new IllegalArgumentException(msg);
        }
        if (result < minValue) {
            String msg = "Attribute " + name + " value must be at least " + minValue + ": " + result;
            throw new IllegalArgumentException(msg);
        }
        if (result > maxValue) {
            String msg = "Attribute " + name + " value must be at most " + maxValue + ": " + result;
            throw new IllegalArgumentException(msg);
        }
        return result;
    }

    public static void checkAttributes(Map<?, ?> attributes) {
        for (Object key : attributes.keySet()) {
            if (key instanceof String) continue;
            String msg = "Attributes contain key that is not a string: " + key;
            throw new IllegalArgumentException(msg);
        }
    }

    public static <V> Map<String, V> filterAttributes(Map<String, V> attributes) {
        if (logger.traceOn()) {
            logger.trace("filterAttributes", "starts");
        }
        TreeMap<String, V> map = new TreeMap<String, V>(attributes);
        EnvHelp.purgeUnserializable(map.values());
        EnvHelp.hideAttributes(map);
        return map;
    }

    private static void purgeUnserializable(Collection<?> objects) {
        logger.trace("purgeUnserializable", "starts");
        ObjectOutputStream oos = null;
        int i = 0;
        Iterator<?> it = objects.iterator();
        while (it.hasNext()) {
            Object v = it.next();
            if (v == null || v instanceof String) {
                if (logger.traceOn()) {
                    logger.trace("purgeUnserializable", "Value trivially serializable: " + v);
                }
            } else {
                try {
                    if (oos == null) {
                        oos = new ObjectOutputStream(new SinkOutputStream());
                    }
                    oos.writeObject(v);
                    if (logger.traceOn()) {
                        logger.trace("purgeUnserializable", "Value serializable: " + v);
                    }
                }
                catch (IOException e) {
                    if (logger.traceOn()) {
                        logger.trace("purgeUnserializable", "Value not serializable: " + v + ": " + e);
                    }
                    it.remove();
                    oos = null;
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void hideAttributes(SortedMap<String, ?> map) {
        SortedSet<String> hiddenPrefixes;
        SortedSet<String> hiddenStrings;
        if (map.isEmpty()) {
            return;
        }
        String hide = (String)map.get(HIDDEN_ATTRIBUTES);
        if (hide != null) {
            hide = hide.startsWith("=") ? hide.substring(1) : hide + " java.naming.security.* jmx.remote.authenticator jmx.remote.context jmx.remote.default.class.loader jmx.remote.message.connection.server jmx.remote.object.wrapping jmx.remote.rmi.client.socket.factory jmx.remote.rmi.server.socket.factory jmx.remote.sasl.callback.handler jmx.remote.tls.socket.factory jmx.remote.x.access.file jmx.remote.x.password.file ";
            hiddenStrings = new TreeSet<String>();
            hiddenPrefixes = new TreeSet<String>();
            EnvHelp.parseHiddenAttributes(hide, hiddenStrings, hiddenPrefixes);
        } else {
            hide = DEFAULT_HIDDEN_ATTRIBUTES;
            SortedSet<String> sortedSet = defaultHiddenStrings;
            synchronized (sortedSet) {
                if (defaultHiddenStrings.isEmpty()) {
                    EnvHelp.parseHiddenAttributes(hide, defaultHiddenStrings, defaultHiddenPrefixes);
                }
                hiddenStrings = defaultHiddenStrings;
                hiddenPrefixes = defaultHiddenPrefixes;
            }
        }
        String sentinelKey = map.lastKey() + "X";
        Iterator<String> keyIterator = map.keySet().iterator();
        Iterator stringIterator = hiddenStrings.iterator();
        Iterator prefixIterator = hiddenPrefixes.iterator();
        String nextString = stringIterator.hasNext() ? (String)stringIterator.next() : sentinelKey;
        String nextPrefix = prefixIterator.hasNext() ? (String)prefixIterator.next() : sentinelKey;
        block3: while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            int cmp = 1;
            while ((cmp = nextString.compareTo(key)) < 0) {
                if (stringIterator.hasNext()) {
                    nextString = (String)stringIterator.next();
                    continue;
                }
                nextString = sentinelKey;
            }
            if (cmp == 0) {
                keyIterator.remove();
                continue;
            }
            while (nextPrefix.compareTo(key) <= 0) {
                if (key.startsWith(nextPrefix)) {
                    keyIterator.remove();
                    continue block3;
                }
                if (prefixIterator.hasNext()) {
                    nextPrefix = (String)prefixIterator.next();
                    continue;
                }
                nextPrefix = sentinelKey;
            }
        }
    }

    private static void parseHiddenAttributes(String hide, SortedSet<String> hiddenStrings, SortedSet<String> hiddenPrefixes) {
        StringTokenizer tok = new StringTokenizer(hide);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s.endsWith("*")) {
                hiddenPrefixes.add(s.substring(0, s.length() - 1));
                continue;
            }
            hiddenStrings.add(s);
        }
    }

    public static long getServerConnectionTimeout(Map<String, ?> env) {
        return EnvHelp.getIntegerAttribute(env, SERVER_CONNECTION_TIMEOUT, 120000L, 0L, Long.MAX_VALUE);
    }

    public static long getConnectionCheckPeriod(Map<String, ?> env) {
        return EnvHelp.getIntegerAttribute(env, CLIENT_CONNECTION_CHECK_PERIOD, 60000L, 0L, Long.MAX_VALUE);
    }

    public static boolean computeBooleanFromString(String stringBoolean) {
        return EnvHelp.computeBooleanFromString(stringBoolean, false);
    }

    public static boolean computeBooleanFromString(String stringBoolean, boolean defaultValue) {
        if (stringBoolean == null) {
            return defaultValue;
        }
        if (stringBoolean.equalsIgnoreCase("true")) {
            return true;
        }
        if (stringBoolean.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("Property value must be \"true\" or \"false\" instead of \"" + stringBoolean + "\"");
    }

    public static <K, V> Hashtable<K, V> mapToHashtable(Map<K, V> map) {
        HashMap<K, V> m = new HashMap<K, V>(map);
        if (m.containsKey(null)) {
            m.remove(null);
        }
        Iterator<V> i = m.values().iterator();
        while (i.hasNext()) {
            if (i.next() != null) continue;
            i.remove();
        }
        return new Hashtable<K, V>(m);
    }

    public static boolean isServerDaemon(Map<String, ?> env) {
        return env != null && "true".equalsIgnoreCase((String)env.get(JMX_SERVER_DAEMON));
    }

    private static final class SinkOutputStream
    extends OutputStream {
        private SinkOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(int b) {
        }
    }
}

