/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Obj;
import java.util.EventObject;
import java.util.Vector;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.ldap.UnsolicitedNotificationEvent;
import javax.naming.ldap.UnsolicitedNotificationListener;

final class EventQueue
implements Runnable {
    private static final boolean debug = false;
    private QueueElement head = null;
    private QueueElement tail = null;
    private Thread qThread = Obj.helper.createThread(this);

    EventQueue() {
        this.qThread.setDaemon(true);
        this.qThread.start();
    }

    synchronized void enqueue(EventObject event, Vector vector) {
        QueueElement newElt = new QueueElement(event, vector);
        if (this.head == null) {
            this.head = newElt;
            this.tail = newElt;
        } else {
            newElt.next = this.head;
            this.head.prev = newElt;
            this.head = newElt;
        }
        this.notify();
    }

    private synchronized QueueElement dequeue() throws InterruptedException {
        while (this.tail == null) {
            this.wait();
        }
        QueueElement elt = this.tail;
        this.tail = elt.prev;
        if (this.tail == null) {
            this.head = null;
        } else {
            this.tail.next = null;
        }
        elt.next = null;
        elt.prev = null;
        return elt;
    }

    @Override
    public void run() {
        try {
            QueueElement qe;
            while ((qe = this.dequeue()) != null) {
                EventObject e = qe.event;
                Vector v = qe.vector;
                for (int i = 0; i < v.size(); ++i) {
                    if (e instanceof NamingEvent) {
                        ((NamingEvent)e).dispatch((NamingListener)v.elementAt(i));
                        continue;
                    }
                    if (e instanceof NamingExceptionEvent) {
                        ((NamingExceptionEvent)e).dispatch((NamingListener)v.elementAt(i));
                        continue;
                    }
                    if (!(e instanceof UnsolicitedNotificationEvent)) continue;
                    ((UnsolicitedNotificationEvent)e).dispatch((UnsolicitedNotificationListener)v.elementAt(i));
                }
                qe = null;
                e = null;
                Object var3_4 = null;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void stop() {
        if (this.qThread != null) {
            this.qThread.interrupt();
            this.qThread = null;
        }
    }

    private static class QueueElement {
        QueueElement next = null;
        QueueElement prev = null;
        EventObject event = null;
        Vector vector = null;

        QueueElement(EventObject event, Vector vector) {
            this.event = event;
            this.vector = vector;
        }
    }
}

