/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.EventQueue;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import sun.awt.EventListenerAggregate;

public class Clipboard {
    String name;
    protected ClipboardOwner owner;
    protected Transferable contents;
    private EventListenerAggregate flavorListeners;
    private Set currentDataFlavors;

    public Clipboard(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setContents(Transferable contents, ClipboardOwner owner) {
        final ClipboardOwner oldOwner = this.owner;
        final Transferable oldContents = this.contents;
        this.owner = owner;
        this.contents = contents;
        if (oldOwner != null && oldOwner != owner) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    oldOwner.lostOwnership(Clipboard.this, oldContents);
                }
            });
        }
        this.fireFlavorsChanged();
    }

    public synchronized Transferable getContents(Object requestor) {
        return this.contents;
    }

    public DataFlavor[] getAvailableDataFlavors() {
        Transferable cntnts = this.getContents(null);
        if (cntnts == null) {
            return new DataFlavor[0];
        }
        return cntnts.getTransferDataFlavors();
    }

    public boolean isDataFlavorAvailable(DataFlavor flavor) {
        if (flavor == null) {
            throw new NullPointerException("flavor");
        }
        Transferable cntnts = this.getContents(null);
        if (cntnts == null) {
            return false;
        }
        return cntnts.isDataFlavorSupported(flavor);
    }

    public Object getData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor == null) {
            throw new NullPointerException("flavor");
        }
        Transferable cntnts = this.getContents(null);
        if (cntnts == null) {
            throw new UnsupportedFlavorException(flavor);
        }
        return cntnts.getTransferData(flavor);
    }

    public synchronized void addFlavorListener(FlavorListener listener) {
        if (listener == null) {
            return;
        }
        if (this.flavorListeners == null) {
            this.currentDataFlavors = this.getAvailableDataFlavorSet();
            this.flavorListeners = new EventListenerAggregate(FlavorListener.class);
        }
        this.flavorListeners.add(listener);
    }

    public synchronized void removeFlavorListener(FlavorListener listener) {
        if (listener == null || this.flavorListeners == null) {
            return;
        }
        this.flavorListeners.remove(listener);
    }

    public synchronized FlavorListener[] getFlavorListeners() {
        return this.flavorListeners == null ? new FlavorListener[]{} : (FlavorListener[])this.flavorListeners.getListenersCopy();
    }

    private void fireFlavorsChanged() {
        if (this.flavorListeners == null) {
            return;
        }
        Set prevDataFlavors = this.currentDataFlavors;
        this.currentDataFlavors = this.getAvailableDataFlavorSet();
        if (prevDataFlavors.equals(this.currentDataFlavors)) {
            return;
        }
        FlavorListener[] flavorListenerArray = (FlavorListener[])this.flavorListeners.getListenersInternal();
        for (int i = 0; i < flavorListenerArray.length; ++i) {
            final FlavorListener listener = flavorListenerArray[i];
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    listener.flavorsChanged(new FlavorEvent(Clipboard.this));
                }
            });
        }
    }

    private Set getAvailableDataFlavorSet() {
        DataFlavor[] flavors;
        HashSet<DataFlavor> set = new HashSet<DataFlavor>();
        Transferable contents = this.getContents(null);
        if (contents != null && (flavors = contents.getTransferDataFlavors()) != null) {
            set.addAll(Arrays.asList(flavors));
        }
        return set;
    }
}

