/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import sun.swing.DefaultLookup;

public class BasicSplitPaneDivider
extends Container
implements PropertyChangeListener {
    protected static final int ONE_TOUCH_SIZE = 6;
    protected static final int ONE_TOUCH_OFFSET = 2;
    protected DragController dragger;
    protected BasicSplitPaneUI splitPaneUI;
    protected int dividerSize = 0;
    protected Component hiddenDivider;
    protected JSplitPane splitPane;
    protected MouseHandler mouseHandler;
    protected int orientation;
    protected JButton leftButton;
    protected JButton rightButton;
    private Border border;
    private boolean mouseOver;
    private int oneTouchSize;
    private int oneTouchOffset;
    private boolean centerOneTouchButtons;

    public BasicSplitPaneDivider(BasicSplitPaneUI ui) {
        this.oneTouchSize = DefaultLookup.getInt(ui.getSplitPane(), ui, "SplitPane.oneTouchButtonSize", 6);
        this.oneTouchOffset = DefaultLookup.getInt(ui.getSplitPane(), ui, "SplitPane.oneTouchButtonOffset", 2);
        this.centerOneTouchButtons = DefaultLookup.getBoolean(ui.getSplitPane(), ui, "SplitPane.centerOneTouchButtons", true);
        this.setLayout(new DividerLayout());
        this.setBasicSplitPaneUI(ui);
        this.orientation = this.splitPane.getOrientation();
        this.setCursor(this.orientation == 1 ? Cursor.getPredefinedCursor(11) : Cursor.getPredefinedCursor(9));
        this.setBackground(UIManager.getColor("SplitPane.background"));
    }

    private void revalidateSplitPane() {
        this.invalidate();
        if (this.splitPane != null) {
            this.splitPane.revalidate();
        }
    }

    public void setBasicSplitPaneUI(BasicSplitPaneUI newUI) {
        if (this.splitPane != null) {
            this.splitPane.removePropertyChangeListener(this);
            if (this.mouseHandler != null) {
                this.splitPane.removeMouseListener(this.mouseHandler);
                this.splitPane.removeMouseMotionListener(this.mouseHandler);
                this.removeMouseListener(this.mouseHandler);
                this.removeMouseMotionListener(this.mouseHandler);
                this.mouseHandler = null;
            }
        }
        this.splitPaneUI = newUI;
        if (newUI != null) {
            this.splitPane = newUI.getSplitPane();
            if (this.splitPane != null) {
                if (this.mouseHandler == null) {
                    this.mouseHandler = new MouseHandler();
                }
                this.splitPane.addMouseListener(this.mouseHandler);
                this.splitPane.addMouseMotionListener(this.mouseHandler);
                this.addMouseListener(this.mouseHandler);
                this.addMouseMotionListener(this.mouseHandler);
                this.splitPane.addPropertyChangeListener(this);
                if (this.splitPane.isOneTouchExpandable()) {
                    this.oneTouchExpandableChanged();
                }
            }
        } else {
            this.splitPane = null;
        }
    }

    public BasicSplitPaneUI getBasicSplitPaneUI() {
        return this.splitPaneUI;
    }

    public void setDividerSize(int newSize) {
        this.dividerSize = newSize;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setBorder(Border border) {
        Border oldBorder = this.border;
        this.border = border;
    }

    public Border getBorder() {
        return this.border;
    }

    @Override
    public Insets getInsets() {
        Border border = this.getBorder();
        if (border != null) {
            return border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    protected void setMouseOver(boolean mouseOver) {
        this.mouseOver = mouseOver;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.orientation == 1) {
            return new Dimension(this.getDividerSize(), 1);
        }
        return new Dimension(1, this.getDividerSize());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.splitPane) {
            if (e.getPropertyName() == "orientation") {
                this.orientation = this.splitPane.getOrientation();
                this.setCursor(this.orientation == 1 ? Cursor.getPredefinedCursor(11) : Cursor.getPredefinedCursor(9));
                this.revalidateSplitPane();
            } else if (e.getPropertyName() == "oneTouchExpandable") {
                this.oneTouchExpandableChanged();
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Border border = this.getBorder();
        if (border != null) {
            Dimension size = this.getSize();
            border.paintBorder(this, g, 0, 0, size.width, size.height);
        }
    }

    protected void oneTouchExpandableChanged() {
        if (!DefaultLookup.getBoolean(this.splitPane, this.splitPaneUI, "SplitPane.supportsOneTouchButtons", true)) {
            return;
        }
        if (this.splitPane.isOneTouchExpandable() && this.leftButton == null && this.rightButton == null) {
            this.leftButton = this.createLeftOneTouchButton();
            if (this.leftButton != null) {
                this.leftButton.addActionListener(new OneTouchActionHandler(true));
            }
            this.rightButton = this.createRightOneTouchButton();
            if (this.rightButton != null) {
                this.rightButton.addActionListener(new OneTouchActionHandler(false));
            }
            if (this.leftButton != null && this.rightButton != null) {
                this.add(this.leftButton);
                this.add(this.rightButton);
            }
        }
        this.revalidateSplitPane();
    }

    protected JButton createLeftOneTouchButton() {
        JButton b = new JButton(){

            @Override
            public void setBorder(Border b) {
            }

            @Override
            public void paint(Graphics g) {
                if (BasicSplitPaneDivider.this.splitPane != null) {
                    int[] xs = new int[3];
                    int[] ys = new int[3];
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(Color.black);
                    if (BasicSplitPaneDivider.this.orientation == 0) {
                        int blockSize;
                        xs[0] = blockSize = Math.min(this.getHeight(), BasicSplitPaneDivider.this.oneTouchSize);
                        xs[1] = 0;
                        xs[2] = blockSize << 1;
                        ys[0] = 0;
                        ys[1] = ys[2] = blockSize;
                        g.drawPolygon(xs, ys, 3);
                    } else {
                        int blockSize;
                        xs[0] = xs[2] = (blockSize = Math.min(this.getWidth(), BasicSplitPaneDivider.this.oneTouchSize));
                        xs[1] = 0;
                        ys[0] = 0;
                        ys[1] = blockSize;
                        ys[2] = blockSize << 1;
                    }
                    g.fillPolygon(xs, ys, 3);
                }
            }

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.setMinimumSize(new Dimension(this.oneTouchSize, this.oneTouchSize));
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }

    protected JButton createRightOneTouchButton() {
        JButton b = new JButton(){

            @Override
            public void setBorder(Border border) {
            }

            @Override
            public void paint(Graphics g) {
                if (BasicSplitPaneDivider.this.splitPane != null) {
                    int[] xs = new int[3];
                    int[] ys = new int[3];
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (BasicSplitPaneDivider.this.orientation == 0) {
                        int blockSize;
                        xs[0] = blockSize = Math.min(this.getHeight(), BasicSplitPaneDivider.this.oneTouchSize);
                        xs[1] = blockSize << 1;
                        xs[2] = 0;
                        ys[0] = blockSize;
                        ys[2] = 0;
                        ys[1] = 0;
                    } else {
                        int blockSize = Math.min(this.getWidth(), BasicSplitPaneDivider.this.oneTouchSize);
                        xs[2] = 0;
                        xs[0] = 0;
                        xs[1] = blockSize;
                        ys[0] = 0;
                        ys[1] = blockSize;
                        ys[2] = blockSize << 1;
                    }
                    g.setColor(Color.black);
                    g.fillPolygon(xs, ys, 3);
                }
            }

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.setMinimumSize(new Dimension(this.oneTouchSize, this.oneTouchSize));
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }

    protected void prepareForDragging() {
        this.splitPaneUI.startDragging();
    }

    protected void dragDividerTo(int location) {
        this.splitPaneUI.dragDividerTo(location);
    }

    protected void finishDraggingTo(int location) {
        this.splitPaneUI.finishDraggingTo(location);
    }

    private class OneTouchActionHandler
    implements ActionListener {
        private boolean toMinimum;

        OneTouchActionHandler(boolean toMinimum) {
            this.toMinimum = toMinimum;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int newLoc;
            Insets insets = BasicSplitPaneDivider.this.splitPane.getInsets();
            int lastLoc = BasicSplitPaneDivider.this.splitPane.getLastDividerLocation();
            int currentLoc = BasicSplitPaneDivider.this.splitPaneUI.getDividerLocation(BasicSplitPaneDivider.this.splitPane);
            if (this.toMinimum) {
                if (BasicSplitPaneDivider.this.orientation == 0) {
                    if (currentLoc >= BasicSplitPaneDivider.this.splitPane.getHeight() - insets.bottom - BasicSplitPaneDivider.this.getHeight()) {
                        int maxLoc = BasicSplitPaneDivider.this.splitPane.getMaximumDividerLocation();
                        newLoc = Math.min(lastLoc, maxLoc);
                        BasicSplitPaneDivider.this.splitPaneUI.setKeepHidden(false);
                    } else {
                        newLoc = insets.top;
                        BasicSplitPaneDivider.this.splitPaneUI.setKeepHidden(true);
                    }
                } else if (currentLoc >= BasicSplitPaneDivider.this.splitPane.getWidth() - insets.right - BasicSplitPaneDivider.this.getWidth()) {
                    int maxLoc = BasicSplitPaneDivider.this.splitPane.getMaximumDividerLocation();
                    newLoc = Math.min(lastLoc, maxLoc);
                    BasicSplitPaneDivider.this.splitPaneUI.setKeepHidden(false);
                } else {
                    newLoc = insets.left;
                    BasicSplitPaneDivider.this.splitPaneUI.setKeepHidden(true);
                }
            } else if (BasicSplitPaneDivider.this.orientation == 0) {
                if (currentLoc == insets.top) {
                    int maxLoc = BasicSplitPaneDivider.this.splitPane.getMaximumDividerLocation();
                    newLoc = Math.min(lastLoc, maxLoc);
                    BasicSplitPaneDivider.this.splitPaneUI.setKeepHidden(false);
                } else {
                    newLoc = BasicSplitPaneDivider.this.splitPane.getHeight() - BasicSplitPaneDivider.this.getHeight() - insets.top;
                    BasicSplitPaneDivider.this.splitPaneUI.setKeepHidden(true);
                }
            } else if (currentLoc == insets.left) {
                int maxLoc = BasicSplitPaneDivider.this.splitPane.getMaximumDividerLocation();
                newLoc = Math.min(lastLoc, maxLoc);
                BasicSplitPaneDivider.this.splitPaneUI.setKeepHidden(false);
            } else {
                newLoc = BasicSplitPaneDivider.this.splitPane.getWidth() - BasicSplitPaneDivider.this.getWidth() - insets.left;
                BasicSplitPaneDivider.this.splitPaneUI.setKeepHidden(true);
            }
            if (currentLoc != newLoc) {
                BasicSplitPaneDivider.this.splitPane.setDividerLocation(newLoc);
                BasicSplitPaneDivider.this.splitPane.setLastDividerLocation(currentLoc);
            }
        }
    }

    protected class DividerLayout
    implements LayoutManager {
        protected DividerLayout() {
        }

        @Override
        public void layoutContainer(Container c) {
            if (BasicSplitPaneDivider.this.leftButton != null && BasicSplitPaneDivider.this.rightButton != null && c == BasicSplitPaneDivider.this) {
                if (BasicSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = BasicSplitPaneDivider.this.getInsets();
                    if (BasicSplitPaneDivider.this.orientation == 0) {
                        int extraX = insets != null ? insets.left : 0;
                        int blockSize = BasicSplitPaneDivider.this.getHeight();
                        if (insets != null) {
                            blockSize -= insets.top + insets.bottom;
                            blockSize = Math.max(blockSize, 0);
                        }
                        blockSize = Math.min(blockSize, BasicSplitPaneDivider.this.oneTouchSize);
                        int y = (c.getSize().height - blockSize) / 2;
                        if (!BasicSplitPaneDivider.this.centerOneTouchButtons) {
                            y = insets != null ? insets.top : 0;
                            extraX = 0;
                        }
                        BasicSplitPaneDivider.this.leftButton.setBounds(extraX + BasicSplitPaneDivider.this.oneTouchOffset, y, blockSize * 2, blockSize);
                        BasicSplitPaneDivider.this.rightButton.setBounds(extraX + BasicSplitPaneDivider.this.oneTouchOffset + BasicSplitPaneDivider.this.oneTouchSize * 2, y, blockSize * 2, blockSize);
                    } else {
                        int extraY = insets != null ? insets.top : 0;
                        int blockSize = BasicSplitPaneDivider.this.getWidth();
                        if (insets != null) {
                            blockSize -= insets.left + insets.right;
                            blockSize = Math.max(blockSize, 0);
                        }
                        blockSize = Math.min(blockSize, BasicSplitPaneDivider.this.oneTouchSize);
                        int x = (c.getSize().width - blockSize) / 2;
                        if (!BasicSplitPaneDivider.this.centerOneTouchButtons) {
                            x = insets != null ? insets.left : 0;
                            extraY = 0;
                        }
                        BasicSplitPaneDivider.this.leftButton.setBounds(x, extraY + BasicSplitPaneDivider.this.oneTouchOffset, blockSize, blockSize * 2);
                        BasicSplitPaneDivider.this.rightButton.setBounds(x, extraY + BasicSplitPaneDivider.this.oneTouchOffset + BasicSplitPaneDivider.this.oneTouchSize * 2, blockSize, blockSize * 2);
                    }
                } else {
                    BasicSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    BasicSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int width;
            if (c != BasicSplitPaneDivider.this || BasicSplitPaneDivider.this.splitPane == null) {
                return new Dimension(0, 0);
            }
            Dimension buttonMinSize = null;
            if (BasicSplitPaneDivider.this.splitPane.isOneTouchExpandable() && BasicSplitPaneDivider.this.leftButton != null) {
                buttonMinSize = BasicSplitPaneDivider.this.leftButton.getMinimumSize();
            }
            Insets insets = BasicSplitPaneDivider.this.getInsets();
            int height = width = BasicSplitPaneDivider.this.getDividerSize();
            if (BasicSplitPaneDivider.this.orientation == 0) {
                if (buttonMinSize != null) {
                    int size = buttonMinSize.height;
                    if (insets != null) {
                        size += insets.top + insets.bottom;
                    }
                    height = Math.max(height, size);
                }
                width = 1;
            } else {
                if (buttonMinSize != null) {
                    int size = buttonMinSize.width;
                    if (insets != null) {
                        size += insets.left + insets.right;
                    }
                    width = Math.max(width, size);
                }
                height = 1;
            }
            return new Dimension(width, height);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public void addLayoutComponent(String string, Component c) {
        }
    }

    protected class VerticalDragController
    extends DragController {
        protected VerticalDragController(MouseEvent e) {
            super(e);
            JSplitPane splitPane = BasicSplitPaneDivider.this.splitPaneUI.getSplitPane();
            Component leftC = splitPane.getLeftComponent();
            Component rightC = splitPane.getRightComponent();
            this.initialX = BasicSplitPaneDivider.this.getLocation().y;
            this.offset = e.getSource() == BasicSplitPaneDivider.this ? e.getY() : e.getY() - this.initialX;
            if (leftC == null || rightC == null || this.offset < -1 || this.offset > BasicSplitPaneDivider.this.getSize().height) {
                this.maxX = -1;
            } else {
                Insets insets = splitPane.getInsets();
                if (leftC.isVisible()) {
                    this.minX = leftC.getMinimumSize().height;
                    if (insets != null) {
                        this.minX += insets.top;
                    }
                } else {
                    this.minX = 0;
                }
                if (rightC.isVisible()) {
                    int bottom = insets != null ? insets.bottom : 0;
                    this.maxX = Math.max(0, splitPane.getSize().height - (BasicSplitPaneDivider.this.getSize().height + bottom) - rightC.getMinimumSize().height);
                } else {
                    int bottom = insets != null ? insets.bottom : 0;
                    this.maxX = Math.max(0, splitPane.getSize().height - (BasicSplitPaneDivider.this.getSize().height + bottom));
                }
                if (this.maxX < this.minX) {
                    this.maxX = 0;
                    this.minX = 0;
                }
            }
        }

        @Override
        protected int getNeededLocation(int x, int y) {
            int newY = Math.min(this.maxX, Math.max(this.minX, y - this.offset));
            return newY;
        }

        @Override
        protected int positionForMouseEvent(MouseEvent e) {
            int newY = e.getSource() == BasicSplitPaneDivider.this ? e.getY() + BasicSplitPaneDivider.this.getLocation().y : e.getY();
            newY = Math.min(this.maxX, Math.max(this.minX, newY - this.offset));
            return newY;
        }
    }

    protected class DragController {
        int initialX;
        int maxX;
        int minX;
        int offset;

        protected DragController(MouseEvent e) {
            JSplitPane splitPane = BasicSplitPaneDivider.this.splitPaneUI.getSplitPane();
            Component leftC = splitPane.getLeftComponent();
            Component rightC = splitPane.getRightComponent();
            this.initialX = BasicSplitPaneDivider.this.getLocation().x;
            this.offset = e.getSource() == BasicSplitPaneDivider.this ? e.getX() : e.getX() - this.initialX;
            if (leftC == null || rightC == null || this.offset < -1 || this.offset >= BasicSplitPaneDivider.this.getSize().width) {
                this.maxX = -1;
            } else {
                Insets insets = splitPane.getInsets();
                if (leftC.isVisible()) {
                    this.minX = leftC.getMinimumSize().width;
                    if (insets != null) {
                        this.minX += insets.left;
                    }
                } else {
                    this.minX = 0;
                }
                if (rightC.isVisible()) {
                    int right = insets != null ? insets.right : 0;
                    this.maxX = Math.max(0, splitPane.getSize().width - (BasicSplitPaneDivider.this.getSize().width + right) - rightC.getMinimumSize().width);
                } else {
                    int right = insets != null ? insets.right : 0;
                    this.maxX = Math.max(0, splitPane.getSize().width - (BasicSplitPaneDivider.this.getSize().width + right));
                }
                if (this.maxX < this.minX) {
                    this.maxX = 0;
                    this.minX = 0;
                }
            }
        }

        protected boolean isValid() {
            return this.maxX > 0;
        }

        protected int positionForMouseEvent(MouseEvent e) {
            int newX = e.getSource() == BasicSplitPaneDivider.this ? e.getX() + BasicSplitPaneDivider.this.getLocation().x : e.getX();
            newX = Math.min(this.maxX, Math.max(this.minX, newX - this.offset));
            return newX;
        }

        protected int getNeededLocation(int x, int y) {
            int newX = Math.min(this.maxX, Math.max(this.minX, x - this.offset));
            return newX;
        }

        protected void continueDrag(int newX, int newY) {
            BasicSplitPaneDivider.this.dragDividerTo(this.getNeededLocation(newX, newY));
        }

        protected void continueDrag(MouseEvent e) {
            BasicSplitPaneDivider.this.dragDividerTo(this.positionForMouseEvent(e));
        }

        protected void completeDrag(int x, int y) {
            BasicSplitPaneDivider.this.finishDraggingTo(this.getNeededLocation(x, y));
        }

        protected void completeDrag(MouseEvent e) {
            BasicSplitPaneDivider.this.finishDraggingTo(this.positionForMouseEvent(e));
        }
    }

    protected class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if ((e.getSource() == BasicSplitPaneDivider.this || e.getSource() == BasicSplitPaneDivider.this.splitPane) && BasicSplitPaneDivider.this.dragger == null && BasicSplitPaneDivider.this.splitPane.isEnabled()) {
                Component newHiddenDivider = BasicSplitPaneDivider.this.splitPaneUI.getNonContinuousLayoutDivider();
                if (BasicSplitPaneDivider.this.hiddenDivider != newHiddenDivider) {
                    if (BasicSplitPaneDivider.this.hiddenDivider != null) {
                        BasicSplitPaneDivider.this.hiddenDivider.removeMouseListener(this);
                        BasicSplitPaneDivider.this.hiddenDivider.removeMouseMotionListener(this);
                    }
                    BasicSplitPaneDivider.this.hiddenDivider = newHiddenDivider;
                    if (BasicSplitPaneDivider.this.hiddenDivider != null) {
                        BasicSplitPaneDivider.this.hiddenDivider.addMouseMotionListener(this);
                        BasicSplitPaneDivider.this.hiddenDivider.addMouseListener(this);
                    }
                }
                if (BasicSplitPaneDivider.this.splitPane.getLeftComponent() != null && BasicSplitPaneDivider.this.splitPane.getRightComponent() != null) {
                    BasicSplitPaneDivider.this.dragger = BasicSplitPaneDivider.this.orientation == 1 ? new DragController(e) : new VerticalDragController(e);
                    if (!BasicSplitPaneDivider.this.dragger.isValid()) {
                        BasicSplitPaneDivider.this.dragger = null;
                    } else {
                        BasicSplitPaneDivider.this.prepareForDragging();
                        BasicSplitPaneDivider.this.dragger.continueDrag(e);
                    }
                }
                e.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (BasicSplitPaneDivider.this.dragger != null) {
                if (e.getSource() == BasicSplitPaneDivider.this.splitPane) {
                    BasicSplitPaneDivider.this.dragger.completeDrag(e.getX(), e.getY());
                } else if (e.getSource() == BasicSplitPaneDivider.this) {
                    Point ourLoc = BasicSplitPaneDivider.this.getLocation();
                    BasicSplitPaneDivider.this.dragger.completeDrag(e.getX() + ourLoc.x, e.getY() + ourLoc.y);
                } else if (e.getSource() == BasicSplitPaneDivider.this.hiddenDivider) {
                    Point hDividerLoc = BasicSplitPaneDivider.this.hiddenDivider.getLocation();
                    int ourX = e.getX() + hDividerLoc.x;
                    int ourY = e.getY() + hDividerLoc.y;
                    BasicSplitPaneDivider.this.dragger.completeDrag(ourX, ourY);
                }
                BasicSplitPaneDivider.this.dragger = null;
                e.consume();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (BasicSplitPaneDivider.this.dragger != null) {
                if (e.getSource() == BasicSplitPaneDivider.this.splitPane) {
                    BasicSplitPaneDivider.this.dragger.continueDrag(e.getX(), e.getY());
                } else if (e.getSource() == BasicSplitPaneDivider.this) {
                    Point ourLoc = BasicSplitPaneDivider.this.getLocation();
                    BasicSplitPaneDivider.this.dragger.continueDrag(e.getX() + ourLoc.x, e.getY() + ourLoc.y);
                } else if (e.getSource() == BasicSplitPaneDivider.this.hiddenDivider) {
                    Point hDividerLoc = BasicSplitPaneDivider.this.hiddenDivider.getLocation();
                    int ourX = e.getX() + hDividerLoc.x;
                    int ourY = e.getY() + hDividerLoc.y;
                    BasicSplitPaneDivider.this.dragger.continueDrag(ourX, ourY);
                }
                e.consume();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (e.getSource() == BasicSplitPaneDivider.this) {
                BasicSplitPaneDivider.this.setMouseOver(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (e.getSource() == BasicSplitPaneDivider.this) {
                BasicSplitPaneDivider.this.setMouseOver(false);
            }
        }
    }
}

