/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.peer.FramePeer;
import sun.awt.AWTAccessor;
import sun.awt.X11.ToplevelStateListener;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XMenuBarPeer;
import sun.awt.X11.XNETProtocol;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XlibWrapper;
import sun.util.logging.PlatformLogger;

class XFramePeer
extends XDecoratedPeer
implements FramePeer {
    private static PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XFramePeer");
    private static PlatformLogger stateLog = PlatformLogger.getLogger("sun.awt.X11.states");
    private static PlatformLogger insLog = PlatformLogger.getLogger("sun.awt.X11.insets.XFramePeer");
    XMenuBarPeer menubarPeer;
    MenuBar menubar;
    int state;
    private Boolean undecorated;
    private static final int MENUBAR_HEIGHT_IF_NO_MENUBAR = 0;
    private int lastAppliedMenubarHeight = 0;
    static final int CROSSHAIR_INSET = 5;
    static final int BUTTON_Y = 6;
    static final int BUTTON_W = 17;
    static final int BUTTON_H = 17;
    static final int SYS_MENU_X = 6;
    static final int SYS_MENU_CONTAINED_X = 11;
    static final int SYS_MENU_CONTAINED_Y = 13;
    static final int SYS_MENU_CONTAINED_W = 8;
    static final int SYS_MENU_CONTAINED_H = 3;
    static final int MAXIMIZE_X_DIFF = 22;
    static final int MAXIMIZE_CONTAINED_X_DIFF = 17;
    static final int MAXIMIZE_CONTAINED_Y = 11;
    static final int MAXIMIZE_CONTAINED_W = 8;
    static final int MAXIMIZE_CONTAINED_H = 8;
    static final int MINIMIZE_X_DIFF = 39;
    static final int MINIMIZE_CONTAINED_X_DIFF = 32;
    static final int MINIMIZE_CONTAINED_Y = 13;
    static final int MINIMIZE_CONTAINED_W = 3;
    static final int MINIMIZE_CONTAINED_H = 3;
    static final int TITLE_X = 23;
    static final int TITLE_W_DIFF = 60;
    static final int TITLE_MID_Y = 14;
    static final int MENUBAR_X = 6;
    static final int MENUBAR_Y = 23;
    static final int HORIZ_RESIZE_INSET = 22;
    static final int VERT_RESIZE_INSET = 22;

    XFramePeer(Frame target) {
        super(target);
    }

    XFramePeer(XCreateWindowParams params) {
        super(params);
    }

    @Override
    void preInit(XCreateWindowParams params) {
        super.preInit(params);
        Frame target = (Frame)this.target;
        this.winAttr.initialState = target.getExtendedState();
        this.state = 0;
        this.undecorated = target.isUndecorated();
        boolean bl = this.winAttr.nativeDecor = !target.isUndecorated();
        this.winAttr.decorations = this.winAttr.nativeDecor ? XWindowAttributesData.AWT_DECOR_ALL : XWindowAttributesData.AWT_DECOR_NONE;
        this.winAttr.functions = 1;
        this.winAttr.isResizable = true;
        this.winAttr.title = target.getTitle();
        this.winAttr.initialResizability = target.isResizable();
        if (log.isLoggable(500)) {
            log.fine("Frame''s initial attributes: decor {0}, resizable {1}, undecorated {2}, initial state {3}", this.winAttr.decorations, this.winAttr.initialResizability, !this.winAttr.nativeDecor, this.winAttr.initialState);
        }
    }

    @Override
    void postInit(XCreateWindowParams params) {
        super.postInit(params);
        this.setupState(true);
    }

    @Override
    boolean isTargetUndecorated() {
        if (this.undecorated != null) {
            return this.undecorated;
        }
        return ((Frame)this.target).isUndecorated();
    }

    void setupState(boolean onInit) {
        if (onInit) {
            this.state = this.winAttr.initialState;
        }
        if ((this.state & 1) != 0) {
            this.setInitialState(3);
        } else {
            this.setInitialState(1);
        }
        this.setExtendedState(this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMenuBar(MenuBar mb) {
        XToolkit.awtLock();
        try {
            Object object = this.getStateLock();
            synchronized (object) {
                block12: {
                    if (mb != this.menubar) break block12;
                    return;
                }
                if (mb == null) {
                    if (this.menubar != null) {
                        this.menubarPeer.xSetVisible(false);
                        this.menubar = null;
                        this.menubarPeer.dispose();
                        this.menubarPeer = null;
                    }
                } else {
                    this.menubar = mb;
                    this.menubarPeer = (XMenuBarPeer)mb.getPeer();
                    if (this.menubarPeer != null) {
                        this.menubarPeer.init((Frame)this.target);
                    }
                }
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
        this.reshapeMenubarPeer();
    }

    XMenuBarPeer getMenubarPeer() {
        return this.menubarPeer;
    }

    @Override
    int getMenuBarHeight() {
        if (this.menubarPeer != null) {
            return this.menubarPeer.getDesiredHeight();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateChildrenSizes() {
        super.updateChildrenSizes();
        int height = this.getMenuBarHeight();
        XToolkit.awtLock();
        try {
            Object object = this.getStateLock();
            synchronized (object) {
                int width = this.dimensions.getClientSize().width;
                if (this.menubarPeer != null) {
                    this.menubarPeer.reshape(0, 0, width, height);
                }
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    final void reshapeMenubarPeer() {
        XToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                XFramePeer.this.updateChildrenSizes();
                boolean heightChanged = false;
                int height = XFramePeer.this.getMenuBarHeight();
                Object object = XFramePeer.this.getStateLock();
                synchronized (object) {
                    if (height != XFramePeer.this.lastAppliedMenubarHeight) {
                        XFramePeer.this.lastAppliedMenubarHeight = height;
                        heightChanged = true;
                    }
                }
                if (heightChanged) {
                    XFramePeer.this.target.invalidate();
                    XFramePeer.this.target.validate();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximizedBounds(Rectangle b) {
        if (insLog.isLoggable(500)) {
            insLog.fine("Setting maximized bounds to " + b);
        }
        if (b == null) {
            return;
        }
        this.maxBounds = new Rectangle(b);
        XToolkit.awtLock();
        try {
            XSizeHints hints = this.getHints();
            hints.set_flags(hints.get_flags() | 0x20L);
            if (b.width != Integer.MAX_VALUE) {
                hints.set_max_width(b.width);
            } else {
                hints.set_max_width((int)XlibWrapper.DisplayWidth(XToolkit.getDisplay(), XlibWrapper.DefaultScreen(XToolkit.getDisplay())));
            }
            if (b.height != Integer.MAX_VALUE) {
                hints.set_max_height(b.height);
            } else {
                hints.set_max_height((int)XlibWrapper.DisplayHeight(XToolkit.getDisplay(), XlibWrapper.DefaultScreen(XToolkit.getDisplay())));
            }
            if (insLog.isLoggable(400)) {
                insLog.finer("Setting hints, flags " + XlibWrapper.hintsToString(hints.get_flags()));
            }
            XlibWrapper.XSetWMNormalHints(XToolkit.getDisplay(), this.window, hints.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getState() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(int newState) {
        Object object = this.getStateLock();
        synchronized (object) {
            if (!this.isShowing()) {
                stateLog.finer("Frame is not showing");
                this.state = newState;
                return;
            }
        }
        this.changeState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeState(int newState) {
        int changed = this.state ^ newState;
        int changeIconic = changed & 1;
        boolean iconic = (newState & 1) != 0;
        stateLog.finer("Changing state, old state {0}, new state {1}(iconic {2})", this.state, newState, iconic);
        if (changeIconic != 0 && iconic) {
            if (stateLog.isLoggable(400)) {
                stateLog.finer("Iconifying shell " + this.getShell() + ", this " + this + ", screen " + this.getScreenNumber());
            }
            XToolkit.awtLock();
            try {
                int res = XlibWrapper.XIconifyWindow(XToolkit.getDisplay(), this.getShell(), this.getScreenNumber());
                if (stateLog.isLoggable(400)) {
                    stateLog.finer("XIconifyWindow returned " + res);
                }
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        if ((changed & 0xFFFFFFFE) != 0) {
            this.setExtendedState(newState);
        }
        if (changeIconic != 0 && !iconic) {
            XNETProtocol net_protocol;
            if (stateLog.isLoggable(400)) {
                stateLog.finer("DeIconifying " + this);
            }
            if ((net_protocol = XWM.getWM().getNETProtocol()) != null) {
                net_protocol.setActiveWindow(this);
            }
            this.xSetVisible(true);
        }
    }

    void setExtendedState(int newState) {
        XWM.getWM().setExtendedState(this, newState);
    }

    @Override
    public void handlePropertyNotify(XEvent xev) {
        super.handlePropertyNotify(xev);
        XPropertyEvent ev = xev.get_xproperty();
        log.finer("Property change {0}", ev);
        if (!XWM.getWM().isStateChange(this, ev)) {
            stateLog.finer("either not a state atom or state has not been changed");
            return;
        }
        int newState = XWM.getWM().getState(this);
        int changed = this.state ^ newState;
        if (changed == 0) {
            stateLog.finer("State is the same: " + this.state);
            return;
        }
        int old_state = this.state;
        this.state = newState;
        AWTAccessor.getFrameAccessor().setExtendedState((Frame)this.target, this.state);
        if ((changed & 1) != 0) {
            if ((this.state & 1) != 0) {
                stateLog.finer("Iconified");
                this.handleIconify();
            } else {
                stateLog.finer("DeIconified");
                this.content.purgeIconifiedExposeEvents();
                this.handleDeiconify();
            }
        }
        this.handleStateChange(old_state, this.state);
    }

    @Override
    public void handleStateChange(int oldState, int newState) {
        super.handleStateChange(oldState, newState);
        for (ToplevelStateListener topLevelListenerTmp : this.toplevelStateListeners) {
            topLevelListenerTmp.stateChangedJava(oldState, newState);
        }
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            this.setupState(false);
        } else if ((this.state & 6) != 0) {
            XWM.getWM().setExtendedState(this, this.state & 0xFFFFFFF9);
        }
        super.setVisible(vis);
        if (vis && this.maxBounds != null) {
            this.setMaximizedBounds(this.maxBounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInitialState(int wm_state) {
        XToolkit.awtLock();
        try {
            XWMHints hints = this.getWMHints();
            hints.set_flags(2L | hints.get_flags());
            hints.set_initial_state(wm_state);
            if (stateLog.isLoggable(500)) {
                stateLog.fine("Setting initial WM state on " + this + " to " + wm_state);
            }
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), hints.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public void dispose() {
        if (this.menubarPeer != null) {
            this.menubarPeer.dispose();
        }
        super.dispose();
    }

    @Override
    boolean isMaximized() {
        return (this.state & 6) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Graphics g) {
        XMenuBarPeer peer;
        super.print(g);
        Frame f = (Frame)this.target;
        Insets finsets = f.getInsets();
        Dimension fsize = f.getSize();
        Color bg = f.getBackground();
        Color fg = f.getForeground();
        Color highlight = bg.brighter();
        Color shadow = bg.darker();
        if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_BORDER)) {
            if (highlight.equals(Color.white)) {
                g.setColor(new Color(230, 230, 230));
            } else {
                g.setColor(highlight);
            }
            g.drawLine(0, 0, fsize.width, 0);
            g.drawLine(0, 1, fsize.width - 1, 1);
            g.drawLine(0, 0, 0, fsize.height);
            g.drawLine(1, 0, 1, fsize.height - 1);
            g.setColor(highlight);
            g.drawLine(6, fsize.height - 5, fsize.width - 5, fsize.height - 5);
            g.drawLine(fsize.width - 5, 6, fsize.width - 5, fsize.height - 5);
            g.setColor(shadow);
            g.drawLine(1, fsize.height, fsize.width, fsize.height);
            g.drawLine(2, fsize.height - 1, fsize.width, fsize.height - 1);
            g.drawLine(fsize.width, 1, fsize.width, fsize.height);
            g.drawLine(fsize.width - 1, 2, fsize.width - 1, fsize.height);
            g.drawLine(5, 5, fsize.width - 5, 5);
            g.drawLine(5, 5, 5, fsize.height - 5);
        }
        if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_TITLE)) {
            if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_MENU)) {
                g.setColor(bg);
                g.fill3DRect(6, 6, 17, 17, true);
                g.fill3DRect(11, 13, 8, 3, true);
            }
            g.fill3DRect(23, 6, fsize.width - 60, 17, true);
            if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_MINIMIZE)) {
                g.fill3DRect(fsize.width - 39, 6, 17, 17, true);
                g.fill3DRect(fsize.width - 32, 13, 3, 3, true);
            }
            if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_MAXIMIZE)) {
                g.fill3DRect(fsize.width - 22, 6, 17, 17, true);
                g.fill3DRect(fsize.width - 17, 11, 8, 8, true);
            }
            g.setColor(fg);
            Font sysfont = new Font("SansSerif", 0, 10);
            g.setFont(sysfont);
            FontMetrics sysfm = g.getFontMetrics();
            String ftitle = f.getTitle();
            g.drawString(ftitle, (46 + fsize.width - 60) / 2 - sysfm.stringWidth(ftitle) / 2, 14 + sysfm.getMaxDescent());
        }
        if (f.isResizable() && this.hasDecorations(XWindowAttributesData.AWT_DECOR_RESIZEH)) {
            g.setColor(shadow);
            g.drawLine(1, 22, 5, 22);
            g.drawLine(22, 1, 22, 5);
            g.drawLine(fsize.width - 5 + 1, 22, fsize.width, 22);
            g.drawLine(fsize.width - 22 - 1, 2, fsize.width - 22 - 1, 6);
            g.drawLine(1, fsize.height - 22 - 1, 5, fsize.height - 22 - 1);
            g.drawLine(22, fsize.height - 5 + 1, 22, fsize.height);
            g.drawLine(fsize.width - 5 + 1, fsize.height - 22 - 1, fsize.width, fsize.height - 22 - 1);
            g.drawLine(fsize.width - 22 - 1, fsize.height - 5 + 1, fsize.width - 22 - 1, fsize.height);
            g.setColor(highlight);
            g.drawLine(2, 23, 5, 23);
            g.drawLine(23, 2, 23, 5);
            g.drawLine(fsize.width - 5 + 1, 23, fsize.width - 1, 23);
            g.drawLine(fsize.width - 22, 2, fsize.width - 22, 5);
            g.drawLine(2, fsize.height - 22, 5, fsize.height - 22);
            g.drawLine(23, fsize.height - 5 + 1, 23, fsize.height - 1);
            g.drawLine(fsize.width - 5 + 1, fsize.height - 22, fsize.width - 1, fsize.height - 22);
            g.drawLine(fsize.width - 22, fsize.height - 5 + 1, fsize.width - 22, fsize.height - 1);
        }
        if ((peer = this.menubarPeer) != null) {
            Insets insets = this.getInsets();
            Graphics ng = g.create();
            int menubarX = 0;
            int menubarY = 0;
            if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_BORDER)) {
                menubarX += 6;
                menubarY += 6;
            }
            if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_TITLE)) {
                menubarY += 17;
            }
            try {
                ng.translate(menubarX, menubarY);
                peer.print(ng);
            }
            finally {
                ng.dispose();
            }
        }
    }

    @Override
    public void setBoundsPrivate(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height, 3);
    }

    @Override
    public Rectangle getBoundsPrivate() {
        return this.getBounds();
    }
}

