/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import sun.awt.X11.XAtom;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDestroyWindowEvent;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XMSelectionListener;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.util.logging.PlatformLogger;

public class XMSelection {
    private static PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XMSelection");
    String selectionName;
    Vector listeners;
    XAtom[] atoms;
    long[] owners;
    long eventMask;
    static int numScreens;
    static XAtom XA_MANAGER;
    static HashMap selectionMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initScreen(long display, final int screen) {
        XToolkit.awtLock();
        try {
            long root = XlibWrapper.RootWindow(display, screen);
            XlibWrapper.XSelectInput(display, root, 131072L);
            XToolkit.addEventDispatcher(root, new XEventDispatcher(){

                @Override
                public void dispatchEvent(XEvent ev) {
                    XMSelection.processRootEvent(ev, screen);
                }
            });
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public int getNumberOfScreens() {
        return numScreens;
    }

    void select(long extra_mask) {
        this.eventMask = extra_mask;
        for (int screen = 0; screen < numScreens; ++screen) {
            this.selectPerScreen(screen, extra_mask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetOwner(long owner, final int screen) {
        XToolkit.awtLock();
        try {
            long display = XToolkit.getDisplay();
            XMSelection xMSelection = this;
            synchronized (xMSelection) {
                this.setOwner(owner, screen);
                if (log.isLoggable(500)) {
                    log.fine("New Selection Owner for screen " + screen + " = " + owner);
                }
                XlibWrapper.XSelectInput(display, owner, 0x20000L | this.eventMask);
                XToolkit.addEventDispatcher(owner, new XEventDispatcher(){

                    @Override
                    public void dispatchEvent(XEvent ev) {
                        XMSelection.this.dispatchSelectionEvent(ev, screen);
                    }
                });
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectPerScreen(final int screen, long extra_mask) {
        XToolkit.awtLock();
        try {
            try {
                long display = XToolkit.getDisplay();
                if (log.isLoggable(500)) {
                    log.fine("Grabbing XServer");
                }
                XlibWrapper.XGrabServer(display);
                XMSelection xMSelection = this;
                synchronized (xMSelection) {
                    String selection_name = this.getName() + "_S" + screen;
                    if (log.isLoggable(500)) {
                        log.fine("Screen = " + screen + " selection name = " + selection_name);
                    }
                    XAtom atom = XAtom.get(selection_name);
                    selectionMap.put(atom.getAtom(), this);
                    this.setAtom(atom, screen);
                    long owner = XlibWrapper.XGetSelectionOwner(display, atom.getAtom());
                    if (owner != 0L) {
                        this.setOwner(owner, screen);
                        if (log.isLoggable(500)) {
                            log.fine("Selection Owner for screen " + screen + " = " + owner);
                        }
                        XlibWrapper.XSelectInput(display, owner, 0x20000L | extra_mask);
                        XToolkit.addEventDispatcher(owner, new XEventDispatcher(){

                            @Override
                            public void dispatchEvent(XEvent ev) {
                                XMSelection.this.dispatchSelectionEvent(ev, screen);
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (log.isLoggable(500)) {
                    log.fine("UnGrabbing XServer");
                }
                XlibWrapper.XUngrabServer(XToolkit.getDisplay());
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static boolean processClientMessage(XEvent xev, int screen) {
        XClientMessageEvent xce = xev.get_xclient();
        if (xce.get_message_type() == XA_MANAGER.getAtom()) {
            if (log.isLoggable(500)) {
                log.fine("client messags = " + xce);
            }
            long timestamp = xce.get_data(0);
            long atom = xce.get_data(1);
            long owner = xce.get_data(2);
            long data = xce.get_data(3);
            XMSelection sel = XMSelection.getInstance(atom);
            if (sel != null) {
                sel.resetOwner(owner, screen);
                sel.dispatchOwnerChangedEvent(xev, screen, owner, data, timestamp);
            }
        }
        return false;
    }

    static boolean processRootEvent(XEvent xev, int screen) {
        switch (xev.get_type()) {
            case 33: {
                return XMSelection.processClientMessage(xev, screen);
            }
        }
        return false;
    }

    static XMSelection getInstance(long selection) {
        return (XMSelection)selectionMap.get(selection);
    }

    public XMSelection(String selname) {
        this(selname, 0x400000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMSelection(String selname, long extraMask) {
        XMSelection xMSelection = this;
        synchronized (xMSelection) {
            this.selectionName = selname;
            this.atoms = new XAtom[this.getNumberOfScreens()];
            this.owners = new long[this.getNumberOfScreens()];
        }
        this.select(extraMask);
    }

    public synchronized void addSelectionListener(XMSelectionListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(listener);
    }

    public synchronized void removeSelectionListener(XMSelectionListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    synchronized Collection getListeners() {
        return this.listeners;
    }

    synchronized XAtom getAtom(int screen) {
        if (this.atoms != null) {
            return this.atoms[screen];
        }
        return null;
    }

    synchronized void setAtom(XAtom a, int screen) {
        if (this.atoms != null) {
            this.atoms[screen] = a;
        }
    }

    synchronized long getOwner(int screen) {
        if (this.owners != null) {
            return this.owners[screen];
        }
        return 0L;
    }

    synchronized void setOwner(long owner, int screen) {
        if (this.owners != null) {
            this.owners[screen] = owner;
        }
    }

    synchronized String getName() {
        return this.selectionName;
    }

    synchronized void dispatchSelectionChanged(XPropertyEvent ev, int screen) {
        if (log.isLoggable(500)) {
            log.fine("Selection Changed : Screen = " + screen + "Event =" + ev);
        }
        if (this.listeners != null) {
            for (XMSelectionListener disp : this.listeners) {
                disp.selectionChanged(screen, this, ev.get_window(), ev);
            }
        }
    }

    synchronized void dispatchOwnerDeath(XDestroyWindowEvent de, int screen) {
        if (log.isLoggable(500)) {
            log.fine("Owner dead : Screen = " + screen + "Event =" + de);
        }
        if (this.listeners != null) {
            for (XMSelectionListener disp : this.listeners) {
                disp.ownerDeath(screen, this, de.get_window());
            }
        }
    }

    void dispatchSelectionEvent(XEvent xev, int screen) {
        if (log.isLoggable(500)) {
            log.fine("Event =" + xev);
        }
        if (xev.get_type() == 17) {
            XDestroyWindowEvent de = xev.get_xdestroywindow();
            this.dispatchOwnerDeath(de, screen);
        } else if (xev.get_type() == 28) {
            XPropertyEvent xpe = xev.get_xproperty();
            this.dispatchSelectionChanged(xpe, screen);
        }
    }

    synchronized void dispatchOwnerChangedEvent(XEvent ev, int screen, long owner, long data, long timestamp) {
        if (this.listeners != null) {
            for (XMSelectionListener disp : this.listeners) {
                disp.ownerChanged(screen, this, owner, data, timestamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        long display = XToolkit.getDisplay();
        XToolkit.awtLock();
        try {
            numScreens = XlibWrapper.ScreenCount(display);
        }
        finally {
            XToolkit.awtUnlock();
        }
        XA_MANAGER = XAtom.get("MANAGER");
        for (int screen = 0; screen < numScreens; ++screen) {
            XMSelection.initScreen(display, screen);
        }
        selectionMap = new HashMap();
    }
}

