/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodContext;
import java.awt.peer.ComponentPeer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import sun.awt.SunToolkit;
import sun.awt.X11InputMethodDescriptor;
import sun.awt.im.InputMethodAdapter;
import sun.util.logging.PlatformLogger;

public abstract class X11InputMethod
extends InputMethodAdapter {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11InputMethod");
    private static final int XIMReverse = 1;
    private static final int XIMUnderline = 2;
    private static final int XIMHighlight = 4;
    private static final int XIMPrimary = 32;
    private static final int XIMSecondary = 64;
    private static final int XIMTertiary = 128;
    private static final int XIMVisibleToForward = 256;
    private static final int XIMVisibleToBackward = 512;
    private static final int XIMVisibleCenter = 1024;
    private static final int XIMVisibleMask = 1792;
    private Locale locale = X11InputMethodDescriptor.getSupportedLocale();
    private static boolean isXIMOpened = false;
    protected Container clientComponentWindow = null;
    private Component awtFocussedComponent = null;
    private Component lastXICFocussedComponent = null;
    private boolean isLastXICActive = false;
    private boolean isLastTemporary = false;
    private boolean isActive = false;
    private boolean isActiveClient = false;
    private static Map[] highlightStyles;
    private boolean disposed = false;
    private boolean needResetXIC = false;
    private Component needResetXICClient = null;
    private boolean compositionEnableSupported = true;
    private boolean savedCompositionState = false;
    private String committedText = null;
    private StringBuffer composedText = null;
    private IntBuffer rawFeedbacks;
    private transient long pData = 0L;
    private static final int INITIAL_SIZE = 64;

    private static native void initIDs();

    public X11InputMethod() throws AWTException {
        if (!this.initXIM()) {
            throw new AWTException("Cannot open X Input Method");
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private synchronized boolean initXIM() {
        if (!isXIMOpened) {
            isXIMOpened = this.openXIM();
        }
        return isXIMOpened;
    }

    protected abstract boolean openXIM();

    protected boolean isDisposed() {
        return this.disposed;
    }

    protected abstract void setXICFocus(ComponentPeer var1, boolean var2, boolean var3);

    @Override
    public void setInputMethodContext(InputMethodContext context) {
    }

    @Override
    public boolean setLocale(Locale lang) {
        if (lang.equals(this.locale)) {
            return true;
        }
        return this.locale.equals(Locale.JAPAN) && lang.equals(Locale.JAPANESE) || this.locale.equals(Locale.KOREA) && lang.equals(Locale.KOREAN);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setCharacterSubsets(Character.Subset[] subsets) {
    }

    @Override
    public void dispatchEvent(AWTEvent e) {
    }

    protected final void resetXICifneeded() {
        if (this.needResetXIC && this.haveActiveClient() && this.getClientComponent() != this.needResetXICClient) {
            this.resetXIC();
            this.lastXICFocussedComponent = null;
            this.isLastXICActive = false;
            this.needResetXICClient = null;
            this.needResetXIC = false;
        }
    }

    private void resetCompositionState() {
        if (this.compositionEnableSupported) {
            try {
                this.setCompositionEnabled(this.savedCompositionState);
            }
            catch (UnsupportedOperationException e) {
                this.compositionEnableSupported = false;
            }
        }
    }

    private boolean getCompositionState() {
        boolean compositionState = false;
        if (this.compositionEnableSupported) {
            try {
                compositionState = this.isCompositionEnabled();
            }
            catch (UnsupportedOperationException e) {
                this.compositionEnableSupported = false;
            }
        }
        return compositionState;
    }

    @Override
    public synchronized void activate() {
        this.clientComponentWindow = this.getClientComponentWindow();
        if (this.clientComponentWindow == null) {
            return;
        }
        if (this.lastXICFocussedComponent != null && log.isLoggable(500)) {
            log.fine("XICFocused {0}, AWTFocused {1}", this.lastXICFocussedComponent, this.awtFocussedComponent);
        }
        if (this.pData == 0L) {
            if (!this.createXIC()) {
                return;
            }
            this.disposed = false;
        }
        this.resetXICifneeded();
        ComponentPeer lastXICFocussedComponentPeer = null;
        ComponentPeer awtFocussedComponentPeer = this.getPeer(this.awtFocussedComponent);
        if (this.lastXICFocussedComponent != null) {
            lastXICFocussedComponentPeer = this.getPeer(this.lastXICFocussedComponent);
        }
        if (this.isLastTemporary || lastXICFocussedComponentPeer != awtFocussedComponentPeer || this.isLastXICActive != this.haveActiveClient()) {
            if (lastXICFocussedComponentPeer != null) {
                this.setXICFocus(lastXICFocussedComponentPeer, false, this.isLastXICActive);
            }
            if (awtFocussedComponentPeer != null) {
                this.setXICFocus(awtFocussedComponentPeer, true, this.haveActiveClient());
            }
            this.lastXICFocussedComponent = this.awtFocussedComponent;
            this.isLastXICActive = this.haveActiveClient();
        }
        this.resetCompositionState();
        this.isActive = true;
    }

    protected abstract boolean createXIC();

    @Override
    public synchronized void deactivate(boolean isTemporary) {
        boolean isAc = this.haveActiveClient();
        this.savedCompositionState = this.getCompositionState();
        if (isTemporary) {
            this.turnoffStatusWindow();
        }
        this.lastXICFocussedComponent = this.awtFocussedComponent;
        this.isLastXICActive = isAc;
        this.isLastTemporary = isTemporary;
        this.isActive = false;
    }

    @Override
    public void disableInputMethod() {
        if (this.lastXICFocussedComponent != null) {
            this.setXICFocus(this.getPeer(this.lastXICFocussedComponent), false, this.isLastXICActive);
            this.lastXICFocussedComponent = null;
            this.isLastXICActive = false;
            this.resetXIC();
            this.needResetXICClient = null;
            this.needResetXIC = false;
        }
    }

    @Override
    public void hideWindows() {
    }

    public static Map mapInputMethodHighlight(InputMethodHighlight highlight) {
        int index;
        int state = highlight.getState();
        if (state == 0) {
            index = 0;
        } else if (state == 1) {
            index = 2;
        } else {
            return null;
        }
        if (highlight.isSelected()) {
            ++index;
        }
        return highlightStyles[index];
    }

    @Override
    protected void setAWTFocussedComponent(Component component) {
        if (component == null) {
            return;
        }
        if (this.isActive) {
            boolean ac = this.haveActiveClient();
            this.setXICFocus(this.getPeer(this.awtFocussedComponent), false, ac);
            this.setXICFocus(this.getPeer(component), true, ac);
        }
        this.awtFocussedComponent = component;
    }

    @Override
    protected void stopListening() {
        this.endComposition();
        this.disableInputMethod();
        if (this.needResetXIC) {
            this.resetXIC();
            this.needResetXICClient = null;
            this.needResetXIC = false;
        }
    }

    private Window getClientComponentWindow() {
        Component client = this.getClientComponent();
        Container container = client instanceof Container ? (Container)client : this.getParent(client);
        while (container != null && !(container instanceof Window)) {
            container = this.getParent(container);
        }
        return (Window)container;
    }

    protected abstract Container getParent(Component var1);

    protected abstract ComponentPeer getPeer(Component var1);

    protected abstract void awtLock();

    protected abstract void awtUnlock();

    private void postInputMethodEvent(int id, AttributedCharacterIterator text, int committedCharacterCount, TextHitInfo caret, TextHitInfo visiblePosition, long when) {
        Component source = this.getClientComponent();
        if (source != null) {
            InputMethodEvent event = new InputMethodEvent(source, id, when, text, committedCharacterCount, caret, visiblePosition);
            SunToolkit.postEvent(SunToolkit.targetToAppContext(source), event);
        }
    }

    private void postInputMethodEvent(int id, AttributedCharacterIterator text, int committedCharacterCount, TextHitInfo caret, TextHitInfo visiblePosition) {
        this.postInputMethodEvent(id, text, committedCharacterCount, caret, visiblePosition, EventQueue.getMostRecentEventTime());
    }

    void dispatchCommittedText(String str, long when) {
        if (str == null) {
            return;
        }
        if (this.composedText == null) {
            AttributedString attrstr = new AttributedString(str);
            this.postInputMethodEvent(1100, attrstr.getIterator(), str.length(), null, null, when);
        } else {
            this.committedText = str;
        }
    }

    private void dispatchCommittedText(String str) {
        this.dispatchCommittedText(str, EventQueue.getMostRecentEventTime());
    }

    void dispatchComposedText(String chgText, int[] chgStyles, int chgOffset, int chgLength, int caretPosition, long when) {
        int currentOffset;
        int nextFeedback;
        AttributedString inputText;
        int composedOffset;
        if (this.disposed) {
            return;
        }
        if (chgText == null && chgStyles == null && chgOffset == 0 && chgLength == 0 && caretPosition == 0 && this.composedText == null && this.committedText == null) {
            return;
        }
        if (this.composedText == null) {
            this.composedText = new StringBuffer(64);
            this.rawFeedbacks = new IntBuffer(64);
        }
        if (chgLength > 0) {
            if (chgText == null && chgStyles != null) {
                this.rawFeedbacks.replace(chgOffset, chgStyles);
            } else if (chgLength == this.composedText.length()) {
                this.composedText = new StringBuffer(64);
                this.rawFeedbacks = new IntBuffer(64);
            } else if (this.composedText.length() > 0) {
                if (chgOffset + chgLength < this.composedText.length()) {
                    String text = this.composedText.toString().substring(chgOffset + chgLength, this.composedText.length());
                    this.composedText.setLength(chgOffset);
                    this.composedText.append(text);
                } else {
                    this.composedText.setLength(chgOffset);
                }
                this.rawFeedbacks.remove(chgOffset, chgLength);
            }
        }
        if (chgText != null) {
            this.composedText.insert(chgOffset, chgText);
            if (chgStyles != null) {
                this.rawFeedbacks.insert(chgOffset, chgStyles);
            }
        }
        if (this.composedText.length() == 0) {
            this.composedText = null;
            this.rawFeedbacks = null;
            if (this.committedText != null) {
                this.dispatchCommittedText(this.committedText, when);
                this.committedText = null;
                return;
            }
            this.postInputMethodEvent(1100, null, 0, null, null, when);
            return;
        }
        if (this.committedText != null) {
            composedOffset = this.committedText.length();
            inputText = new AttributedString(this.committedText + this.composedText);
            this.committedText = null;
        } else {
            composedOffset = 0;
            inputText = new AttributedString(this.composedText.toString());
        }
        int startOffset = 0;
        int visiblePosition = 0;
        TextHitInfo visiblePositionInfo = null;
        this.rawFeedbacks.rewind();
        int currentFeedback = this.rawFeedbacks.getNext();
        this.rawFeedbacks.unget();
        while ((nextFeedback = this.rawFeedbacks.getNext()) != -1) {
            if (visiblePosition == 0 && (visiblePosition = nextFeedback & 0x700) != 0) {
                int index = this.rawFeedbacks.getOffset() - 1;
                visiblePositionInfo = visiblePosition == 512 ? TextHitInfo.leading(index) : TextHitInfo.trailing(index);
            }
            if (currentFeedback == (nextFeedback &= 0xFFFFF8FF)) continue;
            this.rawFeedbacks.unget();
            currentOffset = this.rawFeedbacks.getOffset();
            inputText.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, this.convertVisualFeedbackToHighlight(currentFeedback), composedOffset + startOffset, composedOffset + currentOffset);
            startOffset = currentOffset;
            currentFeedback = nextFeedback;
        }
        currentOffset = this.rawFeedbacks.getOffset();
        if (currentOffset >= 0) {
            inputText.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, this.convertVisualFeedbackToHighlight(currentFeedback), composedOffset + startOffset, composedOffset + currentOffset);
        }
        this.postInputMethodEvent(1100, inputText.getIterator(), composedOffset, TextHitInfo.leading(caretPosition), visiblePositionInfo, when);
    }

    void flushText() {
        String flush;
        String string = flush = this.committedText != null ? this.committedText : "";
        if (this.composedText != null) {
            flush = flush + this.composedText.toString();
        }
        if (!flush.equals("")) {
            AttributedString attrstr = new AttributedString(flush);
            this.postInputMethodEvent(1100, attrstr.getIterator(), flush.length(), null, null, EventQueue.getMostRecentEventTime());
            this.composedText = null;
            this.committedText = null;
        }
    }

    protected synchronized void disposeImpl() {
        this.disposeXIC();
        this.awtLock();
        this.composedText = null;
        this.committedText = null;
        this.rawFeedbacks = null;
        this.awtUnlock();
        this.awtFocussedComponent = null;
        this.lastXICFocussedComponent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        boolean call_disposeImpl = false;
        if (!this.disposed) {
            X11InputMethod x11InputMethod = this;
            synchronized (x11InputMethod) {
                if (!this.disposed) {
                    call_disposeImpl = true;
                    this.disposed = true;
                }
            }
        }
        if (call_disposeImpl) {
            this.disposeImpl();
        }
    }

    @Override
    public Object getControlObject() {
        return null;
    }

    @Override
    public synchronized void removeNotify() {
        this.dispose();
    }

    @Override
    public void setCompositionEnabled(boolean enable) {
        if (this.setCompositionEnabledNative(enable)) {
            this.savedCompositionState = enable;
        }
    }

    @Override
    public boolean isCompositionEnabled() {
        return this.isCompositionEnabledNative();
    }

    @Override
    public void endComposition() {
        if (this.disposed) {
            return;
        }
        this.savedCompositionState = this.getCompositionState();
        boolean active = this.haveActiveClient();
        if (active && this.composedText == null && this.committedText == null) {
            this.needResetXIC = true;
            this.needResetXICClient = this.getClientComponent();
            return;
        }
        String text = this.resetXIC();
        if (active) {
            this.needResetXIC = false;
        }
        this.awtLock();
        this.composedText = null;
        this.postInputMethodEvent(1100, null, 0, null, null);
        if (text != null && text.length() > 0) {
            this.dispatchCommittedText(text);
        }
        this.awtUnlock();
        if (this.savedCompositionState) {
            this.resetCompositionState();
        }
    }

    @Override
    public String getNativeInputMethodInfo() {
        String xmodifiers = System.getenv("XMODIFIERS");
        String imInfo = null;
        if (xmodifiers != null) {
            int imIndex = xmodifiers.indexOf("@im=");
            if (imIndex != -1) {
                imInfo = xmodifiers.substring(imIndex + 4);
            }
        } else if (System.getProperty("os.name").startsWith("SunOS")) {
            File dtprofile = new File(System.getProperty("user.home") + "/.dtprofile");
            String languageEngineInfo = null;
            try {
                BufferedReader br = new BufferedReader(new FileReader(dtprofile));
                String line = null;
                block2: while (languageEngineInfo == null && (line = br.readLine()) != null) {
                    if (!line.contains("atok") && !line.contains("wnn")) continue;
                    StringTokenizer tokens = new StringTokenizer(line);
                    while (tokens.hasMoreTokens()) {
                        String token = tokens.nextToken();
                        if (!Pattern.matches("atok.*setup", token) && !Pattern.matches("wnn.*setup", token)) continue;
                        languageEngineInfo = token.substring(0, token.indexOf("setup"));
                        continue block2;
                    }
                }
                br.close();
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
            imInfo = "htt " + languageEngineInfo;
        }
        return imInfo;
    }

    private InputMethodHighlight convertVisualFeedbackToHighlight(int feedback) {
        InputMethodHighlight highlight;
        switch (feedback) {
            case 2: {
                highlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 1: {
                highlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 4: {
                highlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            case 32: {
                highlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 64: {
                highlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 128: {
                highlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            default: {
                highlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
            }
        }
        return highlight;
    }

    protected native String resetXIC();

    private native void disposeXIC();

    private native boolean setCompositionEnabledNative(boolean var1);

    private native boolean isCompositionEnabledNative();

    private native void turnoffStatusWindow();

    static {
        Map[] styles = new Map[4];
        HashMap<TextAttribute, Comparable<Float>> map = new HashMap<TextAttribute, Comparable<Float>>(1);
        map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        styles[0] = Collections.unmodifiableMap(map);
        map = new HashMap(1);
        map.put(TextAttribute.SWAP_COLORS, TextAttribute.SWAP_COLORS_ON);
        styles[1] = Collections.unmodifiableMap(map);
        map = new HashMap(1);
        map.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        styles[2] = Collections.unmodifiableMap(map);
        map = new HashMap(1);
        map.put(TextAttribute.SWAP_COLORS, TextAttribute.SWAP_COLORS_ON);
        styles[3] = Collections.unmodifiableMap(map);
        highlightStyles = styles;
        X11InputMethod.initIDs();
    }

    private final class IntBuffer {
        private int[] intArray;
        private int size;
        private int index;

        IntBuffer(int initialCapacity) {
            this.intArray = new int[initialCapacity];
            this.size = 0;
            this.index = 0;
        }

        void insert(int offset, int[] values) {
            int newSize = this.size + values.length;
            if (this.intArray.length < newSize) {
                int[] newIntArray = new int[newSize * 2];
                System.arraycopy(this.intArray, 0, newIntArray, 0, this.size);
                this.intArray = newIntArray;
            }
            System.arraycopy(this.intArray, offset, this.intArray, offset + values.length, this.size - offset);
            System.arraycopy(values, 0, this.intArray, offset, values.length);
            this.size += values.length;
            if (this.index > offset) {
                this.index = offset;
            }
        }

        void remove(int offset, int length) {
            if (offset + length != this.size) {
                System.arraycopy(this.intArray, offset + length, this.intArray, offset, this.size - offset - length);
            }
            this.size -= length;
            if (this.index > offset) {
                this.index = offset;
            }
        }

        void replace(int offset, int[] values) {
            System.arraycopy(values, 0, this.intArray, offset, values.length);
        }

        void removeAll() {
            this.size = 0;
            this.index = 0;
        }

        void rewind() {
            this.index = 0;
        }

        int getNext() {
            if (this.index == this.size) {
                return -1;
            }
            return this.intArray[this.index++];
        }

        void unget() {
            if (this.index != 0) {
                --this.index;
            }
        }

        int getOffset() {
            return this.index;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            int i = 0;
            while (i < this.size) {
                s.append(this.intArray[i++]);
                if (i >= this.size) continue;
                s.append(",");
            }
            return s.toString();
        }
    }
}

