/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.net.www.http.HttpCapture;

public class HttpCaptureInputStream
extends FilterInputStream {
    private HttpCapture capture = null;

    public HttpCaptureInputStream(InputStream in, HttpCapture cap) {
        super(in);
        this.capture = cap;
    }

    @Override
    public int read() throws IOException {
        int i = super.read();
        this.capture.received(i);
        return i;
    }

    @Override
    public void close() throws IOException {
        try {
            this.capture.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.close();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int ret = super.read(b);
        for (int i = 0; i < ret; ++i) {
            this.capture.received(b[i]);
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = super.read(b, off, len);
        for (int i = 0; i < ret; ++i) {
            this.capture.received(b[off + i]);
        }
        return ret;
    }
}

