/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.Util;

class SinkChannelImpl
extends Pipe.SinkChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    FileDescriptor fd;
    int fdVal;
    private volatile long thread = 0L;
    private final Object lock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_INUSE = 0;
    private static final int ST_KILLED = 1;
    private volatile int state = -1;

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    SinkChannelImpl(SelectorProvider sp, FileDescriptor fd) {
        super(sp);
        this.fd = fd;
        this.fdVal = IOUtil.fdVal(fd);
        this.state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            long th;
            if (this.state != 1) {
                nd.preClose(this.fd);
            }
            if ((th = this.thread) != 0L) {
                NativeThread.signal(th);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1) {
                return;
            }
            if (this.state == -1) {
                this.state = 1;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            nd.close(this.fd);
            this.state = 1;
        }
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        IOUtil.configureBlocking(this.fd, block);
    }

    public boolean translateReadyOps(int ops, int initialOps, SelectionKeyImpl sk) {
        int intOps = sk.nioInterestOps();
        int oldOps = sk.nioReadyOps();
        int newOps = initialOps;
        if ((ops & 0x20) != 0) {
            throw new Error("POLLNVAL detected");
        }
        if ((ops & 0x18) != 0) {
            newOps = intOps;
            sk.nioReadyOps(newOps);
            return (newOps & ~oldOps) != 0;
        }
        if ((ops & 4) != 0 && (intOps & 4) != 0) {
            newOps |= 4;
        }
        sk.nioReadyOps(newOps);
        return (newOps & ~oldOps) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl sk) {
        return this.translateReadyOps(ops, sk.nioReadyOps(), sk);
    }

    @Override
    public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl sk) {
        return this.translateReadyOps(ops, 0, sk);
    }

    @Override
    public void translateAndSetInterestOps(int ops, SelectionKeyImpl sk) {
        if (ops == 4) {
            ops = 4;
        }
        sk.selector.putEventOps(sk, ops);
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        this.ensureOpen();
        Object object = this.lock;
        synchronized (object) {
            int n3;
            int n;
            block9: {
                n = 0;
                this.begin();
                if (this.isOpen()) break block9;
                int n2 = 0;
                this.thread = 0L;
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                return n2;
            }
            try {
                this.thread = NativeThread.current();
                while ((n = IOUtil.write(this.fd, src, -1L, nd)) == -3 && this.isOpen()) {
                }
                n3 = IOStatus.normalize(n);
                this.thread = 0L;
                this.end(n > 0 || n == -2);
            }
            catch (Throwable throwable) {
                this.thread = 0L;
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        if (srcs == null) {
            throw new NullPointerException();
        }
        this.ensureOpen();
        Object object = this.lock;
        synchronized (object) {
            long l;
            long n;
            block10: {
                n = 0L;
                this.begin();
                if (this.isOpen()) break block10;
                long l2 = 0L;
                this.thread = 0L;
                this.end(n > 0L || n == -2L);
                assert (IOStatus.check(n));
                return l2;
            }
            try {
                this.thread = NativeThread.current();
                while ((n = IOUtil.write(this.fd, srcs, nd)) == -3L && this.isOpen()) {
                }
                l = IOStatus.normalize(n);
                this.thread = 0L;
                this.end(n > 0L || n == -2L);
            }
            catch (Throwable throwable) {
                this.thread = 0L;
                this.end(n > 0L || n == -2L);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            return l;
        }
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || offset > srcs.length - length) {
            throw new IndexOutOfBoundsException();
        }
        return this.write(Util.subsequence(srcs, offset, length));
    }

    static {
        Util.load();
        nd = new FileDispatcherImpl();
    }
}

