/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.net.SocketPermission;
import java.rmi.RemoteException;
import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.ObjID;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.misc.GC;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.server.UnicastRef;
import sun.rmi.server.Util;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.Transport;
import sun.security.action.GetLongAction;

final class DGCClient {
    private static long nextSequenceNum = Long.MIN_VALUE;
    private static VMID vmid = new VMID();
    private static final long leaseValue = AccessController.doPrivileged(new GetLongAction("java.rmi.dgc.leaseValue", 600000L));
    private static final long cleanInterval = AccessController.doPrivileged(new GetLongAction("sun.rmi.dgc.cleanInterval", 180000L));
    private static final long gcInterval = AccessController.doPrivileged(new GetLongAction("sun.rmi.dgc.client.gcInterval", 3600000L));
    private static final int dirtyFailureRetries = 5;
    private static final int cleanFailureRetries = 5;
    private static final ObjID[] emptyObjIDArray = new ObjID[0];
    private static final ObjID dgcID = new ObjID(2);
    private static final AccessControlContext SOCKET_ACC;

    private DGCClient() {
    }

    static void registerRefs(Endpoint ep, List<LiveRef> refs) {
        EndpointEntry epEntry;
        while (!(epEntry = EndpointEntry.lookup(ep)).registerRefs(refs)) {
        }
    }

    private static synchronized long getNextSequenceNum() {
        return nextSequenceNum++;
    }

    private static long computeRenewTime(long grantTime, long duration) {
        return grantTime + duration / 2L;
    }

    static {
        Permissions perms = new Permissions();
        perms.add(new SocketPermission("*", "connect,resolve"));
        ProtectionDomain[] pd = new ProtectionDomain[]{new ProtectionDomain(null, perms)};
        SOCKET_ACC = new AccessControlContext(pd);
    }

    private static class EndpointEntry {
        private Endpoint endpoint;
        private DGC dgc;
        private Map<LiveRef, RefEntry> refTable = new HashMap<LiveRef, RefEntry>(5);
        private Set<RefEntry> invalidRefs = new HashSet<RefEntry>(5);
        private boolean removed = false;
        private long renewTime = Long.MAX_VALUE;
        private long expirationTime = Long.MIN_VALUE;
        private int dirtyFailures = 0;
        private long dirtyFailureStartTime;
        private long dirtyFailureDuration;
        private Thread renewCleanThread;
        private boolean interruptible = false;
        private ReferenceQueue<LiveRef> refQueue = new ReferenceQueue();
        private Set<CleanRequest> pendingCleans = new HashSet<CleanRequest>(5);
        private static Map<Endpoint, EndpointEntry> endpointTable = new HashMap<Endpoint, EndpointEntry>(5);
        private static GC.LatencyRequest gcLatencyRequest = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static EndpointEntry lookup(Endpoint ep) {
            Map<Endpoint, EndpointEntry> map = endpointTable;
            synchronized (map) {
                EndpointEntry entry = endpointTable.get(ep);
                if (entry == null) {
                    entry = new EndpointEntry(ep);
                    endpointTable.put(ep, entry);
                    if (gcLatencyRequest == null) {
                        gcLatencyRequest = GC.requestLatency(gcInterval);
                    }
                }
                return entry;
            }
        }

        private EndpointEntry(Endpoint endpoint) {
            this.endpoint = endpoint;
            try {
                LiveRef dgcRef = new LiveRef(dgcID, endpoint, false);
                this.dgc = (DGC)Util.createProxy(DGCImpl.class, new UnicastRef(dgcRef), true);
            }
            catch (RemoteException e) {
                throw new Error("internal error creating DGC stub");
            }
            this.renewCleanThread = AccessController.doPrivileged(new NewThreadAction(new RenewCleanThread(), "RenewClean-" + endpoint, true));
            this.renewCleanThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean registerRefs(List<LiveRef> refs) {
            long sequenceNum;
            assert (!Thread.holdsLock(this));
            HashSet<RefEntry> refsToDirty = null;
            EndpointEntry endpointEntry = this;
            synchronized (endpointEntry) {
                if (this.removed) {
                    return false;
                }
                for (LiveRef ref : refs) {
                    assert (ref.getEndpoint().equals(this.endpoint));
                    RefEntry refEntry = this.refTable.get(ref);
                    if (refEntry == null) {
                        LiveRef refClone = (LiveRef)ref.clone();
                        refEntry = new RefEntry(refClone);
                        this.refTable.put(refClone, refEntry);
                        if (refsToDirty == null) {
                            refsToDirty = new HashSet<RefEntry>(5);
                        }
                        refsToDirty.add(refEntry);
                    }
                    refEntry.addInstanceToRefSet(ref);
                }
                if (refsToDirty == null) {
                    return true;
                }
                refsToDirty.addAll(this.invalidRefs);
                this.invalidRefs.clear();
                sequenceNum = DGCClient.getNextSequenceNum();
            }
            this.makeDirtyCall((Set<RefEntry>)refsToDirty, sequenceNum);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeRefEntry(RefEntry refEntry) {
            assert (Thread.holdsLock(this));
            assert (!this.removed);
            assert (this.refTable.containsKey(refEntry.getRef()));
            this.refTable.remove(refEntry.getRef());
            this.invalidRefs.remove(refEntry);
            if (this.refTable.isEmpty()) {
                Map<Endpoint, EndpointEntry> map = endpointTable;
                synchronized (map) {
                    endpointTable.remove(this.endpoint);
                    Transport transport = this.endpoint.getOutboundTransport();
                    transport.free(this.endpoint);
                    if (endpointTable.isEmpty()) {
                        assert (gcLatencyRequest != null);
                        gcLatencyRequest.cancel();
                        gcLatencyRequest = null;
                    }
                    this.removed = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void makeDirtyCall(Set<RefEntry> refEntries, long sequenceNum) {
            assert (!Thread.holdsLock(this));
            ObjID[] ids = refEntries != null ? EndpointEntry.createObjIDArray(refEntries) : emptyObjIDArray;
            long startTime = System.currentTimeMillis();
            try {
                Lease lease = this.dgc.dirty(ids, sequenceNum, new Lease(vmid, leaseValue));
                long duration = lease.getValue();
                long newRenewTime = DGCClient.computeRenewTime(startTime, duration);
                long newExpirationTime = startTime + duration;
                EndpointEntry endpointEntry = this;
                synchronized (endpointEntry) {
                    this.dirtyFailures = 0;
                    this.setRenewTime(newRenewTime);
                    this.expirationTime = newExpirationTime;
                }
            }
            catch (Exception e) {
                long endTime = System.currentTimeMillis();
                EndpointEntry endpointEntry = this;
                synchronized (endpointEntry) {
                    ++this.dirtyFailures;
                    if (this.dirtyFailures == 1) {
                        this.dirtyFailureStartTime = startTime;
                        this.dirtyFailureDuration = endTime - startTime;
                        this.setRenewTime(endTime);
                    } else {
                        long newRenewTime;
                        int n = this.dirtyFailures - 2;
                        if (n == 0) {
                            this.dirtyFailureDuration = Math.max(this.dirtyFailureDuration + (endTime - startTime) >> 1, 1000L);
                        }
                        if ((newRenewTime = endTime + (this.dirtyFailureDuration << n)) < this.expirationTime || this.dirtyFailures < 5 || newRenewTime < this.dirtyFailureStartTime + leaseValue) {
                            this.setRenewTime(newRenewTime);
                        } else {
                            this.setRenewTime(Long.MAX_VALUE);
                        }
                    }
                    if (refEntries != null) {
                        this.invalidRefs.addAll(refEntries);
                        for (RefEntry refEntry : refEntries) {
                            refEntry.markDirtyFailed();
                        }
                    }
                    if (this.renewTime >= this.expirationTime) {
                        this.invalidRefs.addAll(this.refTable.values());
                    }
                }
            }
        }

        private void setRenewTime(long newRenewTime) {
            assert (Thread.holdsLock(this));
            if (newRenewTime < this.renewTime) {
                this.renewTime = newRenewTime;
                if (this.interruptible) {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            EndpointEntry.this.renewCleanThread.interrupt();
                            return null;
                        }
                    });
                }
            } else {
                this.renewTime = newRenewTime;
            }
        }

        private void processPhantomRefs(RefEntry.PhantomLiveRef phantom) {
            assert (Thread.holdsLock(this));
            HashSet<RefEntry> strongCleans = null;
            HashSet<RefEntry> normalCleans = null;
            do {
                RefEntry refEntry = phantom.getRefEntry();
                refEntry.removeInstanceFromRefSet(phantom);
                if (!refEntry.isRefSetEmpty()) continue;
                if (refEntry.hasDirtyFailed()) {
                    if (strongCleans == null) {
                        strongCleans = new HashSet<RefEntry>(5);
                    }
                    strongCleans.add(refEntry);
                } else {
                    if (normalCleans == null) {
                        normalCleans = new HashSet<RefEntry>(5);
                    }
                    normalCleans.add(refEntry);
                }
                this.removeRefEntry(refEntry);
            } while ((phantom = (RefEntry.PhantomLiveRef)this.refQueue.poll()) != null);
            if (strongCleans != null) {
                this.pendingCleans.add(new CleanRequest(EndpointEntry.createObjIDArray(strongCleans), DGCClient.getNextSequenceNum(), true));
            }
            if (normalCleans != null) {
                this.pendingCleans.add(new CleanRequest(EndpointEntry.createObjIDArray(normalCleans), DGCClient.getNextSequenceNum(), false));
            }
        }

        private void makeCleanCalls() {
            assert (!Thread.holdsLock(this));
            Iterator<CleanRequest> iter = this.pendingCleans.iterator();
            while (iter.hasNext()) {
                CleanRequest request = iter.next();
                try {
                    this.dgc.clean(request.objIDs, request.sequenceNum, vmid, request.strong);
                    iter.remove();
                }
                catch (Exception e) {
                    if (++request.failures < 5) continue;
                    iter.remove();
                }
            }
        }

        private static ObjID[] createObjIDArray(Set<RefEntry> refEntries) {
            ObjID[] ids = new ObjID[refEntries.size()];
            Iterator<RefEntry> iter = refEntries.iterator();
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = iter.next().getRef().getObjID();
            }
            return ids;
        }

        private class RefEntry {
            private LiveRef ref;
            private Set<PhantomLiveRef> refSet = new HashSet<PhantomLiveRef>(5);
            private boolean dirtyFailed = false;

            public RefEntry(LiveRef ref) {
                this.ref = ref;
            }

            public LiveRef getRef() {
                return this.ref;
            }

            public void addInstanceToRefSet(LiveRef ref) {
                assert (Thread.holdsLock(EndpointEntry.this));
                assert (ref.equals(this.ref));
                this.refSet.add(new PhantomLiveRef(ref));
            }

            public void removeInstanceFromRefSet(PhantomLiveRef phantom) {
                assert (Thread.holdsLock(EndpointEntry.this));
                assert (this.refSet.contains(phantom));
                this.refSet.remove(phantom);
            }

            public boolean isRefSetEmpty() {
                assert (Thread.holdsLock(EndpointEntry.this));
                return this.refSet.size() == 0;
            }

            public void markDirtyFailed() {
                assert (Thread.holdsLock(EndpointEntry.this));
                this.dirtyFailed = true;
            }

            public boolean hasDirtyFailed() {
                assert (Thread.holdsLock(EndpointEntry.this));
                return this.dirtyFailed;
            }

            private class PhantomLiveRef
            extends PhantomReference<LiveRef> {
                public PhantomLiveRef(LiveRef ref) {
                    super(ref, EndpointEntry.this.refQueue);
                }

                public RefEntry getRefEntry() {
                    return RefEntry.this;
                }
            }
        }

        private static class CleanRequest {
            final ObjID[] objIDs;
            final long sequenceNum;
            final boolean strong;
            int failures = 0;

            CleanRequest(ObjID[] objIDs, long sequenceNum, boolean strong) {
                this.objIDs = objIDs;
                this.sequenceNum = sequenceNum;
                this.strong = strong;
            }
        }

        private class RenewCleanThread
        implements Runnable {
            private RenewCleanThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                do {
                    long timeToWait;
                    RefEntry.PhantomLiveRef phantom = null;
                    boolean needRenewal = false;
                    Set refsToDirty = null;
                    long sequenceNum = Long.MIN_VALUE;
                    EndpointEntry endpointEntry = EndpointEntry.this;
                    synchronized (endpointEntry) {
                        long timeUntilRenew = EndpointEntry.this.renewTime - System.currentTimeMillis();
                        timeToWait = Math.max(timeUntilRenew, 1L);
                        if (!EndpointEntry.this.pendingCleans.isEmpty()) {
                            timeToWait = Math.min(timeToWait, cleanInterval);
                        }
                        EndpointEntry.this.interruptible = true;
                    }
                    try {
                        phantom = (RefEntry.PhantomLiveRef)EndpointEntry.this.refQueue.remove(timeToWait);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    endpointEntry = EndpointEntry.this;
                    synchronized (endpointEntry) {
                        long currentTime;
                        EndpointEntry.this.interruptible = false;
                        Thread.interrupted();
                        if (phantom != null) {
                            EndpointEntry.this.processPhantomRefs(phantom);
                        }
                        if ((currentTime = System.currentTimeMillis()) > EndpointEntry.this.renewTime) {
                            needRenewal = true;
                            if (!EndpointEntry.this.invalidRefs.isEmpty()) {
                                refsToDirty = EndpointEntry.this.invalidRefs;
                                EndpointEntry.this.invalidRefs = new HashSet(5);
                            }
                            sequenceNum = DGCClient.getNextSequenceNum();
                        }
                    }
                    final boolean needRenewal_ = needRenewal;
                    final Set refsToDirty_ = refsToDirty;
                    final long sequenceNum_ = sequenceNum;
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            if (needRenewal_) {
                                EndpointEntry.this.makeDirtyCall(refsToDirty_, sequenceNum_);
                            }
                            if (!EndpointEntry.this.pendingCleans.isEmpty()) {
                                EndpointEntry.this.makeCleanCalls();
                            }
                            return null;
                        }
                    }, SOCKET_ACC);
                } while (!EndpointEntry.this.removed || !EndpointEntry.this.pendingCleans.isEmpty());
            }
        }
    }
}

