/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs12;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.security.auth.x500.X500Principal;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.EncryptedPrivateKeyInfo;
import sun.security.pkcs12.MacData;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public final class PKCS12KeyStore
extends KeyStoreSpi {
    public static final int VERSION_3 = 3;
    private static final Debug debug = Debug.getInstance("pkcs12");
    private static final int[] keyBag = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 2};
    private static final int[] certBag = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 3};
    private static final int[] pkcs9Name = new int[]{1, 2, 840, 113549, 1, 9, 20};
    private static final int[] pkcs9KeyId = new int[]{1, 2, 840, 113549, 1, 9, 21};
    private static final int[] pkcs9certType = new int[]{1, 2, 840, 113549, 1, 9, 22, 1};
    private static final int[] pbeWithSHAAnd40BitRC2CBC = new int[]{1, 2, 840, 113549, 1, 12, 1, 6};
    private static final int[] pbeWithSHAAnd3KeyTripleDESCBC = new int[]{1, 2, 840, 113549, 1, 12, 1, 3};
    private static ObjectIdentifier PKCS8ShroudedKeyBag_OID;
    private static ObjectIdentifier CertBag_OID;
    private static ObjectIdentifier PKCS9FriendlyName_OID;
    private static ObjectIdentifier PKCS9LocalKeyId_OID;
    private static ObjectIdentifier PKCS9CertType_OID;
    private static ObjectIdentifier pbeWithSHAAnd40BitRC2CBC_OID;
    private static ObjectIdentifier pbeWithSHAAnd3KeyTripleDESCBC_OID;
    private int counter = 0;
    private static final int iterationCount = 1024;
    private static final int SALT_LEN = 20;
    private int privateKeyCount = 0;
    private SecureRandom random;
    private Hashtable<String, KeyEntry> entries = new Hashtable();
    private ArrayList<KeyEntry> keyList = new ArrayList();
    private LinkedHashMap<X500Principal, X509Certificate> certsMap = new LinkedHashMap();
    private ArrayList<CertEntry> certEntries = new ArrayList();

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        AlgorithmParameters algParams;
        ObjectIdentifier algOid;
        byte[] encryptedKey;
        KeyEntry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        PrivateKey key = null;
        if (entry == null) {
            return null;
        }
        byte[] encrBytes = entry.protectedPrivKey;
        try {
            EncryptedPrivateKeyInfo encrInfo = new EncryptedPrivateKeyInfo(encrBytes);
            encryptedKey = encrInfo.getEncryptedData();
            DerValue val = new DerValue(encrInfo.getAlgorithm().encode());
            DerInputStream in = val.toDerInputStream();
            algOid = in.getOID();
            algParams = this.parseAlgParameters(in);
        }
        catch (IOException ioe) {
            UnrecoverableKeyException uke = new UnrecoverableKeyException("Private key not stored as PKCS#8 EncryptedPrivateKeyInfo: " + ioe);
            uke.initCause(ioe);
            throw uke;
        }
        try {
            byte[] privateKeyInfo;
            while (true) {
                try {
                    SecretKey skey = this.getPBEKey(password);
                    Cipher cipher = Cipher.getInstance(algOid.toString());
                    cipher.init(2, (Key)skey, algParams);
                    privateKeyInfo = cipher.doFinal(encryptedKey);
                }
                catch (Exception e) {
                    if (password.length == 0) {
                        password = new char[1];
                        continue;
                    }
                    throw e;
                }
                break;
            }
            PKCS8EncodedKeySpec kspec = new PKCS8EncodedKeySpec(privateKeyInfo);
            DerValue val = new DerValue(privateKeyInfo);
            DerInputStream in = val.toDerInputStream();
            int i = in.getInteger();
            DerValue[] value = in.getSequence(2);
            AlgorithmId algId = new AlgorithmId(value[0].getOID());
            String algName = algId.getName();
            KeyFactory kfac = KeyFactory.getInstance(algName);
            key = kfac.generatePrivate(kspec);
        }
        catch (Exception e) {
            UnrecoverableKeyException uke = new UnrecoverableKeyException("Get Key failed: " + e.getMessage());
            uke.initCause(e);
            throw uke;
        }
        return key;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        KeyEntry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (entry != null) {
            if (entry.chain == null) {
                return null;
            }
            return (Certificate[])entry.chain.clone();
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        KeyEntry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (entry != null) {
            if (entry.chain == null) {
                return null;
            }
            return entry.chain[0];
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        KeyEntry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (entry != null) {
            return new Date(entry.date.getTime());
        }
        return null;
    }

    @Override
    public synchronized void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        try {
            KeyEntry entry = new KeyEntry();
            entry.date = new Date();
            if (key instanceof PrivateKey) {
                if (!key.getFormat().equals("PKCS#8") && !key.getFormat().equals("PKCS8")) {
                    throw new KeyStoreException("Private key is not encodedas PKCS#8");
                }
            } else {
                throw new KeyStoreException("Key is not a PrivateKey");
            }
            entry.protectedPrivKey = this.encryptPrivateKey(key.getEncoded(), password);
            if (chain != null) {
                if (chain.length > 1 && !this.validateChain(chain)) {
                    throw new KeyStoreException("Certificate chain is not validate");
                }
                entry.chain = (Certificate[])chain.clone();
            }
            entry.keyId = ("Time " + entry.date.getTime()).getBytes("UTF8");
            entry.alias = alias.toLowerCase(Locale.ENGLISH);
            this.entries.put(alias.toLowerCase(Locale.ENGLISH), entry);
        }
        catch (Exception nsae) {
            KeyStoreException ke = new KeyStoreException("Key protection  algorithm not found: " + nsae);
            ke.initCause(nsae);
            throw ke;
        }
    }

    @Override
    public synchronized void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        try {
            new EncryptedPrivateKeyInfo(key);
        }
        catch (IOException ioe) {
            KeyStoreException ke = new KeyStoreException("Private key is not stored as PKCS#8 EncryptedPrivateKeyInfo: " + ioe);
            ke.initCause(ioe);
            throw ke;
        }
        KeyEntry entry = new KeyEntry();
        entry.date = new Date();
        try {
            entry.keyId = ("Time " + entry.date.getTime()).getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        entry.alias = alias.toLowerCase(Locale.ENGLISH);
        entry.protectedPrivKey = (byte[])key.clone();
        if (chain != null) {
            if (chain.length > 1 && !this.validateChain(chain)) {
                throw new KeyStoreException("Certificate chain is not valid");
            }
            entry.chain = (Certificate[])chain.clone();
        }
        this.entries.put(alias.toLowerCase(Locale.ENGLISH), entry);
    }

    private byte[] getSalt() {
        byte[] salt = new byte[20];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(salt);
        return salt;
    }

    private AlgorithmParameters getAlgorithmParameters(String algorithm) throws IOException {
        AlgorithmParameters algParams = null;
        PBEParameterSpec paramSpec = new PBEParameterSpec(this.getSalt(), 1024);
        try {
            algParams = AlgorithmParameters.getInstance(algorithm);
            algParams.init(paramSpec);
        }
        catch (Exception e) {
            IOException ioe = new IOException("getAlgorithmParameters failed: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        return algParams;
    }

    private AlgorithmParameters parseAlgParameters(DerInputStream in) throws IOException {
        AlgorithmParameters algParams = null;
        try {
            DerValue params;
            if (in.available() == 0) {
                params = null;
            } else {
                params = in.getDerValue();
                if (params.tag == 5) {
                    params = null;
                }
            }
            if (params != null) {
                algParams = AlgorithmParameters.getInstance("PBE");
                algParams.init(params.toByteArray());
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException("parseAlgParameters failed: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        return algParams;
    }

    private SecretKey getPBEKey(char[] password) throws IOException {
        SecretKey skey = null;
        try {
            PBEKeySpec keySpec = new PBEKeySpec(password);
            SecretKeyFactory skFac = SecretKeyFactory.getInstance("PBE");
            skey = skFac.generateSecret(keySpec);
        }
        catch (Exception e) {
            IOException ioe = new IOException("getSecretKey failed: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        return skey;
    }

    private byte[] encryptPrivateKey(byte[] data, char[] password) throws IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        byte[] key = null;
        try {
            AlgorithmParameters algParams = this.getAlgorithmParameters("PBEWithSHA1AndDESede");
            SecretKey skey = this.getPBEKey(password);
            Cipher cipher = Cipher.getInstance("PBEWithSHA1AndDESede");
            cipher.init(1, (Key)skey, algParams);
            byte[] encryptedKey = cipher.doFinal(data);
            AlgorithmId algid = new AlgorithmId(pbeWithSHAAnd3KeyTripleDESCBC_OID, algParams);
            EncryptedPrivateKeyInfo encrInfo = new EncryptedPrivateKeyInfo(algid, encryptedKey);
            key = encrInfo.getEncoded();
        }
        catch (Exception e) {
            UnrecoverableKeyException uke = new UnrecoverableKeyException("Encrypt Private Key failed: " + e.getMessage());
            uke.initCause(e);
            throw uke;
        }
        return key;
    }

    @Override
    public synchronized void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        KeyEntry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (entry != null) {
            throw new KeyStoreException("Cannot overwrite own certificate");
        }
        throw new KeyStoreException("TrustedCertEntry not supported");
    }

    @Override
    public synchronized void engineDeleteEntry(String alias) throws KeyStoreException {
        this.entries.remove(alias.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public Enumeration<String> engineAliases() {
        return this.entries.keys();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.entries.containsKey(alias.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        KeyEntry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        return entry != null;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        Certificate certElem = null;
        Enumeration<String> e = this.entries.keys();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            KeyEntry entry = this.entries.get(alias);
            if (entry.chain != null) {
                certElem = entry.chain[0];
            }
            if (!certElem.equals(cert)) continue;
            return alias;
        }
        return null;
    }

    @Override
    public synchronized void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (password == null) {
            throw new IllegalArgumentException("password can't be null");
        }
        DerOutputStream pfx = new DerOutputStream();
        DerOutputStream version = new DerOutputStream();
        version.putInteger(3);
        byte[] pfxVersion = version.toByteArray();
        pfx.write(pfxVersion);
        DerOutputStream authSafe = new DerOutputStream();
        DerOutputStream authSafeContentInfo = new DerOutputStream();
        byte[] safeContentData = this.createSafeContent();
        ContentInfo dataContentInfo = new ContentInfo(safeContentData);
        dataContentInfo.encode(authSafeContentInfo);
        byte[] encrData = this.createEncryptedData(password);
        ContentInfo encrContentInfo = new ContentInfo(ContentInfo.ENCRYPTED_DATA_OID, new DerValue(encrData));
        encrContentInfo.encode(authSafeContentInfo);
        DerOutputStream cInfo = new DerOutputStream();
        cInfo.write((byte)48, authSafeContentInfo);
        byte[] authenticatedSafe = cInfo.toByteArray();
        ContentInfo contentInfo = new ContentInfo(authenticatedSafe);
        contentInfo.encode(authSafe);
        byte[] authSafeData = authSafe.toByteArray();
        pfx.write(authSafeData);
        byte[] macData = this.calculateMac(password, authenticatedSafe);
        pfx.write(macData);
        DerOutputStream pfxout = new DerOutputStream();
        pfxout.write((byte)48, pfx);
        byte[] pfxData = pfxout.toByteArray();
        stream.write(pfxData);
        stream.flush();
    }

    private byte[] generateHash(byte[] data) throws IOException {
        byte[] digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(data);
            digest = md.digest();
        }
        catch (Exception e) {
            IOException ioe = new IOException("generateHash failed: " + e);
            ioe.initCause(e);
            throw ioe;
        }
        return digest;
    }

    private byte[] calculateMac(char[] passwd, byte[] data) throws IOException {
        byte[] mData = null;
        String algName = "SHA1";
        try {
            byte[] salt = this.getSalt();
            Mac m = Mac.getInstance("HmacPBESHA1");
            PBEParameterSpec params = new PBEParameterSpec(salt, 1024);
            SecretKey key = this.getPBEKey(passwd);
            m.init(key, params);
            m.update(data);
            byte[] macResult = m.doFinal();
            MacData macData = new MacData(algName, macResult, salt, 1024);
            DerOutputStream bytes = new DerOutputStream();
            bytes.write(macData.getEncoded());
            mData = bytes.toByteArray();
        }
        catch (Exception e) {
            IOException ioe = new IOException("calculateMac failed: " + e);
            ioe.initCause(e);
            throw ioe;
        }
        return mData;
    }

    private boolean validateChain(Certificate[] certChain) {
        for (int i = 0; i < certChain.length - 1; ++i) {
            X500Principal subjectDN;
            X500Principal issuerDN = ((X509Certificate)certChain[i]).getIssuerX500Principal();
            if (issuerDN.equals(subjectDN = ((X509Certificate)certChain[i + 1]).getSubjectX500Principal())) continue;
            return false;
        }
        HashSet<Certificate> set = new HashSet<Certificate>(Arrays.asList(certChain));
        return set.size() == certChain.length;
    }

    private byte[] getBagAttributes(String alias, byte[] keyId) throws IOException {
        byte[] localKeyID = null;
        byte[] friendlyName = null;
        if (alias == null && keyId == null) {
            return null;
        }
        DerOutputStream bagAttrs = new DerOutputStream();
        if (alias != null) {
            DerOutputStream bagAttr1 = new DerOutputStream();
            bagAttr1.putOID(PKCS9FriendlyName_OID);
            DerOutputStream bagAttrContent1 = new DerOutputStream();
            DerOutputStream bagAttrValue1 = new DerOutputStream();
            bagAttrContent1.putBMPString(alias);
            bagAttr1.write((byte)49, bagAttrContent1);
            bagAttrValue1.write((byte)48, bagAttr1);
            friendlyName = bagAttrValue1.toByteArray();
        }
        if (keyId != null) {
            DerOutputStream bagAttr2 = new DerOutputStream();
            bagAttr2.putOID(PKCS9LocalKeyId_OID);
            DerOutputStream bagAttrContent2 = new DerOutputStream();
            DerOutputStream bagAttrValue2 = new DerOutputStream();
            bagAttrContent2.putOctetString(keyId);
            bagAttr2.write((byte)49, bagAttrContent2);
            bagAttrValue2.write((byte)48, bagAttr2);
            localKeyID = bagAttrValue2.toByteArray();
        }
        DerOutputStream attrs = new DerOutputStream();
        if (friendlyName != null) {
            attrs.write(friendlyName);
        }
        if (localKeyID != null) {
            attrs.write(localKeyID);
        }
        bagAttrs.write((byte)49, attrs);
        return bagAttrs.toByteArray();
    }

    private byte[] createEncryptedData(char[] password) throws CertificateException, IOException {
        DerOutputStream out = new DerOutputStream();
        Enumeration<String> e = this.entries.keys();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            KeyEntry entry = this.entries.get(alias);
            int chainLen = entry.chain == null ? 0 : entry.chain.length;
            for (int i = 0; i < chainLen; ++i) {
                DerOutputStream safeBag = new DerOutputStream();
                safeBag.putOID(CertBag_OID);
                DerOutputStream certBag = new DerOutputStream();
                certBag.putOID(PKCS9CertType_OID);
                DerOutputStream certValue = new DerOutputStream();
                X509Certificate cert = (X509Certificate)entry.chain[i];
                certValue.putOctetString(cert.getEncoded());
                certBag.write(DerValue.createTag((byte)-128, true, (byte)0), certValue);
                DerOutputStream certout = new DerOutputStream();
                certout.write((byte)48, certBag);
                byte[] certBagValue = certout.toByteArray();
                DerOutputStream bagValue = new DerOutputStream();
                bagValue.write(certBagValue);
                safeBag.write(DerValue.createTag((byte)-128, true, (byte)0), bagValue);
                byte[] bagAttrs = null;
                bagAttrs = i == 0 ? this.getBagAttributes(entry.alias, entry.keyId) : this.getBagAttributes(cert.getSubjectX500Principal().getName(), null);
                if (bagAttrs != null) {
                    safeBag.write(bagAttrs);
                }
                out.write((byte)48, safeBag);
            }
        }
        DerOutputStream safeBagValue = new DerOutputStream();
        safeBagValue.write((byte)48, out);
        byte[] safeBagData = safeBagValue.toByteArray();
        byte[] encrContentInfo = this.encryptContent(safeBagData, password);
        DerOutputStream encrData = new DerOutputStream();
        DerOutputStream encrDataContent = new DerOutputStream();
        encrData.putInteger(0);
        encrData.write(encrContentInfo);
        encrDataContent.write((byte)48, encrData);
        return encrDataContent.toByteArray();
    }

    private byte[] createSafeContent() throws CertificateException, IOException {
        DerOutputStream out = new DerOutputStream();
        Enumeration<String> e = this.entries.keys();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            KeyEntry entry = this.entries.get(alias);
            DerOutputStream safeBag = new DerOutputStream();
            safeBag.putOID(PKCS8ShroudedKeyBag_OID);
            byte[] encrBytes = entry.protectedPrivKey;
            EncryptedPrivateKeyInfo encrInfo = null;
            try {
                encrInfo = new EncryptedPrivateKeyInfo(encrBytes);
            }
            catch (IOException ioe) {
                throw new IOException("Private key not stored as PKCS#8 EncryptedPrivateKeyInfo" + ioe.getMessage());
            }
            DerOutputStream bagValue = new DerOutputStream();
            bagValue.write(encrInfo.getEncoded());
            safeBag.write(DerValue.createTag((byte)-128, true, (byte)0), bagValue);
            byte[] bagAttrs = this.getBagAttributes(alias, entry.keyId);
            safeBag.write(bagAttrs);
            out.write((byte)48, safeBag);
        }
        DerOutputStream safeBagValue = new DerOutputStream();
        safeBagValue.write((byte)48, out);
        return safeBagValue.toByteArray();
    }

    private byte[] encryptContent(byte[] data, char[] password) throws IOException {
        byte[] encryptedData = null;
        AlgorithmParameters algParams = this.getAlgorithmParameters("PBEWithSHA1AndRC2_40");
        DerOutputStream bytes = new DerOutputStream();
        AlgorithmId algId = new AlgorithmId(pbeWithSHAAnd40BitRC2CBC_OID, algParams);
        algId.encode(bytes);
        byte[] encodedAlgId = bytes.toByteArray();
        try {
            SecretKey skey = this.getPBEKey(password);
            Cipher cipher = Cipher.getInstance("PBEWithSHA1AndRC2_40");
            cipher.init(1, (Key)skey, algParams);
            encryptedData = cipher.doFinal(data);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Failed to encrypt safe contents entry: " + e);
            ioe.initCause(e);
            throw ioe;
        }
        DerOutputStream bytes2 = new DerOutputStream();
        bytes2.putOID(ContentInfo.DATA_OID);
        bytes2.write(encodedAlgId);
        DerOutputStream tmpout2 = new DerOutputStream();
        tmpout2.putOctetString(encryptedData);
        bytes2.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), tmpout2);
        DerOutputStream out = new DerOutputStream();
        out.write((byte)48, bytes2);
        return out.toByteArray();
    }

    @Override
    public synchronized void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        Object cf = null;
        Object bais = null;
        Object encoded = null;
        if (stream == null) {
            return;
        }
        this.counter = 0;
        DerValue val = new DerValue(stream);
        DerInputStream s = val.toDerInputStream();
        int version = s.getInteger();
        if (version != 3) {
            throw new IOException("PKCS12 keystore not in version 3 format");
        }
        this.entries.clear();
        ContentInfo authSafe = new ContentInfo(s);
        ObjectIdentifier contentType = authSafe.getContentType();
        if (!contentType.equals(ContentInfo.DATA_OID)) {
            throw new IOException("public key protected PKCS12 not supported");
        }
        byte[] authSafeData = authSafe.getData();
        DerInputStream as = new DerInputStream(authSafeData);
        DerValue[] safeContentsArray = as.getSequence(2);
        int count = safeContentsArray.length;
        this.privateKeyCount = 0;
        for (int i = 0; i < count; ++i) {
            byte[] safeContentsData;
            block22: {
                byte[] eAlgId = null;
                DerInputStream sci = new DerInputStream(safeContentsArray[i].toByteArray());
                ContentInfo safeContents = new ContentInfo(sci);
                contentType = safeContents.getContentType();
                safeContentsData = null;
                if (contentType.equals(ContentInfo.DATA_OID)) {
                    safeContentsData = safeContents.getData();
                } else {
                    if (contentType.equals(ContentInfo.ENCRYPTED_DATA_OID)) {
                        if (password == null) continue;
                        DerInputStream edi = safeContents.getContent().toDerInputStream();
                        int edVersion = edi.getInteger();
                        DerValue[] seq = edi.getSequence(2);
                        ObjectIdentifier edContentType = seq[0].getOID();
                        eAlgId = seq[1].toByteArray();
                        if (!seq[2].isContextSpecific((byte)0)) {
                            throw new IOException("encrypted content not present!");
                        }
                        byte newTag = 4;
                        if (seq[2].isConstructed()) {
                            newTag = (byte)(newTag | 0x20);
                        }
                        seq[2].resetTag(newTag);
                        safeContentsData = seq[2].getOctetString();
                        DerInputStream in = seq[1].toDerInputStream();
                        ObjectIdentifier algOid = in.getOID();
                        AlgorithmParameters algParams = this.parseAlgParameters(in);
                        while (true) {
                            try {
                                SecretKey skey = this.getPBEKey(password);
                                Cipher cipher = Cipher.getInstance(algOid.toString());
                                cipher.init(2, (Key)skey, algParams);
                                safeContentsData = cipher.doFinal(safeContentsData);
                                break block22;
                            }
                            catch (Exception e) {
                                if (password.length == 0) {
                                    password = new char[1];
                                    continue;
                                }
                                throw new IOException("failed to decrypt safe contents entry: " + e, e);
                            }
                            break;
                        }
                    }
                    throw new IOException("public key protected PKCS12 not supported");
                }
            }
            DerInputStream sc = new DerInputStream(safeContentsData);
            this.loadSafeContents(sc, password);
        }
        if (password != null && s.available() > 0) {
            MacData macData = new MacData(s);
            try {
                String algName = macData.getDigestAlgName().toUpperCase(Locale.ENGLISH);
                if (algName.equals("SHA") || algName.equals("SHA1") || algName.equals("SHA-1")) {
                    algName = "SHA1";
                }
                Mac m = Mac.getInstance("HmacPBE" + algName);
                PBEParameterSpec params = new PBEParameterSpec(macData.getSalt(), macData.getIterations());
                SecretKey key = this.getPBEKey(password);
                m.init(key, params);
                m.update(authSafeData);
                byte[] macResult = m.doFinal();
                if (!MessageDigest.isEqual(macData.getDigest(), macResult)) {
                    throw new SecurityException("Failed PKCS12 integrity checking");
                }
            }
            catch (Exception e) {
                IOException ioe = new IOException("Integrity check failed: " + e);
                ioe.initCause(e);
                throw ioe;
            }
        }
        KeyEntry[] list = this.keyList.toArray(new KeyEntry[this.keyList.size()]);
        for (int m = 0; m < list.length; ++m) {
            KeyEntry entry = list[m];
            if (entry.keyId == null) continue;
            ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
            X509Certificate cert = this.findMatchedCertificate(entry);
            block7: while (cert != null) {
                if (!chain.isEmpty()) {
                    for (X509Certificate chainCert : chain) {
                        if (!cert.equals(chainCert)) continue;
                        if (debug == null) break block7;
                        debug.println("Loop detected in certificate chain. Skip adding repeated cert to chain. Subject: " + cert.getSubjectX500Principal().toString());
                        break block7;
                    }
                }
                chain.add(cert);
                X500Principal issuerDN = cert.getIssuerX500Principal();
                if (issuerDN.equals(cert.getSubjectX500Principal())) break;
                cert = this.certsMap.get(issuerDN);
            }
            if (chain.size() <= 0) continue;
            entry.chain = chain.toArray(new Certificate[chain.size()]);
        }
        this.certEntries.clear();
        this.certsMap.clear();
        this.keyList.clear();
    }

    private X509Certificate findMatchedCertificate(KeyEntry entry) {
        CertEntry keyIdMatch = null;
        CertEntry aliasMatch = null;
        for (CertEntry ce : this.certEntries) {
            if (Arrays.equals(entry.keyId, ce.keyId)) {
                keyIdMatch = ce;
                if (!entry.alias.equalsIgnoreCase(ce.alias)) continue;
                return ce.cert;
            }
            if (!entry.alias.equalsIgnoreCase(ce.alias)) continue;
            aliasMatch = ce;
        }
        if (keyIdMatch != null) {
            return keyIdMatch.cert;
        }
        if (aliasMatch != null) {
            return aliasMatch.cert;
        }
        return null;
    }

    private void loadSafeContents(DerInputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        DerValue[] safeBags = stream.getSequence(2);
        int count = safeBags.length;
        for (int i = 0; i < count; ++i) {
            DerValue[] attrSet;
            Object bagItem = null;
            DerInputStream sbi = safeBags[i].toDerInputStream();
            ObjectIdentifier bagId = sbi.getOID();
            DerValue bagValue = sbi.getDerValue();
            if (!bagValue.isContextSpecific((byte)0)) {
                throw new IOException("unsupported PKCS12 bag value type " + bagValue.tag);
            }
            bagValue = bagValue.data.getDerValue();
            if (bagId.equals(PKCS8ShroudedKeyBag_OID)) {
                KeyEntry kEntry = new KeyEntry();
                kEntry.protectedPrivKey = bagValue.toByteArray();
                bagItem = kEntry;
                ++this.privateKeyCount;
            } else if (bagId.equals(CertBag_OID)) {
                DerInputStream cs = new DerInputStream(bagValue.toByteArray());
                DerValue[] certValues = cs.getSequence(2);
                ObjectIdentifier certId = certValues[0].getOID();
                if (!certValues[1].isContextSpecific((byte)0)) {
                    throw new IOException("unsupported PKCS12 cert value type " + certValues[1].tag);
                }
                DerValue certValue = certValues[1].data.getDerValue();
                CertificateFactory cf = CertificateFactory.getInstance("X509");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certValue.getOctetString()));
                bagItem = cert;
            }
            try {
                attrSet = sbi.getSet(2);
            }
            catch (IOException e) {
                attrSet = null;
            }
            String alias = null;
            byte[] keyId = null;
            if (attrSet != null) {
                for (int j = 0; j < attrSet.length; ++j) {
                    DerValue[] valSet;
                    DerInputStream as = new DerInputStream(attrSet[j].toByteArray());
                    DerValue[] attrSeq = as.getSequence(2);
                    ObjectIdentifier attrId = attrSeq[0].getOID();
                    DerInputStream vs = new DerInputStream(attrSeq[1].toByteArray());
                    try {
                        valSet = vs.getSet(1);
                    }
                    catch (IOException e) {
                        throw new IOException("Attribute " + attrId + " should have a value " + e.getMessage());
                    }
                    if (attrId.equals(PKCS9FriendlyName_OID)) {
                        alias = valSet[0].getBMPString();
                        continue;
                    }
                    if (!attrId.equals(PKCS9LocalKeyId_OID)) continue;
                    keyId = valSet[0].getOctetString();
                }
            }
            if (bagItem instanceof KeyEntry) {
                KeyEntry entry = bagItem;
                if (keyId == null) {
                    if (this.privateKeyCount != 1) continue;
                    keyId = "01".getBytes("UTF8");
                }
                entry.keyId = keyId;
                String keyIdStr = new String(keyId, "UTF8");
                Date date = null;
                if (keyIdStr.startsWith("Time ")) {
                    try {
                        date = new Date(Long.parseLong(keyIdStr.substring(5)));
                    }
                    catch (Exception e) {
                        date = null;
                    }
                }
                if (date == null) {
                    date = new Date();
                }
                entry.date = date;
                this.keyList.add(entry);
                if (alias == null) {
                    alias = this.getUnfriendlyName();
                }
                entry.alias = alias;
                this.entries.put(alias.toLowerCase(Locale.ENGLISH), entry);
                continue;
            }
            if (!(bagItem instanceof X509Certificate)) continue;
            X509Certificate cert = (X509Certificate)bagItem;
            if (keyId == null && this.privateKeyCount == 1 && i == 0) {
                keyId = "01".getBytes("UTF8");
            }
            this.certEntries.add(new CertEntry(cert, keyId, alias));
            X500Principal subjectDN = cert.getSubjectX500Principal();
            if (subjectDN == null || this.certsMap.containsKey(subjectDN)) continue;
            this.certsMap.put(subjectDN, cert);
        }
    }

    private String getUnfriendlyName() {
        ++this.counter;
        return String.valueOf(this.counter);
    }

    static {
        try {
            PKCS8ShroudedKeyBag_OID = new ObjectIdentifier(keyBag);
            CertBag_OID = new ObjectIdentifier(certBag);
            PKCS9FriendlyName_OID = new ObjectIdentifier(pkcs9Name);
            PKCS9LocalKeyId_OID = new ObjectIdentifier(pkcs9KeyId);
            PKCS9CertType_OID = new ObjectIdentifier(pkcs9certType);
            pbeWithSHAAnd40BitRC2CBC_OID = new ObjectIdentifier(pbeWithSHAAnd40BitRC2CBC);
            pbeWithSHAAnd3KeyTripleDESCBC_OID = new ObjectIdentifier(pbeWithSHAAnd3KeyTripleDESCBC);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class CertEntry {
        final X509Certificate cert;
        final byte[] keyId;
        final String alias;

        CertEntry(X509Certificate cert, byte[] keyId, String alias) {
            this.cert = cert;
            this.keyId = keyId;
            this.alias = alias;
        }
    }

    private static class KeyEntry {
        Date date;
        byte[] protectedPrivKey;
        Certificate[] chain;
        byte[] keyId;
        String alias;

        private KeyEntry() {
        }
    }
}

