/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import org.openide.explorer.propertysheet.ButtonPanel;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.InplaceEditorFactory;
import org.openide.explorer.propertysheet.NodePropertyModel;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.ReusablePropertyEnv;
import org.openide.explorer.propertysheet.SheetTable;
import org.openide.nodes.Node;

final class SheetCellEditor
implements TableCellEditor,
ActionListener {
    ChangeEvent ce = null;
    ReusablePropertyEnv reusableEnv;
    private EventListenerList listenerList = null;
    private InplaceEditorFactory factory = null;
    private ButtonPanel buttonPanel = null;
    InplaceEditor inplaceEditor = null;
    boolean lastUpdateSuccess = true;
    private boolean inStopCellEditing = false;
    static boolean ignoreStopCellEditing = false;

    SheetCellEditor(ReusablePropertyEnv reusablePropertyEnv) {
        this.reusableEnv = reusablePropertyEnv;
    }

    void setInplaceEditor(InplaceEditor inplaceEditor) {
        if (inplaceEditor == this.inplaceEditor) {
            return;
        }
        if (PropUtils.isLoggable(SheetCellEditor.class)) {
            PropUtils.log(SheetCellEditor.class, "  SheetCellEditor.setInplaceEditor " + inplaceEditor);
        }
        if (inplaceEditor == null) {
            if (this.inplaceEditor != null) {
                this.inplaceEditor.clear();
            }
        } else {
            inplaceEditor.addActionListener(this);
        }
        if (this.inplaceEditor != null) {
            this.inplaceEditor.removeActionListener(this);
        }
        this.inplaceEditor = inplaceEditor;
    }

    PropertyEditor getPropertyEditor() {
        PropertyEditor propertyEditor = this.inplaceEditor == null ? null : this.inplaceEditor.getPropertyEditor();
        return propertyEditor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Component component = null;
        SheetTable sheetTable = (SheetTable)jTable;
        this.lastUpdateSuccess = true;
        Node.Property property = (Node.Property)sheetTable.getSheetModel().getPropertySetModel().getFeatureDescriptor(n);
        component = this.getEditorComponent(property, this, jTable.getForeground(), jTable.getBackground(), jTable.getSelectionBackground(), jTable.getSelectionForeground());
        if (component instanceof ButtonPanel) {
            ((ButtonPanel)component).setButtonAction(sheetTable.getCustomEditorAction());
        }
        if (component != null) {
            component.setFont(sheetTable.getFont());
        }
        return component;
    }

    private InplaceEditorFactory factory() {
        if (this.factory == null) {
            this.factory = new InplaceEditorFactory(true, this.reusableEnv);
        }
        return this.factory;
    }

    private ButtonPanel buttonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new ButtonPanel();
        }
        return this.buttonPanel;
    }

    public boolean isLastUpdateSuccessful() {
        return this.lastUpdateSuccess;
    }

    public Component getEditorComponent(Node.Property property, ActionListener actionListener, Color color, Color color2, Color color3, Color color4) {
        JComponent jComponent = null;
        InplaceEditor inplaceEditor = this.factory().getInplaceEditor(property, false);
        this.setInplaceEditor(inplaceEditor);
        PropertyEditor propertyEditor = this.inplaceEditor.getPropertyEditor();
        if (propertyEditor instanceof PropUtils.NoPropertyEditorEditor) {
            this.setInplaceEditor(null);
            return null;
        }
        boolean bl = Boolean.TRUE.equals(property.getValue("suppressCustomEditor"));
        JComponent jComponent2 = null;
        if (propertyEditor.supportsCustomEditor() && !bl) {
            jComponent2 = this.inplaceEditor.getComponent();
            ButtonPanel buttonPanel = this.buttonPanel();
            buttonPanel.setInplaceEditor(inplaceEditor);
            jComponent = buttonPanel;
        } else {
            jComponent = this.inplaceEditor.getComponent();
        }
        return jComponent;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (PropUtils.isLoggable(SheetCellEditor.class)) {
            PropUtils.log(SheetCellEditor.class, "Editor received an action event - " + actionEvent.getActionCommand());
        }
        if (!(actionEvent.getSource() instanceof InplaceEditor)) {
            if (PropUtils.isLoggable(SheetCellEditor.class)) {
                PropUtils.log(SheetCellEditor.class, " Event came from an unknown object type - assuming a legacy EnhancedPropertyEditor is the cause and updating property");
            }
            if (this.inplaceEditor != null) {
                if (PropUtils.isLoggable(SheetCellEditor.class)) {
                    PropUtils.log(SheetCellEditor.class, "WRITING PROPERTY VALUE FROM EDITOR TO PROPERTY");
                }
                PropUtils.updateProp(this.inplaceEditor.getPropertyModel(), this.inplaceEditor.getPropertyEditor(), "");
            }
            this.cancelCellEditing();
        }
        if (actionEvent.getActionCommand() == "success") {
            this.stopCellEditing();
        } else if (actionEvent.getActionCommand() == "failure") {
            if (PropUtils.psCommitOnFocusLoss) {
                this.stopCellEditing();
            } else {
                this.cancelCellEditing();
            }
        } else {
            return;
        }
    }

    protected void fireEditingStopped() {
        if (PropUtils.isLoggable(SheetCellEditor.class)) {
            PropUtils.log(SheetCellEditor.class, "    SheetCellEditor firing editing stopped to table ");
        }
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.ce == null) {
                this.ce = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingStopped(this.ce);
        }
    }

    protected void fireEditingCancelled() {
        if (PropUtils.isLoggable(SheetCellEditor.class)) {
            PropUtils.log(SheetCellEditor.class, "    SheetCellEditor firing editing cancelled to table ");
        }
        PropUtils.notifyEditingCancelled(this.reusableEnv);
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.ce == null) {
                this.ce = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingCanceled(this.ce);
        }
    }

    public InplaceEditor getInplaceEditor() {
        return this.inplaceEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelCellEditing() {
        if (this.inplaceEditor != null) {
            try {
                if (PropUtils.isLoggable(SheetCellEditor.class)) {
                    PropUtils.log(SheetCellEditor.class, "  SheetCellEditor.cancelCellEditing ", true);
                }
                this.fireEditingCancelled();
            }
            finally {
                this.setInplaceEditor(null);
            }
        }
    }

    @Override
    public Object getCellEditorValue() {
        if (this.inplaceEditor != null) {
            return this.inplaceEditor.getValue();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            return mouseEvent.getID() != 506;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopCellEditing() {
        block15: {
            PropertyModel propertyModel;
            block16: {
                block14: {
                    if (PropUtils.isLoggable(SheetCellEditor.class)) {
                        PropUtils.log(SheetCellEditor.class, "SheetCellEditor.StopCellEditing", true);
                    }
                    if (this.inplaceEditor == null || this.inStopCellEditing) break block15;
                    this.inStopCellEditing = true;
                    Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
                    if (!(PropUtils.psCommitOnFocusLoss || component instanceof JTable || this.inplaceEditor.isKnownComponent(component) || component == this.inplaceEditor.getComponent())) {
                        if (PropUtils.isLoggable(SheetCellEditor.class)) {
                            PropUtils.log(SheetCellEditor.class, "Focused component is unknown - discarding");
                        }
                        boolean bl = false;
                        return bl;
                    }
                    propertyModel = this.inplaceEditor.getPropertyModel();
                    try {
                        this.lastUpdateSuccess = PropUtils.updateProp(this.inplaceEditor);
                    }
                    catch (NullPointerException nullPointerException) {
                        if (this.inplaceEditor == null || this.inplaceEditor.getPropertyEditor() == null) {
                            String string = propertyModel instanceof NodePropertyModel ? ((NodePropertyModel)propertyModel).getProperty().toString() + " editor class " + (propertyModel.getPropertyEditorClass() != null ? propertyModel.getPropertyEditorClass().getName() : " unknown editor class") + " " : "";
                            Logger.getAnonymousLogger().warning("Property " + string + "value changed *while* the property sheet was setting its value " + "but before it had been set.  This almost always means that the " + "property editor has modified the property's value itself. " + "Property editors should NEVER directly modify properties, it is " + "up to the displayer to decide if/when the property should be " + "updated.  This behavior may cause an exception in the " + "future.");
                            Logger.getAnonymousLogger().log(Level.FINE, null, nullPointerException);
                            boolean bl = false;
                            if (!ignoreStopCellEditing) {
                                this.setInplaceEditor(null);
                            }
                            this.inStopCellEditing = false;
                            return bl;
                        }
                        throw nullPointerException;
                    }
                    if (!PropUtils.isLoggable(SheetCellEditor.class)) break block14;
                    PropUtils.log(SheetCellEditor.class, "  SheetCellEditor Firing editing stopped");
                }
                if (!ignoreStopCellEditing) {
                    this.fireEditingStopped();
                }
                break block16;
                finally {
                    if (!ignoreStopCellEditing) {
                        this.setInplaceEditor(null);
                    }
                    this.inStopCellEditing = false;
                }
            }
            this.tryPostSetAction(propertyModel);
            return true;
        }
        return false;
    }

    void tryPostSetAction(PropertyModel propertyModel) {
        Action action;
        FeatureDescriptor featureDescriptor;
        if (propertyModel instanceof ExPropertyModel && (featureDescriptor = ((ExPropertyModel)propertyModel).getFeatureDescriptor()) != null && (action = (Action)featureDescriptor.getValue("postSetAction")) != null) {
            if (PropUtils.isLoggable(SheetCellEditor.class)) {
                PropUtils.log(SheetCellEditor.class, "  Running post-set action " + action);
            }
            ActionEvent actionEvent = new ActionEvent(this, 1001, "success");
            action.actionPerformed(actionEvent);
        }
    }

    @Override
    public synchronized void addCellEditorListener(CellEditorListener cellEditorListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public synchronized void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
        if (this.listenerList.getListenerCount(CellEditorListener.class) == 0 && this.inplaceEditor != null) {
            this.inplaceEditor.clear();
        }
    }
}

