/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.Color;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.SummaryController;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.ui.HintsControllerUI;

public class HintsController
extends AbstractController {
    private static final String CLASS_URL_PREFIX = "file://class/";
    private static final String INSTANCE_URL_PREFIX = "file://instance/";
    private SummaryController summaryController;

    public HintsController(SummaryController summaryController) {
        this.summaryController = summaryController;
    }

    public SummaryController getSummaryController() {
        return this.summaryController;
    }

    public void createNavigationHistoryPoint() {
        this.summaryController.getHeapFragmentWalker().createNavigationHistoryPoint();
    }

    public void showURL(final URL uRL) {
        BrowserUtils.performTask(new Runnable(){

            @Override
            public void run() {
                String string = uRL.toString();
                final HeapFragmentWalker heapFragmentWalker = HintsController.this.summaryController.getHeapFragmentWalker();
                if (string.startsWith(HintsController.INSTANCE_URL_PREFIX)) {
                    string = string.substring(HintsController.INSTANCE_URL_PREFIX.length());
                    final String[] stringArray = string.split("/");
                    long l = Long.parseLong(stringArray[2]);
                    final Instance instance = heapFragmentWalker.getHeapFragment().getInstanceByID(l);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (instance != null) {
                                heapFragmentWalker.getClassesController().showInstance(instance);
                            } else {
                                ProfilerDialogs.displayError((String)Bundle.AnalysisController_CannotResolveInstanceMsg(stringArray[1], stringArray[0]));
                            }
                        }
                    });
                } else if (string.startsWith(HintsController.CLASS_URL_PREFIX)) {
                    string = string.substring(HintsController.CLASS_URL_PREFIX.length());
                    final String[] stringArray = string.split("/");
                    long l = Long.parseLong(stringArray[1]);
                    final JavaClass javaClass = heapFragmentWalker.getHeapFragment().getJavaClassByID(l);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (javaClass != null) {
                                heapFragmentWalker.getClassesController().showClass(javaClass);
                            } else {
                                ProfilerDialogs.displayError((String)Bundle.AnalysisController_CannotResolveClassMsg(stringArray[0]));
                            }
                        }
                    });
                }
            }
        });
    }

    public void computeBiggestObjects(final int n) {
        BrowserUtils.performTask(new Runnable(){

            @Override
            public void run() {
                int n2 = HintsController.this.getSummaryController().getHeapFragmentWalker().computeRetainedSizes(true, true);
                final String string = n2 == 3 ? HintsController.this.findBiggestObjects(n) : Bundle.HintsController_NoData();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((HintsControllerUI)((Object)HintsController.this.getPanel())).setResult(string);
                    }
                });
            }
        });
    }

    private String findBiggestObjects(int n) {
        Heap heap = this.getSummaryController().getHeapFragmentWalker().getHeapFragment();
        List list = heap.getBiggestObjectsByRetainedSize(n);
        StringBuffer stringBuffer = new StringBuffer();
        JavaClass javaClass = heap.getJavaClassByName(Class.class.getName());
        NumberFormat numberFormat = NumberFormat.getInstance();
        boolean bl = false;
        Color color = UIUtils.getDarker((Color)UIUtils.getProfilerResultsBackground());
        String string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        stringBuffer.append("<table border='0' width='100%'>");
        stringBuffer.append("<tr style='background-color:");
        stringBuffer.append(string).append(";'>");
        this.addHeading(stringBuffer, Bundle.HintsController_ClassName());
        this.addHeading(stringBuffer, Bundle.HintsController_RetainedSize());
        stringBuffer.append("</tr>");
        for (Instance instance : list) {
            stringBuffer.append(bl ? "<tr style='background-color: " + string + ";'>" : "<tr>");
            if (instance.getJavaClass().equals(javaClass)) {
                JavaClass javaClass2 = heap.getJavaClassByID(instance.getInstanceId());
                this.addCell(stringBuffer, this.printClass(javaClass2), false);
            } else {
                this.addCell(stringBuffer, this.printInstance(instance), false);
            }
            this.addCell(stringBuffer, numberFormat.format(instance.getRetainedSize()), true);
            stringBuffer.append("</tr>");
            bl = !bl;
        }
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((HintsControllerUI)((Object)this.getPanel())).getPresenter();
    }

    private void addHeading(StringBuffer stringBuffer, String string) {
        this.addTag(stringBuffer, string, "th", false);
    }

    private void addCell(StringBuffer stringBuffer, String string, boolean bl) {
        this.addTag(stringBuffer, string, "td", bl);
    }

    private void addTag(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        stringBuffer.append("<").append(string2).append(bl ? " style='text-align: right;'>" : ">");
        stringBuffer.append(string);
        stringBuffer.append("</").append(string2).append(">");
    }

    private String printInstance(Instance instance) {
        String string = instance.getJavaClass().getName();
        return "<a href='file://instance/" + string + "/" + instance.getInstanceNumber() + "/" + instance.getInstanceId() + "'>" + string + '#' + instance.getInstanceNumber() + "</a>";
    }

    private String printClass(JavaClass javaClass) {
        String string = javaClass.getName();
        return "<a href='file://class/" + string + "/" + javaClass.getJavaClassId() + "'>class " + string + "</a>";
    }

    private String printWindow(Instance instance, Heap heap) {
        boolean bl = DetailsUtils.getBooleanFieldValue(instance, "visible", false);
        if (!bl) {
            return null;
        }
        String string = "&nbsp;&nbsp;&nbsp;&nbsp;";
        string = string + this.printInstance(instance);
        String string2 = DetailsUtils.getInstanceString(instance, heap);
        if (string2 != null) {
            string = string + " - " + string2;
        }
        return string;
    }

    private void populateUIPreview() {
        String string;
        JavaClass javaClass;
        Iterator iterator;
        Object object;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = Icons.getResource((String)"HeapWalkerIcons.Window");
        String string3 = new String("<b><img border='0' align='bottom' src='nbresloc:/" + string2 + "'>&nbsp;&nbsp;" + Bundle.HintsController_ApplicationWindowsCaption() + "</b><br><hr>");
        stringBuilder.append(string3);
        Heap heap = this.getSummaryController().getHeapFragmentWalker().getHeapFragment();
        JavaClass javaClass2 = heap.getJavaClassByName("java.awt.Frame");
        if (javaClass2 != null) {
            object = javaClass2.getSubClasses();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                javaClass = (JavaClass)iterator.next();
                for (Instance instance : javaClass.getInstances()) {
                    string = this.printWindow(instance, heap);
                    if (string == null) continue;
                    stringBuilder.append(string);
                    stringBuilder.append("<br>");
                    bl = true;
                }
            }
        }
        if ((javaClass2 = heap.getJavaClassByName("java.awt.Dialog")) != null) {
            object = javaClass2.getSubClasses();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                javaClass = (JavaClass)iterator.next();
                for (Instance instance : javaClass.getInstances()) {
                    string = this.printWindow(instance, heap);
                    if (string == null) continue;
                    stringBuilder.append(string);
                    stringBuilder.append("<br>");
                    bl = true;
                }
            }
        }
        if (!bl) {
            return;
        }
        stringBuilder.append("<br>");
        object = stringBuilder.toString();
        SwingUtilities.invokeLater(new Runnable((String)object){
            final /* synthetic */ String val$s;
            {
                this.val$s = string;
            }

            @Override
            public void run() {
                ((HintsControllerUI)((Object)HintsController.this.getPanel())).setComponents(this.val$s);
            }
        });
    }

    @Override
    protected JPanel createControllerUI() {
        HintsControllerUI hintsControllerUI = new HintsControllerUI(this);
        BrowserUtils.performTask(new Runnable(){

            @Override
            public void run() {
                HintsController.this.populateUIPreview();
            }
        });
        return hintsControllerUI;
    }
}

