/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.DataSourceViewsManager;
import com.sun.tools.visualvm.core.ui.DataSourceWindow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataSourceWindowManager {
    private static final RequestProcessor processor = new RequestProcessor("DataSourceWindowManager Processor");
    private static final Logger LOGGER = Logger.getLogger(DataSourceWindowManager.class.getName());
    private static DataSourceWindowManager sharedInstance;
    private final Map<DataSource, DataSourceWindow> openedWindows = Collections.synchronizedMap(new HashMap());
    private final Map<DataSource, Set<DataSourceView>> openedViews = Collections.synchronizedMap(new HashMap());

    public static synchronized DataSourceWindowManager sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new DataSourceWindowManager();
        }
        return sharedInstance;
    }

    public boolean canOpenDataSource(DataSource dataSource) {
        return DataSourceViewsManager.sharedInstance().hasViewsFor(dataSource);
    }

    public void openDataSource(DataSource dataSource) {
        this.openDataSource(dataSource, true);
    }

    public void openDataSource(final DataSource dataSource, final boolean selectView) {
        processor.post(new Runnable(){

            public void run() {
                DataSourceWindowManager.this.openWindowAndAddView(dataSource, null, selectView, selectView, selectView);
            }
        });
    }

    public void closeDataSource(final DataSource dataSource) {
        processor.post(new Runnable(){

            public void run() {
                DataSource viewMaster = DataSourceWindowManager.this.getViewMaster(dataSource);
                final DataSourceWindow window = (DataSourceWindow)DataSourceWindowManager.this.openedWindows.get(viewMaster);
                if (window == null) {
                    return;
                }
                if (dataSource == viewMaster) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            window.removeAllViews();
                        }
                    });
                } else {
                    Set views = (Set)DataSourceWindowManager.this.openedViews.get(dataSource);
                    if (views != null) {
                        final HashSet viewsF = new HashSet(views);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                for (DataSourceView view : viewsF) {
                                    if (!window.containsView(view)) continue;
                                    window.removeView(view);
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    public void selectView(final DataSourceView view) {
        processor.post(new Runnable(){

            public void run() {
                DataSourceWindowManager.this.openWindowAndAddView(view.getDataSource(), view, true, true, true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openWindowAndAddView(DataSource dataSource, DataSourceView view, boolean selectView, final boolean selectWindow, final boolean windowToFront) {
        final DataSource viewMaster = this.getViewMaster(dataSource);
        final DataSourceWindow[] window = new DataSourceWindow[]{this.openedWindows.get(viewMaster)};
        final boolean wasOpened = window[0] != null;
        ProgressHandle pHandle = !wasOpened ? ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DataSourceWindowManager.class, (String)"LBL_Opening", (Object)DataSourceDescriptorFactory.getDescriptor(dataSource).getName())) : null;
        try {
            List<? extends DataSourceView> views;
            if (!wasOpened) {
                pHandle.setInitialDelay(0);
                pHandle.start();
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            window[0] = new DataSourceWindow(viewMaster);
                        }
                    });
                }
                catch (Exception e) {
                    LOGGER.severe("Failed to create window for " + dataSource);
                }
                this.openedWindows.put(viewMaster, window[0]);
                views = DataSourceViewsManager.sharedInstance().getViews(viewMaster);
                this.addViews(window[0], views);
            }
            if (dataSource != viewMaster) {
                views = DataSourceViewsManager.sharedInstance().getViews(dataSource);
                this.addViews(window[0], views);
                if (view == null && !views.isEmpty()) {
                    view = views.get(0);
                }
            }
            final DataSourceView viewToSelectF = selectView ? view : null;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (viewToSelectF != null) {
                        if (window[0].containsView(viewToSelectF)) {
                            window[0].selectView(viewToSelectF);
                        } else if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.warning("Tried to select not opened view " + viewToSelectF);
                        }
                    }
                    if (!wasOpened) {
                        window[0].open();
                    }
                    if (selectWindow) {
                        window[0].requestActive();
                    }
                    if (windowToFront) {
                        window[0].toFront();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(pHandle){
                final /* synthetic */ ProgressHandle val$pHandle;
                {
                    this.val$pHandle = progressHandle;
                }

                public void run() {
                    if (this.val$pHandle != null) {
                        this.val$pHandle.finish();
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private DataSource getViewMaster(DataSource dataSource) {
        DataSource master = dataSource.getMaster();
        while (master != null && master != DataSource.ROOT) {
            dataSource = master;
            master = dataSource.getMaster();
        }
        return dataSource;
    }

    private <X extends DataSourceView> void addViews(final DataSourceWindow window, List<X> views) {
        final ArrayList<DataSourceView> newViews = new ArrayList<DataSourceView>();
        for (DataSourceView view : views) {
            if (window.containsView(view)) continue;
            newViews.add(view);
        }
        for (DataSourceView view : newViews) {
            try {
                DataSource dataSource = view.getDataSource();
                Set<DataSourceView> cachedViews = this.openedViews.get(dataSource);
                if (cachedViews == null) {
                    cachedViews = new HashSet<DataSourceView>();
                    this.openedViews.put(dataSource, cachedViews);
                }
                cachedViews.add(view);
                view.viewWillBeAdded();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to pre-initialize view " + view, e);
            }
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    for (DataSourceView view : newViews) {
                        try {
                            window.addView(view);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.SEVERE, "Failed to initialize view " + view, e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize views for " + window.getDataSource(), e);
        }
        for (DataSourceView view : newViews) {
            try {
                view.viewAdded();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to post-initialize view " + view, e);
            }
        }
    }

    void unregisterClosedWindow(DataSourceWindow window) {
        this.openedWindows.remove(window.getDataSource());
    }

    void unregisterClosedView(DataSourceView view) {
        DataSource dataSource = view.getDataSource();
        Set<DataSourceView> views = this.openedViews.get(dataSource);
        if (views != null) {
            views.remove(view);
            if (views.isEmpty()) {
                this.openedViews.remove(dataSource);
            }
        } else if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.warning("Tried to unregister not opened view " + view);
        }
    }

    private DataSourceWindowManager() {
    }
}

