/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.shard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingService;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.FailedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class ShardStateAction
extends AbstractComponent {
    public static final String SHARD_STARTED_ACTION_NAME = "internal:cluster/shard/started";
    public static final String SHARD_FAILED_ACTION_NAME = "internal:cluster/shard/failure";
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final RoutingService routingService;
    private final BlockingQueue<ShardRoutingEntry> startedShardsQueue = ConcurrentCollections.newBlockingQueue();
    private final BlockingQueue<ShardRoutingEntry> failedShardQueue = ConcurrentCollections.newBlockingQueue();

    @Inject
    public ShardStateAction(Settings settings, ClusterService clusterService, TransportService transportService, AllocationService allocationService, RoutingService routingService) {
        super(settings);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.allocationService = allocationService;
        this.routingService = routingService;
        transportService.registerRequestHandler(SHARD_STARTED_ACTION_NAME, ShardRoutingEntry.class, "same", new ShardStartedTransportHandler());
        transportService.registerRequestHandler(SHARD_FAILED_ACTION_NAME, ShardRoutingEntry.class, "same", new ShardFailedTransportHandler());
    }

    public void shardFailed(ShardRouting shardRouting, String indexUUID, String message, @Nullable Throwable failure) {
        DiscoveryNode masterNode = this.clusterService.state().nodes().masterNode();
        if (masterNode == null) {
            this.logger.warn("can't send shard failed for {}, no master known.", shardRouting);
            return;
        }
        this.innerShardFailed(shardRouting, indexUUID, masterNode, message, failure);
    }

    public void resendShardFailed(ShardRouting shardRouting, String indexUUID, DiscoveryNode masterNode, String message, @Nullable Throwable failure) {
        this.logger.trace("{} re-sending failed shard for {}, indexUUID [{}], reason [{}]", failure, shardRouting.shardId(), shardRouting, indexUUID, message);
        this.innerShardFailed(shardRouting, indexUUID, masterNode, message, failure);
    }

    private void innerShardFailed(ShardRouting shardRouting, String indexUUID, final DiscoveryNode masterNode, String message, Throwable failure) {
        ShardRoutingEntry shardRoutingEntry = new ShardRoutingEntry(shardRouting, indexUUID, message, failure);
        this.transportService.sendRequest(masterNode, SHARD_FAILED_ACTION_NAME, shardRoutingEntry, new EmptyTransportResponseHandler("same"){

            @Override
            public void handleException(TransportException exp) {
                ShardStateAction.this.logger.warn("failed to send failed shard to {}", exp, masterNode);
            }
        });
    }

    public void shardStarted(ShardRouting shardRouting, String indexUUID, String reason) {
        DiscoveryNode masterNode = this.clusterService.state().nodes().masterNode();
        if (masterNode == null) {
            this.logger.warn("{} can't send shard started for {}, no master known.", shardRouting.shardId(), shardRouting);
            return;
        }
        this.shardStarted(shardRouting, indexUUID, reason, masterNode);
    }

    public void shardStarted(ShardRouting shardRouting, String indexUUID, String reason, final DiscoveryNode masterNode) {
        ShardRoutingEntry shardRoutingEntry = new ShardRoutingEntry(shardRouting, indexUUID, reason, null);
        this.logger.debug("{} sending shard started for {}", shardRoutingEntry.shardRouting.shardId(), shardRoutingEntry);
        this.transportService.sendRequest(masterNode, SHARD_STARTED_ACTION_NAME, new ShardRoutingEntry(shardRouting, indexUUID, reason, null), new EmptyTransportResponseHandler("same"){

            @Override
            public void handleException(TransportException exp) {
                ShardStateAction.this.logger.warn("failed to send shard started to [{}]", exp, masterNode);
            }
        });
    }

    private void handleShardFailureOnMaster(final ShardRoutingEntry shardRoutingEntry) {
        this.logger.warn("{} received shard failed for {}", shardRoutingEntry.failure, shardRoutingEntry.shardRouting.shardId(), shardRoutingEntry);
        this.failedShardQueue.add(shardRoutingEntry);
        this.clusterService.submitStateUpdateTask("shard-failed (" + shardRoutingEntry.shardRouting + "), message [" + shardRoutingEntry.message + "]", Priority.HIGH, new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (shardRoutingEntry.processed) {
                    return currentState;
                }
                ArrayList shardRoutingEntries = new ArrayList();
                ShardStateAction.this.failedShardQueue.drainTo(shardRoutingEntries);
                if (shardRoutingEntries.isEmpty()) {
                    return currentState;
                }
                ArrayList<FailedRerouteAllocation.FailedShard> shardRoutingsToBeApplied = new ArrayList<FailedRerouteAllocation.FailedShard>(shardRoutingEntries.size());
                for (ShardRoutingEntry entry : shardRoutingEntries) {
                    entry.processed = true;
                    shardRoutingsToBeApplied.add(new FailedRerouteAllocation.FailedShard(entry.shardRouting, entry.message, entry.failure));
                }
                RoutingAllocation.Result routingResult = ShardStateAction.this.allocationService.applyFailedShards(currentState, shardRoutingsToBeApplied);
                if (!routingResult.changed()) {
                    return currentState;
                }
                return ClusterState.builder(currentState).routingResult(routingResult).build();
            }

            @Override
            public void onFailure(String source, Throwable t) {
                ShardStateAction.this.logger.error("unexpected failure during [{}]", t, source);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (oldState != newState && newState.getRoutingNodes().unassigned().size() > 0) {
                    ShardStateAction.this.logger.trace("unassigned shards after shard failures. scheduling a reroute.", new Object[0]);
                    ShardStateAction.this.routingService.reroute("unassigned shards after shard failures, scheduling a reroute");
                }
            }
        });
    }

    private void shardStartedOnMaster(final ShardRoutingEntry shardRoutingEntry) {
        this.logger.debug("received shard started for {}", shardRoutingEntry);
        this.startedShardsQueue.add(shardRoutingEntry);
        this.clusterService.submitStateUpdateTask("shard-started (" + shardRoutingEntry.shardRouting + "), reason [" + shardRoutingEntry.message + "]", Priority.URGENT, new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (shardRoutingEntry.processed) {
                    return currentState;
                }
                ArrayList shardRoutingEntries = new ArrayList();
                ShardStateAction.this.startedShardsQueue.drainTo(shardRoutingEntries);
                if (shardRoutingEntries.isEmpty()) {
                    return currentState;
                }
                ArrayList<ShardRouting> shardRoutingToBeApplied = new ArrayList<ShardRouting>(shardRoutingEntries.size());
                for (ShardRoutingEntry entry : shardRoutingEntries) {
                    entry.processed = true;
                    shardRoutingToBeApplied.add(entry.shardRouting);
                }
                if (shardRoutingToBeApplied.isEmpty()) {
                    return currentState;
                }
                RoutingAllocation.Result routingResult = ShardStateAction.this.allocationService.applyStartedShards(currentState, shardRoutingToBeApplied, true);
                if (!routingResult.changed()) {
                    return currentState;
                }
                return ClusterState.builder(currentState).routingResult(routingResult).build();
            }

            @Override
            public void onFailure(String source, Throwable t) {
                ShardStateAction.this.logger.error("unexpected failure during [{}]", t, source);
            }
        });
    }

    static class ShardRoutingEntry
    extends TransportRequest {
        ShardRouting shardRouting;
        String indexUUID = "_na_";
        String message;
        Throwable failure;
        volatile boolean processed;

        ShardRoutingEntry() {
        }

        ShardRoutingEntry(ShardRouting shardRouting, String indexUUID, String message, @Nullable Throwable failure) {
            this.shardRouting = shardRouting;
            this.indexUUID = indexUUID;
            this.message = message;
            this.failure = failure;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardRouting = ShardRouting.readShardRoutingEntry(in);
            this.indexUUID = in.readString();
            this.message = in.readString();
            this.failure = in.readThrowable();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardRouting.writeTo(out);
            out.writeString(this.indexUUID);
            out.writeString(this.message);
            out.writeThrowable(this.failure);
        }

        public String toString() {
            return "" + this.shardRouting + ", indexUUID [" + this.indexUUID + "], message [" + this.message + "], failure [" + ExceptionsHelper.detailedMessage(this.failure) + "]";
        }
    }

    class ShardStartedTransportHandler
    implements TransportRequestHandler<ShardRoutingEntry> {
        ShardStartedTransportHandler() {
        }

        @Override
        public void messageReceived(ShardRoutingEntry request, TransportChannel channel) throws Exception {
            ShardStateAction.this.shardStartedOnMaster(request);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    private class ShardFailedTransportHandler
    implements TransportRequestHandler<ShardRoutingEntry> {
        private ShardFailedTransportHandler() {
        }

        @Override
        public void messageReceived(ShardRoutingEntry request, TransportChannel channel) throws Exception {
            ShardStateAction.this.handleShardFailureOnMaster(request);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }
}

