/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.network;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Constants;

public abstract class NetworkUtils {
    @Deprecated
    static final boolean PREFER_V6 = Boolean.parseBoolean(System.getProperty("java.net.preferIPv6Addresses", "false"));
    @Deprecated
    public static final boolean SUPPORTS_V6;

    private NetworkUtils() {
    }

    static int sortKey(InetAddress address, boolean prefer_v6) {
        int key = address.getAddress().length;
        if (prefer_v6) {
            key = -key;
        }
        if (address.isAnyLocalAddress()) {
            key += 5;
        }
        if (address.isMulticastAddress()) {
            key += 4;
        }
        if (address.isLoopbackAddress()) {
            key += 3;
        }
        if (address.isLinkLocalAddress()) {
            key += 2;
        }
        if (address.isSiteLocalAddress()) {
            ++key;
        }
        return key;
    }

    @Deprecated
    static void sortAddresses(List<InetAddress> list) {
        Collections.sort(list, new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress left, InetAddress right) {
                int cmp = Integer.compare(NetworkUtils.sortKey(left, PREFER_V6), NetworkUtils.sortKey(right, PREFER_V6));
                if (cmp == 0) {
                    cmp = new BytesRef(left.getAddress()).compareTo(new BytesRef(right.getAddress()));
                }
                return cmp;
            }
        });
    }

    static List<NetworkInterface> getInterfaces() throws SocketException {
        ArrayList<NetworkInterface> all = new ArrayList<NetworkInterface>();
        NetworkUtils.addAllInterfaces(all, Collections.list(NetworkInterface.getNetworkInterfaces()));
        Collections.sort(all, new Comparator<NetworkInterface>(){

            @Override
            public int compare(NetworkInterface left, NetworkInterface right) {
                return Integer.compare(left.getIndex(), right.getIndex());
            }
        });
        return all;
    }

    private static void addAllInterfaces(List<NetworkInterface> target, List<NetworkInterface> level) {
        if (!level.isEmpty()) {
            target.addAll(level);
            for (NetworkInterface intf : level) {
                NetworkUtils.addAllInterfaces(target, Collections.list(intf.getSubInterfaces()));
            }
        }
    }

    public static boolean defaultReuseAddress() {
        return !Constants.WINDOWS;
    }

    static InetAddress[] getLoopbackAddresses() throws SocketException {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        for (NetworkInterface intf : NetworkUtils.getInterfaces()) {
            if (!intf.isLoopback() || !intf.isUp()) continue;
            list.addAll(Collections.list(intf.getInetAddresses()));
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No up-and-running loopback interfaces found, got " + NetworkUtils.getInterfaces());
        }
        NetworkUtils.sortAddresses(list);
        return list.toArray(new InetAddress[list.size()]);
    }

    static InetAddress[] getFirstNonLoopbackAddresses() throws SocketException {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        for (NetworkInterface intf : NetworkUtils.getInterfaces()) {
            if (intf.isLoopback() || !intf.isUp()) continue;
            list.addAll(Collections.list(intf.getInetAddresses()));
            break;
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No up-and-running non-loopback interfaces found, got " + NetworkUtils.getInterfaces());
        }
        NetworkUtils.sortAddresses(list);
        return list.toArray(new InetAddress[list.size()]);
    }

    static InetAddress[] getAddressesForInterface(String name) throws SocketException {
        NetworkInterface intf = NetworkInterface.getByName(name);
        if (intf == null) {
            throw new IllegalArgumentException("No interface named '" + name + "' found, got " + NetworkUtils.getInterfaces());
        }
        if (!intf.isUp()) {
            throw new IllegalArgumentException("Interface '" + name + "' is not up and running");
        }
        ArrayList<InetAddress> list = Collections.list(intf.getInetAddresses());
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Interface '" + name + "' has no internet addresses");
        }
        NetworkUtils.sortAddresses(list);
        return list.toArray(new InetAddress[list.size()]);
    }

    static InetAddress[] getAllByName(String host) throws UnknownHostException {
        InetAddress[] addresses = InetAddress.getAllByName(host);
        ArrayList<InetAddress> unique = new ArrayList<InetAddress>(new HashSet<InetAddress>(Arrays.asList(addresses)));
        NetworkUtils.sortAddresses(unique);
        return unique.toArray(new InetAddress[unique.size()]);
    }

    static InetAddress[] filterIPV4(InetAddress[] addresses) {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        for (InetAddress address : addresses) {
            if (!(address instanceof Inet4Address)) continue;
            list.add(address);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No ipv4 addresses found in " + Arrays.toString(addresses));
        }
        return list.toArray(new InetAddress[list.size()]);
    }

    static InetAddress[] filterIPV6(InetAddress[] addresses) {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        for (InetAddress address : addresses) {
            if (!(address instanceof Inet6Address)) continue;
            list.add(address);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No ipv6 addresses found in " + Arrays.toString(addresses));
        }
        return list.toArray(new InetAddress[list.size()]);
    }

    static {
        boolean v = false;
        try {
            block2: for (NetworkInterface nic : NetworkUtils.getInterfaces()) {
                for (InetAddress address : Collections.list(nic.getInetAddresses())) {
                    if (!(address instanceof Inet6Address)) continue;
                    v = true;
                    continue block2;
                }
            }
        }
        catch (SecurityException | SocketException misconfiguration) {
            v = true;
        }
        SUPPORTS_V6 = v;
    }
}

