/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.lucene.util.Constants;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.ESFileStore;

@SuppressForbidden(reason="configures paths for the system")
public class Environment {
    private final Settings settings;
    private final Path[] dataFiles;
    private final Path[] dataWithClusterFiles;
    private final Path[] repoFiles;
    private final Path configFile;
    private final Path scriptsFile;
    private final Path pluginsFile;
    private final Path sharedDataFile;
    private final Path binFile;
    private final Path libFile;
    private final Path logsFile;
    private final Path pidFile;
    private final Path tmpFile = PathUtils.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private static final FileStore[] fileStores;

    public Environment(Settings settings) {
        this.settings = settings;
        if (settings.get("path.home") == null) {
            throw new IllegalStateException("path.home is not configured");
        }
        Path homeFile = PathUtils.get(Strings.cleanPath(settings.get("path.home")), new String[0]);
        this.configFile = settings.get("path.conf") != null ? PathUtils.get(Strings.cleanPath(settings.get("path.conf")), new String[0]) : homeFile.resolve("config");
        this.scriptsFile = settings.get("path.scripts") != null ? PathUtils.get(Strings.cleanPath(settings.get("path.scripts")), new String[0]) : this.configFile.resolve("scripts");
        this.pluginsFile = settings.get("path.plugins") != null ? PathUtils.get(Strings.cleanPath(settings.get("path.plugins")), new String[0]) : homeFile.resolve("plugins");
        String[] dataPaths = settings.getAsArray("path.data");
        if (dataPaths.length > 0) {
            this.dataFiles = new Path[dataPaths.length];
            this.dataWithClusterFiles = new Path[dataPaths.length];
            for (int i = 0; i < dataPaths.length; ++i) {
                this.dataFiles[i] = PathUtils.get(dataPaths[i], new String[0]);
                this.dataWithClusterFiles[i] = this.dataFiles[i].resolve(ClusterName.clusterNameFromSettings(settings).value());
            }
        } else {
            this.dataFiles = new Path[]{homeFile.resolve("data")};
            this.dataWithClusterFiles = new Path[]{homeFile.resolve("data").resolve(ClusterName.clusterNameFromSettings(settings).value())};
        }
        this.sharedDataFile = settings.get("path.shared_data") != null ? PathUtils.get(Strings.cleanPath(settings.get("path.shared_data")), new String[0]) : null;
        String[] repoPaths = settings.getAsArray("path.repo");
        if (repoPaths.length > 0) {
            this.repoFiles = new Path[repoPaths.length];
            for (int i = 0; i < repoPaths.length; ++i) {
                this.repoFiles[i] = PathUtils.get(repoPaths[i], new String[0]);
            }
        } else {
            this.repoFiles = new Path[0];
        }
        this.logsFile = settings.get("path.logs") != null ? PathUtils.get(Strings.cleanPath(settings.get("path.logs")), new String[0]) : homeFile.resolve("logs");
        this.pidFile = settings.get("pidfile") != null ? PathUtils.get(Strings.cleanPath(settings.get("pidfile")), new String[0]) : null;
        this.binFile = homeFile.resolve("bin");
        this.libFile = homeFile.resolve("lib");
    }

    public Settings settings() {
        return this.settings;
    }

    public Path[] dataFiles() {
        return this.dataFiles;
    }

    public Path sharedDataFile() {
        return this.sharedDataFile;
    }

    public Path[] dataWithClusterFiles() {
        return this.dataWithClusterFiles;
    }

    public Path[] repoFiles() {
        return this.repoFiles;
    }

    public Path resolveRepoFile(String location) {
        return PathUtils.get(this.repoFiles, location);
    }

    public URL resolveRepoURL(URL url) {
        try {
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                if (url.getHost() == null || "".equals(url.getHost())) {
                    Path path = PathUtils.get(this.repoFiles, url.toURI());
                    if (path == null) {
                        return null;
                    }
                    return path.toUri().toURL();
                }
                return null;
            }
            if ("jar".equals(url.getProtocol())) {
                String file = url.getFile();
                int pos = file.indexOf("!/");
                if (pos < 0) {
                    return null;
                }
                String jarTail = file.substring(pos);
                String filePath = file.substring(0, pos);
                URL internalUrl = new URL(filePath);
                URL normalizedUrl = this.resolveRepoURL(internalUrl);
                if (normalizedUrl == null) {
                    return null;
                }
                return new URL("jar", "", normalizedUrl.toExternalForm() + jarTail);
            }
            return null;
        }
        catch (MalformedURLException ex) {
            return null;
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public Path configFile() {
        return this.configFile;
    }

    public Path scriptsFile() {
        return this.scriptsFile;
    }

    public Path pluginsFile() {
        return this.pluginsFile;
    }

    public Path binFile() {
        return this.binFile;
    }

    public Path libFile() {
        return this.libFile;
    }

    public Path logsFile() {
        return this.logsFile;
    }

    public Path pidFile() {
        return this.pidFile;
    }

    public Path tmpFile() {
        return this.tmpFile;
    }

    public static FileStore getFileStore(Path path) throws IOException {
        return ESFileStore.getMatchingFileStore(path, fileStores);
    }

    @SuppressForbidden(reason="works around https://bugs.openjdk.java.net/browse/JDK-8034057")
    public static boolean isWritable(Path path) throws IOException {
        boolean v = Files.isWritable(path);
        if (v || !Constants.WINDOWS) {
            return v;
        }
        try {
            Files.setLastModifiedTime(path, Files.getLastModifiedTime(path, new LinkOption[0]));
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    static {
        ArrayList<ESFileStore> allStores = new ArrayList<ESFileStore>();
        for (FileStore store : PathUtils.getDefaultFileSystem().getFileStores()) {
            allStores.add(new ESFileStore(store));
        }
        fileStores = allStores.toArray(new ESFileStore[allStores.size()]);
    }
}

