/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;

public final class ScriptContextRegistry {
    static final ImmutableSet<String> RESERVED_SCRIPT_CONTEXTS = ScriptContextRegistry.reservedScriptContexts();
    private final ImmutableMap<String, ScriptContext> scriptContexts;

    ScriptContextRegistry(Iterable<ScriptContext.Plugin> customScriptContexts) {
        HashMap scriptContexts = Maps.newHashMap();
        for (ScriptContext.Standard scriptContext : ScriptContext.Standard.values()) {
            scriptContexts.put(scriptContext.getKey(), scriptContext);
        }
        for (ScriptContext.Plugin customScriptContext : customScriptContexts) {
            this.validateScriptContext(customScriptContext);
            ScriptContext previousContext = scriptContexts.put(customScriptContext.getKey(), customScriptContext);
            if (previousContext == null) continue;
            throw new IllegalArgumentException("script context [" + customScriptContext.getKey() + "] cannot be registered twice");
        }
        this.scriptContexts = ImmutableMap.copyOf((Map)scriptContexts);
    }

    ImmutableCollection<ScriptContext> scriptContexts() {
        return this.scriptContexts.values();
    }

    boolean isSupportedContext(ScriptContext scriptContext) {
        return this.scriptContexts.containsKey((Object)scriptContext.getKey());
    }

    private void validateScriptContext(ScriptContext.Plugin scriptContext) {
        if (RESERVED_SCRIPT_CONTEXTS.contains((Object)scriptContext.getPluginName())) {
            throw new IllegalArgumentException("[" + scriptContext.getPluginName() + "] is a reserved name, it cannot be registered as a custom script context");
        }
        if (RESERVED_SCRIPT_CONTEXTS.contains((Object)scriptContext.getOperation())) {
            throw new IllegalArgumentException("[" + scriptContext.getOperation() + "] is a reserved name, it cannot be registered as a custom script context");
        }
    }

    private static ImmutableSet<String> reservedScriptContexts() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ScriptService.ScriptType scriptType : ScriptService.ScriptType.values()) {
            builder.add((Object)scriptType.toString());
        }
        for (Enum enum_ : ScriptContext.Standard.values()) {
            builder.add((Object)((ScriptContext.Standard)enum_).getKey());
        }
        builder.add((Object)"script").add((Object)"engine");
        return builder.build();
    }
}

