/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.BucketStreamContext;
import org.elasticsearch.search.aggregations.bucket.BucketStreams;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class InternalHistogram<B extends Bucket>
extends InternalMultiBucketAggregation<InternalHistogram, B>
implements Histogram {
    static final InternalAggregation.Type TYPE = new InternalAggregation.Type("histogram", "histo");
    private static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalHistogram readResult(StreamInput in) throws IOException {
            InternalHistogram histogram = new InternalHistogram();
            histogram.readFrom(in);
            return histogram;
        }
    };
    private static final BucketStreams.Stream<Bucket> BUCKET_STREAM = new BucketStreams.Stream<Bucket>(){

        @Override
        public Bucket readResult(StreamInput in, BucketStreamContext context) throws IOException {
            Factory factory = (Factory)context.attributes().get("factory");
            if (factory == null) {
                throw new IllegalStateException("No factory found for histogram buckets");
            }
            Bucket histogram = new Bucket(context.keyed(), context.formatter(), factory);
            histogram.readFrom(in);
            return histogram;
        }

        @Override
        public BucketStreamContext getBucketStreamContext(Bucket bucket) {
            BucketStreamContext context = new BucketStreamContext();
            context.formatter(bucket.formatter);
            context.keyed(bucket.keyed);
            return context;
        }
    };
    protected List<B> buckets;
    private InternalOrder order;
    private ValueFormatter formatter;
    private boolean keyed;
    private long minDocCount;
    private EmptyBucketInfo emptyBucketInfo;
    protected Factory<B> factory;

    public static void registerStream() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
        BucketStreams.registerStream(BUCKET_STREAM, TYPE.stream());
    }

    InternalHistogram() {
    }

    InternalHistogram(String name, List<B> buckets, InternalOrder order, long minDocCount, EmptyBucketInfo emptyBucketInfo, ValueFormatter formatter, boolean keyed, Factory<B> factory, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.buckets = buckets;
        this.order = order;
        assert (minDocCount == 0L == (emptyBucketInfo != null));
        this.minDocCount = minDocCount;
        this.emptyBucketInfo = emptyBucketInfo;
        this.formatter = formatter;
        this.keyed = keyed;
        this.factory = factory;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    public List<B> getBuckets() {
        return this.buckets;
    }

    public Factory<B> getFactory() {
        return this.factory;
    }

    public Rounding getRounding() {
        return this.emptyBucketInfo.rounding;
    }

    @Override
    public InternalHistogram<B> create(List<B> buckets) {
        return this.getFactory().create(buckets, this);
    }

    @Override
    public B createBucket(InternalAggregations aggregations, B prototype) {
        return this.getFactory().createBucket(aggregations, prototype);
    }

    private List<B> reduceBuckets(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        PriorityQueue pq = new PriorityQueue<IteratorAndCurrent<B>>(aggregations.size()){

            protected boolean lessThan(IteratorAndCurrent<B> a, IteratorAndCurrent<B> b) {
                return ((Bucket)((IteratorAndCurrent)a).current).key < ((Bucket)((IteratorAndCurrent)b).current).key;
            }
        };
        for (InternalAggregation aggregation : aggregations) {
            InternalHistogram histogram = (InternalHistogram)aggregation;
            if (histogram.buckets.isEmpty()) continue;
            pq.add(new IteratorAndCurrent<B>(histogram.buckets.iterator()));
        }
        ArrayList reducedBuckets = new ArrayList();
        if (pq.size() > 0) {
            Object reduced;
            ArrayList<Object> currentBuckets = new ArrayList<Object>();
            long key = ((Bucket)((IteratorAndCurrent)((IteratorAndCurrent)pq.top())).current).key;
            do {
                IteratorAndCurrent top = (IteratorAndCurrent)pq.top();
                if (((Bucket)((IteratorAndCurrent)top).current).key != key) {
                    Object reduced2 = ((Bucket)currentBuckets.get(0)).reduce(currentBuckets, reduceContext);
                    if (((Bucket)reduced2).getDocCount() >= this.minDocCount) {
                        reducedBuckets.add(reduced2);
                    }
                    currentBuckets.clear();
                    key = ((Bucket)((IteratorAndCurrent)top).current).key;
                }
                currentBuckets.add(top.current);
                if (top.iterator.hasNext()) {
                    Bucket next = (Bucket)top.iterator.next();
                    assert (next.key > ((Bucket)((IteratorAndCurrent)top).current).key) : "shards must return data sorted by key";
                    top.current = next;
                    pq.updateTop();
                    continue;
                }
                pq.pop();
            } while (pq.size() > 0);
            if (!currentBuckets.isEmpty() && ((Bucket)(reduced = ((Bucket)currentBuckets.get(0)).reduce(currentBuckets, reduceContext))).getDocCount() >= this.minDocCount) {
                reducedBuckets.add(reduced);
            }
        }
        return reducedBuckets;
    }

    private void addEmptyBuckets(List<B> list) {
        long key;
        Bucket lastBucket = null;
        ExtendedBounds bounds = this.emptyBucketInfo.bounds;
        ListIterator<B> iter = list.listIterator();
        if (bounds != null) {
            Bucket firstBucket;
            Bucket bucket = firstBucket = iter.hasNext() ? (Bucket)list.get(iter.nextIndex()) : null;
            if (firstBucket == null) {
                if (bounds.min != null && bounds.max != null) {
                    key = bounds.min;
                    long max = bounds.max;
                    while (key <= max) {
                        iter.add(this.getFactory().createBucket(key, 0L, this.emptyBucketInfo.subAggregations, this.keyed, this.formatter));
                        key = this.emptyBucketInfo.rounding.nextRoundingValue(key);
                    }
                }
            } else if (bounds.min != null && (key = bounds.min.longValue()) < firstBucket.key) {
                while (key < firstBucket.key) {
                    iter.add(this.getFactory().createBucket(key, 0L, this.emptyBucketInfo.subAggregations, this.keyed, this.formatter));
                    key = this.emptyBucketInfo.rounding.nextRoundingValue(key);
                }
            }
        }
        while (iter.hasNext()) {
            Bucket nextBucket = (Bucket)list.get(iter.nextIndex());
            if (lastBucket != null) {
                key = this.emptyBucketInfo.rounding.nextRoundingValue(lastBucket.key);
                while (key < nextBucket.key) {
                    iter.add(this.getFactory().createBucket(key, 0L, this.emptyBucketInfo.subAggregations, this.keyed, this.formatter));
                    key = this.emptyBucketInfo.rounding.nextRoundingValue(key);
                }
                assert (key == nextBucket.key);
            }
            lastBucket = (Bucket)iter.next();
        }
        if (bounds != null && lastBucket != null && bounds.max != null && bounds.max > lastBucket.key) {
            long key2 = this.emptyBucketInfo.rounding.nextRoundingValue(lastBucket.key);
            long max = bounds.max;
            while (key2 <= max) {
                iter.add(this.getFactory().createBucket(key2, 0L, this.emptyBucketInfo.subAggregations, this.keyed, this.formatter));
                key2 = this.emptyBucketInfo.rounding.nextRoundingValue(key2);
            }
        }
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        List<B> reducedBuckets = this.reduceBuckets(aggregations, reduceContext);
        if (this.minDocCount == 0L) {
            this.addEmptyBuckets(reducedBuckets);
        }
        if (this.order != InternalOrder.KEY_ASC) {
            if (this.order == InternalOrder.KEY_DESC) {
                ArrayList<B> reverse = new ArrayList<B>(reducedBuckets);
                Collections.reverse(reverse);
                reducedBuckets = reverse;
            } else {
                CollectionUtil.introSort(reducedBuckets, this.order.comparator());
            }
        }
        return this.getFactory().create(this.getName(), reducedBuckets, this.order, this.minDocCount, this.emptyBucketInfo, this.formatter, this.keyed, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        this.factory = InternalHistogram.resolveFactory(in.readString());
        this.order = InternalOrder.Streams.readOrder(in);
        this.minDocCount = in.readVLong();
        if (this.minDocCount == 0L) {
            this.emptyBucketInfo = EmptyBucketInfo.readFrom(in);
        }
        this.formatter = ValueFormatterStreams.readOptional(in);
        this.keyed = in.readBoolean();
        int size = in.readVInt();
        ArrayList<B> buckets = new ArrayList<B>(size);
        for (int i = 0; i < size; ++i) {
            B bucket = this.getFactory().createEmptyBucket(this.keyed, this.formatter);
            ((Bucket)bucket).readFrom(in);
            buckets.add(bucket);
        }
        this.buckets = buckets;
    }

    private static <B extends Bucket> Factory<B> resolveFactory(String factoryType) {
        if (factoryType.equals(InternalDateHistogram.TYPE.name())) {
            return new InternalDateHistogram.Factory();
        }
        if (factoryType.equals(TYPE.name())) {
            return new Factory();
        }
        throw new IllegalStateException("Invalid histogram factory type [" + factoryType + "]");
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.factory.type());
        InternalOrder.Streams.writeOrder(this.order, out);
        out.writeVLong(this.minDocCount);
        if (this.minDocCount == 0L) {
            EmptyBucketInfo.writeTo(this.emptyBucketInfo, out);
        }
        ValueFormatterStreams.writeOptional(this.formatter, out);
        out.writeBoolean(this.keyed);
        out.writeVInt(this.buckets.size());
        for (Bucket bucket : this.buckets) {
            bucket.writeTo(out);
        }
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(InternalAggregation.CommonFields.BUCKETS);
        } else {
            builder.startArray(InternalAggregation.CommonFields.BUCKETS);
        }
        for (Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder;
    }

    private static class IteratorAndCurrent<B> {
        private final Iterator<B> iterator;
        private B current;

        IteratorAndCurrent(Iterator<B> iterator) {
            this.iterator = iterator;
            this.current = iterator.next();
        }
    }

    public static class Factory<B extends Bucket> {
        protected Factory() {
        }

        public String type() {
            return TYPE.name();
        }

        public InternalHistogram<B> create(String name, List<B> buckets, InternalOrder order, long minDocCount, EmptyBucketInfo emptyBucketInfo, ValueFormatter formatter, boolean keyed, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
            return new InternalHistogram<B>(name, buckets, order, minDocCount, emptyBucketInfo, formatter, keyed, this, pipelineAggregators, metaData);
        }

        public InternalHistogram<B> create(List<B> buckets, InternalHistogram<B> prototype) {
            return new InternalHistogram<B>(((InternalHistogram)prototype).name, buckets, ((InternalHistogram)prototype).order, ((InternalHistogram)prototype).minDocCount, ((InternalHistogram)prototype).emptyBucketInfo, ((InternalHistogram)prototype).formatter, ((InternalHistogram)prototype).keyed, this, prototype.pipelineAggregators(), ((InternalHistogram)prototype).metaData);
        }

        public B createBucket(InternalAggregations aggregations, B prototype) {
            return (B)new Bucket(((Bucket)prototype).key, ((Bucket)prototype).docCount, ((Bucket)prototype).getKeyed(), ((Bucket)prototype).formatter, this, aggregations);
        }

        public B createBucket(Object key, long docCount, InternalAggregations aggregations, boolean keyed, ValueFormatter formatter) {
            if (key instanceof Number) {
                return (B)new Bucket(((Number)key).longValue(), docCount, keyed, formatter, this, aggregations);
            }
            throw new AggregationExecutionException("Expected key of type Number but got [" + key + "]");
        }

        protected B createEmptyBucket(boolean keyed, ValueFormatter formatter) {
            return (B)new Bucket(keyed, formatter, this);
        }
    }

    static class EmptyBucketInfo {
        final Rounding rounding;
        final InternalAggregations subAggregations;
        final ExtendedBounds bounds;

        EmptyBucketInfo(Rounding rounding, InternalAggregations subAggregations) {
            this(rounding, subAggregations, null);
        }

        EmptyBucketInfo(Rounding rounding, InternalAggregations subAggregations, ExtendedBounds bounds) {
            this.rounding = rounding;
            this.subAggregations = subAggregations;
            this.bounds = bounds;
        }

        public static EmptyBucketInfo readFrom(StreamInput in) throws IOException {
            Rounding rounding = Rounding.Streams.read(in);
            InternalAggregations aggs = InternalAggregations.readAggregations(in);
            if (in.readBoolean()) {
                return new EmptyBucketInfo(rounding, aggs, ExtendedBounds.readFrom(in));
            }
            return new EmptyBucketInfo(rounding, aggs);
        }

        public static void writeTo(EmptyBucketInfo info, StreamOutput out) throws IOException {
            Rounding.Streams.write(info.rounding, out);
            info.subAggregations.writeTo(out);
            out.writeBoolean(info.bounds != null);
            if (info.bounds != null) {
                info.bounds.writeTo(out);
            }
        }
    }

    public static class Bucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements Histogram.Bucket {
        long key;
        long docCount;
        InternalAggregations aggregations;
        private final transient boolean keyed;
        protected final transient ValueFormatter formatter;
        private Factory<?> factory;

        public Bucket(boolean keyed, ValueFormatter formatter, Factory<?> factory) {
            this.formatter = formatter;
            this.keyed = keyed;
            this.factory = factory;
        }

        public Bucket(long key, long docCount, boolean keyed, ValueFormatter formatter, Factory factory, InternalAggregations aggregations) {
            this(keyed, formatter, factory);
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        protected Factory<?> getFactory() {
            return this.factory;
        }

        @Override
        public String getKeyAsString() {
            return this.formatter != null ? this.formatter.format(this.key) : ValueFormatter.RAW.format(this.key);
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        <B extends Bucket> B reduce(List<B> buckets, InternalAggregation.ReduceContext context) {
            ArrayList<InternalAggregations> aggregations = new ArrayList<InternalAggregations>(buckets.size());
            long docCount = 0L;
            for (Bucket bucket : buckets) {
                docCount += bucket.docCount;
                aggregations.add((InternalAggregations)bucket.getAggregations());
            }
            InternalAggregations aggs = InternalAggregations.reduce(aggregations, context);
            return (B)this.getFactory().createBucket(this.key, docCount, aggs, this.keyed, this.formatter);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.formatter != ValueFormatter.RAW) {
                StringText keyTxt = new StringText(this.formatter.format(this.key));
                if (this.keyed) {
                    builder.startObject(keyTxt.string());
                } else {
                    builder.startObject();
                }
                builder.field(InternalAggregation.CommonFields.KEY_AS_STRING, (Text)keyTxt);
            } else if (this.keyed) {
                builder.startObject(String.valueOf(this.getKey()));
            } else {
                builder.startObject();
            }
            builder.field(InternalAggregation.CommonFields.KEY, this.key);
            builder.field(InternalAggregation.CommonFields.DOC_COUNT, this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.key = in.readLong();
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readAggregations(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.key);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        public ValueFormatter getFormatter() {
            return this.formatter;
        }

        public boolean getKeyed() {
            return this.keyed;
        }
    }
}

