/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.datatransfer.JEditDataFlavor;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.TextArea;

public class PasteSpecialDialog
extends EnhancedDialog {
    private static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, JEditDataFlavor.jEditRichTextDataFlavor, JEditDataFlavor.html};
    private final TextArea textArea;
    private final JButton ok;
    private final JButton cancel;
    private JList flavorList;

    public PasteSpecialDialog(View view, TextArea textArea) {
        super(view, jEdit.getProperty("paste-special.title"), true);
        this.textArea = textArea;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        Registers.Register register = Registers.getRegister('$');
        Transferable transferable = register.getTransferable();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        List<DataFlavor> list = Arrays.asList(dataFlavorArray);
        Vector<DataFlavor> vector = new Vector<DataFlavor>(flavors.length);
        for (DataFlavor dataFlavor : flavors) {
            if (!list.contains(dataFlavor)) continue;
            vector.add(dataFlavor);
        }
        this.flavorList = new JList(vector);
        this.flavorList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object.equals(DataFlavor.stringFlavor)) {
                    this.setText("Plain text");
                } else if (object.equals(JEditDataFlavor.jEditRichTextDataFlavor)) {
                    this.setText("jEdit rich text");
                } else if (object.equals(JEditDataFlavor.html)) {
                    this.setText("html");
                }
                return this;
            }
        });
        this.getContentPane().add(new JScrollPane(this.flavorList));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(new EmptyBorder(12, 0, 0, 0));
        jPanel2.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PasteSpecialDialog.this.ok();
            }
        });
        this.getRootPane().setDefaultButton(this.ok);
        jPanel2.add(this.ok);
        jPanel2.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PasteSpecialDialog.this.cancel();
            }
        });
        jPanel2.add(this.cancel);
        jPanel2.add(Box.createGlue());
        jPanel.add("South", jPanel2);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    @Override
    public void ok() {
        DataFlavor dataFlavor = (DataFlavor)this.flavorList.getSelectedValue();
        if (dataFlavor == null) {
            dataFlavor = DataFlavor.stringFlavor;
        }
        Registers.paste(this.textArea, '$', dataFlavor);
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }
}

