/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument;

public abstract class InstrumentationTool {
    private ToolState toolState = ToolState.UNINSTALLED;

    protected InstrumentationTool() {
    }

    public final void install() {
        this.checkUninstalled();
        if (this.internalInstall()) {
            this.toolState = ToolState.ENABLED;
        }
    }

    public final boolean isEnabled() {
        return this.toolState == ToolState.ENABLED;
    }

    public final void setEnabled(boolean isEnabled) {
        this.checkInstalled();
        this.internalSetEnabled(isEnabled);
        this.toolState = isEnabled ? ToolState.ENABLED : ToolState.DISABLED;
    }

    public final void reset() {
        this.checkInstalled();
        this.internalReset();
    }

    public final void dispose() {
        this.checkInstalled();
        this.internalDispose();
        this.toolState = ToolState.DISPOSED;
    }

    protected abstract boolean internalInstall();

    protected void internalSetEnabled(boolean isEnabled) {
    }

    protected abstract void internalReset();

    protected abstract void internalDispose();

    private void checkInstalled() throws IllegalStateException {
        if (this.toolState == ToolState.UNINSTALLED) {
            throw new IllegalStateException("Tool " + this.getClass().getSimpleName() + " not yet installed");
        }
        if (this.toolState == ToolState.DISPOSED) {
            throw new IllegalStateException("Tool " + this.getClass().getSimpleName() + " has been disposed");
        }
    }

    private void checkUninstalled() {
        if (this.toolState != ToolState.UNINSTALLED) {
            throw new IllegalStateException("Tool " + this.getClass().getSimpleName() + " has already been installed");
        }
    }

    private static enum ToolState {
        UNINSTALLED,
        ENABLED,
        DISABLED,
        DISPOSED;

    }
}

