/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RandomAccessWeight;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public final class MatchAllDocsQuery
extends Query {
    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) {
        return new RandomAccessWeight(this){

            @Override
            protected Bits getMatchingDocs(LeafReaderContext context) throws IOException {
                return new Bits.MatchAllBits(context.reader().maxDoc());
            }

            public String toString() {
                return "weight(" + MatchAllDocsQuery.this + ")";
            }
        };
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("*:*");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }
}

