/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import org.apache.lucene.search.Explanation;

public abstract class CombineFunction
extends Enum<CombineFunction> {
    public static final /* enum */ CombineFunction MULT = new CombineFunction(){

        @Override
        public float combine(double queryBoost, double queryScore, double funcScore, double maxBoost) {
            return 1.toFloat(queryBoost * queryScore * Math.min(funcScore, maxBoost));
        }

        @Override
        public String getName() {
            return "multiply";
        }

        @Override
        public Explanation explain(float queryBoost, Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            float score = queryBoost * Math.min(funcExpl.getValue(), maxBoost) * queryExpl.getValue();
            Explanation boostExpl = Explanation.match((float)maxBoost, (String)"maxBoost", (Explanation[])new Explanation[0]);
            Explanation minExpl = Explanation.match((float)Math.min(funcExpl.getValue(), maxBoost), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, boostExpl});
            return Explanation.match((float)score, (String)"function score, product of:", (Explanation[])new Explanation[]{queryExpl, minExpl, Explanation.match((float)queryBoost, (String)"queryBoost", (Explanation[])new Explanation[0])});
        }
    };
    public static final /* enum */ CombineFunction REPLACE = new CombineFunction(){

        @Override
        public float combine(double queryBoost, double queryScore, double funcScore, double maxBoost) {
            return 2.toFloat(queryBoost * Math.min(funcScore, maxBoost));
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public Explanation explain(float queryBoost, Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            float score = queryBoost * Math.min(funcExpl.getValue(), maxBoost);
            Explanation boostExpl = Explanation.match((float)maxBoost, (String)"maxBoost", (Explanation[])new Explanation[0]);
            Explanation minExpl = Explanation.match((float)Math.min(funcExpl.getValue(), maxBoost), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, boostExpl});
            return Explanation.match((float)score, (String)"function score, product of:", (Explanation[])new Explanation[]{minExpl, Explanation.match((float)queryBoost, (String)"queryBoost", (Explanation[])new Explanation[0])});
        }
    };
    public static final /* enum */ CombineFunction SUM = new CombineFunction(){

        @Override
        public float combine(double queryBoost, double queryScore, double funcScore, double maxBoost) {
            return 3.toFloat(queryBoost * (queryScore + Math.min(funcScore, maxBoost)));
        }

        @Override
        public String getName() {
            return "sum";
        }

        @Override
        public Explanation explain(float queryBoost, Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            float score = queryBoost * (Math.min(funcExpl.getValue(), maxBoost) + queryExpl.getValue());
            Explanation minExpl = Explanation.match((float)Math.min(funcExpl.getValue(), maxBoost), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, Explanation.match((float)maxBoost, (String)"maxBoost", (Explanation[])new Explanation[0])});
            Explanation sumExpl = Explanation.match((float)(Math.min(funcExpl.getValue(), maxBoost) + queryExpl.getValue()), (String)"sum of", (Explanation[])new Explanation[]{queryExpl, minExpl});
            return Explanation.match((float)score, (String)"function score, product of:", (Explanation[])new Explanation[]{sumExpl, Explanation.match((float)queryBoost, (String)"queryBoost", (Explanation[])new Explanation[0])});
        }
    };
    public static final /* enum */ CombineFunction AVG = new CombineFunction(){

        @Override
        public float combine(double queryBoost, double queryScore, double funcScore, double maxBoost) {
            return 4.toFloat(queryBoost * (Math.min(funcScore, maxBoost) + queryScore) / 2.0);
        }

        @Override
        public String getName() {
            return "avg";
        }

        @Override
        public Explanation explain(float queryBoost, Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            float score = 4.toFloat((double)(queryBoost * (queryExpl.getValue() + Math.min(funcExpl.getValue(), maxBoost))) / 2.0);
            Explanation minExpl = Explanation.match((float)Math.min(funcExpl.getValue(), maxBoost), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, Explanation.match((float)maxBoost, (String)"maxBoost", (Explanation[])new Explanation[0])});
            Explanation avgExpl = Explanation.match((float)4.toFloat((double)(Math.min(funcExpl.getValue(), maxBoost) + queryExpl.getValue()) / 2.0), (String)"avg of", (Explanation[])new Explanation[]{queryExpl, minExpl});
            return Explanation.match((float)score, (String)"function score, product of:", (Explanation[])new Explanation[]{avgExpl, Explanation.match((float)queryBoost, (String)"queryBoost", (Explanation[])new Explanation[0])});
        }
    };
    public static final /* enum */ CombineFunction MIN = new CombineFunction(){

        @Override
        public float combine(double queryBoost, double queryScore, double funcScore, double maxBoost) {
            return 5.toFloat(queryBoost * Math.min(queryScore, Math.min(funcScore, maxBoost)));
        }

        @Override
        public String getName() {
            return "min";
        }

        @Override
        public Explanation explain(float queryBoost, Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            float score = 5.toFloat(queryBoost * Math.min(queryExpl.getValue(), Math.min(funcExpl.getValue(), maxBoost)));
            Explanation innerMinExpl = Explanation.match((float)Math.min(funcExpl.getValue(), maxBoost), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, Explanation.match((float)maxBoost, (String)"maxBoost", (Explanation[])new Explanation[0])});
            Explanation outerMinExpl = Explanation.match((float)Math.min(Math.min(funcExpl.getValue(), maxBoost), queryExpl.getValue()), (String)"min of", (Explanation[])new Explanation[]{queryExpl, innerMinExpl});
            return Explanation.match((float)score, (String)"function score, product of:", (Explanation[])new Explanation[]{outerMinExpl, Explanation.match((float)queryBoost, (String)"queryBoost", (Explanation[])new Explanation[0])});
        }
    };
    public static final /* enum */ CombineFunction MAX = new CombineFunction(){

        @Override
        public float combine(double queryBoost, double queryScore, double funcScore, double maxBoost) {
            return 6.toFloat(queryBoost * Math.max(queryScore, Math.min(funcScore, maxBoost)));
        }

        @Override
        public String getName() {
            return "max";
        }

        @Override
        public Explanation explain(float queryBoost, Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            float score = 6.toFloat(queryBoost * Math.max(queryExpl.getValue(), Math.min(funcExpl.getValue(), maxBoost)));
            Explanation innerMinExpl = Explanation.match((float)Math.min(funcExpl.getValue(), maxBoost), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, Explanation.match((float)maxBoost, (String)"maxBoost", (Explanation[])new Explanation[0])});
            Explanation outerMaxExpl = Explanation.match((float)Math.max(Math.min(funcExpl.getValue(), maxBoost), queryExpl.getValue()), (String)"max of:", (Explanation[])new Explanation[]{queryExpl, innerMinExpl});
            return Explanation.match((float)score, (String)"function score, product of:", (Explanation[])new Explanation[]{outerMaxExpl, Explanation.match((float)queryBoost, (String)"queryBoost", (Explanation[])new Explanation[0])});
        }
    };
    private static final /* synthetic */ CombineFunction[] $VALUES;

    public static CombineFunction[] values() {
        return (CombineFunction[])$VALUES.clone();
    }

    public static CombineFunction valueOf(String name) {
        return Enum.valueOf(CombineFunction.class, name);
    }

    public abstract float combine(double var1, double var3, double var5, double var7);

    public abstract String getName();

    public static float toFloat(double input) {
        assert (CombineFunction.deviation(input) <= 0.001) : "input " + input + " out of float scope for function score deviation: " + CombineFunction.deviation(input);
        return (float)input;
    }

    private static double deviation(double input) {
        float floatVersion = (float)input;
        return Double.compare(floatVersion, input) == 0 || input == 0.0 ? 0.0 : 1.0 - (double)floatVersion / input;
    }

    public abstract Explanation explain(float var1, Explanation var2, Explanation var3, float var4);

    static {
        $VALUES = new CombineFunction[]{MULT, REPLACE, SUM, AVG, MIN, MAX};
    }
}

