/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import com.carrotsearch.hppc.LongArrayList;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.MergeResult;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;

public abstract class NumberFieldMapper
extends FieldMapper
implements AllFieldMapper.IncludeInAll {
    protected Boolean includeInAll;
    protected Explicit<Boolean> ignoreMalformed;
    protected Explicit<Boolean> coerce;
    protected final boolean useSortedNumericDocValues;

    protected NumberFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
        this.coerce = coerce;
        this.useSortedNumericDocValues = Version.indexCreated(indexSettings).onOrAfter(Version.V_1_4_0_Beta1);
    }

    @Override
    public void includeInAll(Boolean includeInAll) {
        if (includeInAll != null) {
            this.includeInAll = includeInAll;
        }
    }

    @Override
    public void includeInAllIfNotSet(Boolean includeInAll) {
        if (includeInAll != null && this.includeInAll == null) {
            this.includeInAll = includeInAll;
        }
    }

    @Override
    public void unsetIncludeInAll() {
        this.includeInAll = null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        RuntimeException e = null;
        try {
            this.innerParseCreateField(context, fields);
        }
        catch (IllegalArgumentException e1) {
            e = e1;
        }
        catch (MapperParsingException e2) {
            e = e2;
        }
        if (e != null && !this.ignoreMalformed.value().booleanValue()) {
            throw e;
        }
    }

    protected abstract void innerParseCreateField(ParseContext var1, List<Field> var2) throws IOException;

    protected final void addDocValue(ParseContext context, List<Field> fields, long value) {
        if (this.useSortedNumericDocValues) {
            fields.add((Field)new SortedNumericDocValuesField(this.fieldType().names().indexName(), value));
        } else {
            CustomLongNumericDocValuesField field = (CustomLongNumericDocValuesField)context.doc().getByKey(this.fieldType().names().indexName());
            if (field != null) {
                field.add(value);
            } else {
                field = new CustomLongNumericDocValuesField(this.fieldType().names().indexName(), value);
                context.doc().addWithKey(this.fieldType().names().indexName(), field);
            }
        }
    }

    public static double parseDoubleValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof BytesRef) {
            return Double.parseDouble(((BytesRef)value).utf8ToString());
        }
        return Double.parseDouble(value.toString());
    }

    public static long parseLongValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof BytesRef) {
            return Long.parseLong(((BytesRef)value).utf8ToString());
        }
        return Long.parseLong(value.toString());
    }

    @Override
    public void merge(Mapper mergeWith, MergeResult mergeResult) throws MergeMappingException {
        super.merge(mergeWith, mergeResult);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        NumberFieldMapper nfmMergeWith = (NumberFieldMapper)mergeWith;
        if (this.fieldTypeRef.getNumAssociatedMappers() > 1 && !mergeResult.updateAllTypes() && this.fieldType().numericPrecisionStep() != nfmMergeWith.fieldType().numericPrecisionStep()) {
            mergeResult.addConflict("mapper [" + this.fieldType().names().fullName() + "] is used by multiple types. Set update_all_types to true to update precision_step across all types.");
        }
        if (!mergeResult.simulate() && !mergeResult.hasConflicts()) {
            this.includeInAll = nfmMergeWith.includeInAll;
            if (nfmMergeWith.ignoreMalformed.explicit()) {
                this.ignoreMalformed = nfmMergeWith.ignoreMalformed;
            }
            if (nfmMergeWith.coerce.explicit()) {
                this.coerce = nfmMergeWith.coerce;
            }
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", (Object)this.ignoreMalformed.value());
        }
        if (includeDefaults || this.coerce.explicit()) {
            builder.field("coerce", (Object)this.coerce.value());
        }
    }

    public static class CustomLongNumericDocValuesField
    extends CustomNumericDocValuesField {
        private final LongArrayList values = new LongArrayList();

        public CustomLongNumericDocValuesField(String name, long value) {
            super(name);
            this.add(value);
        }

        public void add(long value) {
            this.values.add(value);
        }

        public BytesRef binaryValue() {
            CollectionUtils.sortAndDedup(this.values);
            byte[] bytes = new byte[this.values.size() * 9];
            ByteArrayDataOutput out = new ByteArrayDataOutput(bytes);
            ByteUtils.writeVLong(out, ByteUtils.zigZagEncode(this.values.get(0)));
            for (int i = 1; i < this.values.size(); ++i) {
                long delta = this.values.get(i) - this.values.get(i - 1);
                ByteUtils.writeVLong(out, delta);
            }
            return new BytesRef(bytes, 0, out.getPosition());
        }
    }

    public static abstract class CustomNumericDocValuesField
    implements IndexableField {
        public static final FieldType TYPE = new FieldType();
        private final String name;

        public CustomNumericDocValuesField(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public IndexableFieldType fieldType() {
            return TYPE;
        }

        public float boost() {
            return 1.0f;
        }

        public String stringValue() {
            return null;
        }

        public Reader readerValue() {
            return null;
        }

        public Number numericValue() {
            return null;
        }

        public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) throws IOException {
            return null;
        }

        static {
            TYPE.setDocValuesType(DocValuesType.BINARY);
            TYPE.freeze();
        }
    }

    public static abstract class CustomNumericField
    extends Field {
        private ThreadLocal<NumericTokenStream> tokenStream = new ThreadLocal<NumericTokenStream>(){

            @Override
            protected NumericTokenStream initialValue() {
                return new NumericTokenStream(CustomNumericField.this.fieldType().numericPrecisionStep());
            }
        };
        private static ThreadLocal<NumericTokenStream> tokenStream4 = new ThreadLocal<NumericTokenStream>(){

            @Override
            protected NumericTokenStream initialValue() {
                return new NumericTokenStream(4);
            }
        };
        private static ThreadLocal<NumericTokenStream> tokenStream8 = new ThreadLocal<NumericTokenStream>(){

            @Override
            protected NumericTokenStream initialValue() {
                return new NumericTokenStream(8);
            }
        };
        private static ThreadLocal<NumericTokenStream> tokenStream16 = new ThreadLocal<NumericTokenStream>(){

            @Override
            protected NumericTokenStream initialValue() {
                return new NumericTokenStream(16);
            }
        };
        private static ThreadLocal<NumericTokenStream> tokenStreamMax = new ThreadLocal<NumericTokenStream>(){

            @Override
            protected NumericTokenStream initialValue() {
                return new NumericTokenStream(Integer.MAX_VALUE);
            }
        };

        public CustomNumericField(Number value, MappedFieldType fieldType) {
            super(fieldType.names().indexName(), (FieldType)fieldType);
            if (value != null) {
                this.fieldsData = value;
            }
        }

        protected NumericTokenStream getCachedStream() {
            if (this.fieldType().numericPrecisionStep() == 4) {
                return tokenStream4.get();
            }
            if (this.fieldType().numericPrecisionStep() == 8) {
                return tokenStream8.get();
            }
            if (this.fieldType().numericPrecisionStep() == 16) {
                return tokenStream16.get();
            }
            if (this.fieldType().numericPrecisionStep() == Integer.MAX_VALUE) {
                return tokenStreamMax.get();
            }
            return this.tokenStream.get();
        }

        public String stringValue() {
            return null;
        }

        public Reader readerValue() {
            return null;
        }

        public abstract String numericAsString();
    }

    public static abstract class NumberFieldType
    extends MappedFieldType {
        public NumberFieldType(FieldType.NumericType numericType) {
            this.setTokenized(false);
            this.setOmitNorms(true);
            this.setIndexOptions(IndexOptions.DOCS);
            this.setStoreTermVectors(false);
            this.setNumericType(numericType);
        }

        protected NumberFieldType(NumberFieldType ref) {
            super(ref);
        }

        @Override
        public abstract NumberFieldType clone();

        @Override
        public abstract Object value(Object var1);

        @Override
        public Object valueForSearch(Object value) {
            return this.value(value);
        }

        @Override
        public abstract Query fuzzyQuery(Object var1, Fuzziness var2, int var3, int var4, boolean var5);

        @Override
        public boolean useTermQueryWithQueryString() {
            return true;
        }

        @Override
        public boolean isNumeric() {
            return true;
        }
    }

    public static abstract class Builder<T extends Builder, Y extends NumberFieldMapper>
    extends FieldMapper.Builder<T, Y> {
        private Boolean ignoreMalformed;
        private Boolean coerce;

        public Builder(String name, MappedFieldType fieldType, int defaultPrecisionStep) {
            super(name, fieldType);
            this.fieldType.setNumericPrecisionStep(defaultPrecisionStep);
        }

        public T precisionStep(int precisionStep) {
            this.fieldType.setNumericPrecisionStep(precisionStep);
            return (T)((Builder)this.builder);
        }

        public T ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (T)((Builder)this.builder);
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(context.indexSettings().getAsBoolean("index.mapping.ignore_malformed", Defaults.IGNORE_MALFORMED.value()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public T coerce(boolean coerce) {
            this.coerce = coerce;
            return (T)((Builder)this.builder);
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(context.indexSettings().getAsBoolean("index.mapping.coerce", Defaults.COERCE.value()), false);
            }
            return Defaults.COERCE;
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
            this.fieldType.setOmitNorms(this.fieldType.omitNorms() && this.fieldType.boost() == 1.0f);
            int precisionStep = this.fieldType.numericPrecisionStep();
            if (precisionStep <= 0 || precisionStep >= this.maxPrecisionStep()) {
                this.fieldType.setNumericPrecisionStep(Integer.MAX_VALUE);
            }
            this.fieldType.setIndexAnalyzer(this.makeNumberAnalyzer(this.fieldType.numericPrecisionStep()));
            this.fieldType.setSearchAnalyzer(this.makeNumberAnalyzer(Integer.MAX_VALUE));
        }

        protected abstract NamedAnalyzer makeNumberAnalyzer(int var1);

        protected abstract int maxPrecisionStep();
    }

    public static class Defaults {
        public static final int PRECISION_STEP_8_BIT = Integer.MAX_VALUE;
        public static final int PRECISION_STEP_16_BIT = 8;
        public static final int PRECISION_STEP_32_BIT = 8;
        public static final int PRECISION_STEP_64_BIT = 16;
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
        public static final Explicit<Boolean> COERCE = new Explicit<Boolean>(true, false);
    }
}

