/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import org.apache.lucene.analysis.hunspell.Dictionary;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.cluster.metadata.MetaDataIndexUpgradeService;
import org.elasticsearch.common.geo.ShapesAvailability;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.ExtensionPoint;
import org.elasticsearch.index.query.AndQueryParser;
import org.elasticsearch.index.query.BoolQueryParser;
import org.elasticsearch.index.query.BoostingQueryParser;
import org.elasticsearch.index.query.CommonTermsQueryParser;
import org.elasticsearch.index.query.ConstantScoreQueryParser;
import org.elasticsearch.index.query.DisMaxQueryParser;
import org.elasticsearch.index.query.ExistsQueryParser;
import org.elasticsearch.index.query.FQueryFilterParser;
import org.elasticsearch.index.query.FieldMaskingSpanQueryParser;
import org.elasticsearch.index.query.FilteredQueryParser;
import org.elasticsearch.index.query.FuzzyQueryParser;
import org.elasticsearch.index.query.GeoBoundingBoxQueryParser;
import org.elasticsearch.index.query.GeoDistanceQueryParser;
import org.elasticsearch.index.query.GeoDistanceRangeQueryParser;
import org.elasticsearch.index.query.GeoPolygonQueryParser;
import org.elasticsearch.index.query.GeoShapeQueryParser;
import org.elasticsearch.index.query.GeohashCellQuery;
import org.elasticsearch.index.query.HasChildQueryParser;
import org.elasticsearch.index.query.HasParentQueryParser;
import org.elasticsearch.index.query.IdsQueryParser;
import org.elasticsearch.index.query.IndicesQueryParser;
import org.elasticsearch.index.query.LimitQueryParser;
import org.elasticsearch.index.query.MatchAllQueryParser;
import org.elasticsearch.index.query.MatchQueryParser;
import org.elasticsearch.index.query.MissingQueryParser;
import org.elasticsearch.index.query.MoreLikeThisQueryParser;
import org.elasticsearch.index.query.MultiMatchQueryParser;
import org.elasticsearch.index.query.NestedQueryParser;
import org.elasticsearch.index.query.NotQueryParser;
import org.elasticsearch.index.query.OrQueryParser;
import org.elasticsearch.index.query.PrefixQueryParser;
import org.elasticsearch.index.query.QueryFilterParser;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryStringQueryParser;
import org.elasticsearch.index.query.RangeQueryParser;
import org.elasticsearch.index.query.RegexpQueryParser;
import org.elasticsearch.index.query.ScriptQueryParser;
import org.elasticsearch.index.query.SimpleQueryStringParser;
import org.elasticsearch.index.query.SpanContainingQueryParser;
import org.elasticsearch.index.query.SpanFirstQueryParser;
import org.elasticsearch.index.query.SpanMultiTermQueryParser;
import org.elasticsearch.index.query.SpanNearQueryParser;
import org.elasticsearch.index.query.SpanNotQueryParser;
import org.elasticsearch.index.query.SpanOrQueryParser;
import org.elasticsearch.index.query.SpanTermQueryParser;
import org.elasticsearch.index.query.SpanWithinQueryParser;
import org.elasticsearch.index.query.TemplateQueryParser;
import org.elasticsearch.index.query.TermQueryParser;
import org.elasticsearch.index.query.TermsQueryParser;
import org.elasticsearch.index.query.TypeQueryParser;
import org.elasticsearch.index.query.WildcardQueryParser;
import org.elasticsearch.index.query.WrapperQueryParser;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryParser;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.IndicesWarmer;
import org.elasticsearch.indices.InternalIndicesLifecycle;
import org.elasticsearch.indices.analysis.HunspellService;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;
import org.elasticsearch.indices.cache.query.IndicesQueryCache;
import org.elasticsearch.indices.cache.request.IndicesRequestCache;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCacheListener;
import org.elasticsearch.indices.flush.SyncedFlushService;
import org.elasticsearch.indices.memory.IndexingMemoryController;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoverySource;
import org.elasticsearch.indices.recovery.RecoveryTarget;
import org.elasticsearch.indices.store.IndicesStore;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;
import org.elasticsearch.indices.ttl.IndicesTTLService;

public class IndicesModule
extends AbstractModule {
    private final Settings settings;
    private final ExtensionPoint.ClassSet<QueryParser> queryParsers = new ExtensionPoint.ClassSet<QueryParser>("query_parser", QueryParser.class, (Class<?>[])new Class[0]);
    private final ExtensionPoint.InstanceMap<String, Dictionary> hunspellDictionaries = new ExtensionPoint.InstanceMap<String, Dictionary>("hunspell_dictionary", String.class, Dictionary.class, (Class<?>[])new Class[0]);

    public IndicesModule(Settings settings) {
        this.settings = settings;
        this.registerBuiltinQueryParsers();
    }

    private void registerBuiltinQueryParsers() {
        this.registerQueryParser(MatchQueryParser.class);
        this.registerQueryParser(MultiMatchQueryParser.class);
        this.registerQueryParser(NestedQueryParser.class);
        this.registerQueryParser(HasChildQueryParser.class);
        this.registerQueryParser(HasParentQueryParser.class);
        this.registerQueryParser(DisMaxQueryParser.class);
        this.registerQueryParser(IdsQueryParser.class);
        this.registerQueryParser(MatchAllQueryParser.class);
        this.registerQueryParser(QueryStringQueryParser.class);
        this.registerQueryParser(BoostingQueryParser.class);
        this.registerQueryParser(BoolQueryParser.class);
        this.registerQueryParser(TermQueryParser.class);
        this.registerQueryParser(TermsQueryParser.class);
        this.registerQueryParser(FuzzyQueryParser.class);
        this.registerQueryParser(RegexpQueryParser.class);
        this.registerQueryParser(RangeQueryParser.class);
        this.registerQueryParser(PrefixQueryParser.class);
        this.registerQueryParser(WildcardQueryParser.class);
        this.registerQueryParser(FilteredQueryParser.class);
        this.registerQueryParser(ConstantScoreQueryParser.class);
        this.registerQueryParser(SpanTermQueryParser.class);
        this.registerQueryParser(SpanNotQueryParser.class);
        this.registerQueryParser(SpanWithinQueryParser.class);
        this.registerQueryParser(SpanContainingQueryParser.class);
        this.registerQueryParser(FieldMaskingSpanQueryParser.class);
        this.registerQueryParser(SpanFirstQueryParser.class);
        this.registerQueryParser(SpanNearQueryParser.class);
        this.registerQueryParser(SpanOrQueryParser.class);
        this.registerQueryParser(MoreLikeThisQueryParser.class);
        this.registerQueryParser(WrapperQueryParser.class);
        this.registerQueryParser(IndicesQueryParser.class);
        this.registerQueryParser(CommonTermsQueryParser.class);
        this.registerQueryParser(SpanMultiTermQueryParser.class);
        this.registerQueryParser(FunctionScoreQueryParser.class);
        this.registerQueryParser(SimpleQueryStringParser.class);
        this.registerQueryParser(TemplateQueryParser.class);
        this.registerQueryParser(TypeQueryParser.class);
        this.registerQueryParser(LimitQueryParser.class);
        this.registerQueryParser(ScriptQueryParser.class);
        this.registerQueryParser(GeoDistanceQueryParser.class);
        this.registerQueryParser(GeoDistanceRangeQueryParser.class);
        this.registerQueryParser(GeoBoundingBoxQueryParser.class);
        this.registerQueryParser(GeohashCellQuery.Parser.class);
        this.registerQueryParser(GeoPolygonQueryParser.class);
        this.registerQueryParser(QueryFilterParser.class);
        this.registerQueryParser(FQueryFilterParser.class);
        this.registerQueryParser(AndQueryParser.class);
        this.registerQueryParser(OrQueryParser.class);
        this.registerQueryParser(NotQueryParser.class);
        this.registerQueryParser(ExistsQueryParser.class);
        this.registerQueryParser(MissingQueryParser.class);
        if (ShapesAvailability.JTS_AVAILABLE) {
            this.registerQueryParser(GeoShapeQueryParser.class);
        }
    }

    public void registerQueryParser(Class<? extends QueryParser> queryParser) {
        this.queryParsers.registerExtension(queryParser);
    }

    public void registerHunspellDictionary(String name, Dictionary dictionary) {
        this.hunspellDictionaries.registerExtension(name, dictionary);
    }

    @Override
    protected void configure() {
        this.bindQueryParsersExtension();
        this.bindHunspellExtension();
        this.bind(IndicesLifecycle.class).to(InternalIndicesLifecycle.class).asEagerSingleton();
        this.bind(IndicesService.class).asEagerSingleton();
        this.bind(RecoverySettings.class).asEagerSingleton();
        this.bind(RecoveryTarget.class).asEagerSingleton();
        this.bind(RecoverySource.class).asEagerSingleton();
        this.bind(IndicesStore.class).asEagerSingleton();
        this.bind(IndicesClusterStateService.class).asEagerSingleton();
        this.bind(IndexingMemoryController.class).asEagerSingleton();
        this.bind(SyncedFlushService.class).asEagerSingleton();
        this.bind(IndicesQueryCache.class).asEagerSingleton();
        this.bind(IndicesRequestCache.class).asEagerSingleton();
        this.bind(IndicesFieldDataCache.class).asEagerSingleton();
        this.bind(TransportNodesListShardStoreMetaData.class).asEagerSingleton();
        this.bind(IndicesTTLService.class).asEagerSingleton();
        this.bind(IndicesWarmer.class).asEagerSingleton();
        this.bind(UpdateHelper.class).asEagerSingleton();
        this.bind(MetaDataIndexUpgradeService.class).asEagerSingleton();
        this.bind(IndicesFieldDataCacheListener.class).asEagerSingleton();
    }

    protected void bindQueryParsersExtension() {
        this.queryParsers.bind(this.binder());
        this.bind(IndicesQueriesRegistry.class).asEagerSingleton();
    }

    protected void bindHunspellExtension() {
        this.hunspellDictionaries.bind(this.binder());
        this.bind(HunspellService.class).asEagerSingleton();
        this.bind(IndicesAnalysisService.class).asEagerSingleton();
    }
}

