/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.NativeScriptEngineService;
import org.elasticsearch.script.NativeScriptFactory;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptContextRegistry;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.expression.ExpressionScriptEngineService;
import org.elasticsearch.script.groovy.GroovyScriptEngineService;
import org.elasticsearch.script.mustache.MustacheScriptEngineService;

public class ScriptModule
extends AbstractModule {
    private final Settings settings;
    private final List<Class<? extends ScriptEngineService>> scriptEngines = new ArrayList<Class<? extends ScriptEngineService>>();
    private final Map<String, Class<? extends NativeScriptFactory>> scripts = Maps.newHashMap();
    private final List<ScriptContext.Plugin> customScriptContexts = new ArrayList<ScriptContext.Plugin>();

    public ScriptModule(Settings settings) {
        this.settings = settings;
    }

    public void addScriptEngine(Class<? extends ScriptEngineService> scriptEngine) {
        this.scriptEngines.add(scriptEngine);
    }

    public void registerScript(String name, Class<? extends NativeScriptFactory> script) {
        this.scripts.put(name, script);
    }

    public void registerScriptContext(ScriptContext.Plugin scriptContext) {
        this.customScriptContexts.add(scriptContext);
    }

    @Override
    protected void configure() {
        MapBinder<String, NativeScriptFactory> scriptsBinder = MapBinder.newMapBinder(this.binder(), String.class, NativeScriptFactory.class);
        for (Map.Entry<String, Class<? extends NativeScriptFactory>> entry : this.scripts.entrySet()) {
            scriptsBinder.addBinding(entry.getKey()).to(entry.getValue()).asEagerSingleton();
        }
        Multibinder<ScriptEngineService> multibinder = Multibinder.newSetBinder(this.binder(), ScriptEngineService.class);
        multibinder.addBinding().to(NativeScriptEngineService.class);
        try {
            Class.forName("groovy.lang.GroovyClassLoader");
            multibinder.addBinding().to(GroovyScriptEngineService.class).asEagerSingleton();
        }
        catch (Throwable t) {
            Loggers.getLogger(ScriptService.class, this.settings, new String[0]).debug("failed to load groovy", t, new Object[0]);
        }
        try {
            Class.forName("com.github.mustachejava.Mustache");
            multibinder.addBinding().to(MustacheScriptEngineService.class).asEagerSingleton();
        }
        catch (Throwable t) {
            Loggers.getLogger(ScriptService.class, this.settings, new String[0]).debug("failed to load mustache", t, new Object[0]);
        }
        try {
            Class.forName("org.apache.lucene.expressions.Expression");
            multibinder.addBinding().to(ExpressionScriptEngineService.class).asEagerSingleton();
        }
        catch (Throwable t) {
            Loggers.getLogger(ScriptService.class, this.settings, new String[0]).debug("failed to load lucene expressions", t, new Object[0]);
        }
        for (Class<? extends ScriptEngineService> scriptEngine : this.scriptEngines) {
            multibinder.addBinding().to(scriptEngine).asEagerSingleton();
        }
        this.bind(ScriptContextRegistry.class).toInstance(new ScriptContextRegistry(this.customScriptContexts));
        this.bind(ScriptService.class).asEagerSingleton();
    }
}

