/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import org.apache.commons.lang.ObjectUtils;
import org.gradle.api.Nullable;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.DependencySpecBuilder;

public class DefaultDependencySpec
implements DependencySpec {
    private final String projectPath;
    private final String libraryName;

    public DefaultDependencySpec(String libraryName, String projectPath) {
        if (libraryName == null && projectPath == null) {
            throw new IllegalArgumentException("A dependency spec must have at least one of project or library name not null");
        }
        this.libraryName = libraryName;
        this.projectPath = projectPath;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    @Nullable
    public String getLibraryName() {
        return this.libraryName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDependencySpec that = (DefaultDependencySpec)o;
        return ObjectUtils.equals((Object)this.projectPath, (Object)that.projectPath) && ObjectUtils.equals((Object)this.libraryName, (Object)that.libraryName);
    }

    public int hashCode() {
        int result = this.projectPath != null ? this.projectPath.hashCode() : 0;
        result = 31 * result + (this.libraryName != null ? this.libraryName.hashCode() : 0);
        return result;
    }

    public static class Builder
    implements DependencySpecBuilder {
        private String projectPath;
        private String libraryName;

        public DependencySpecBuilder project(String path) {
            this.projectPath = path;
            return this;
        }

        public DependencySpecBuilder library(String name) {
            this.libraryName = name;
            return this;
        }

        public DependencySpec build() {
            return new DefaultDependencySpec(this.libraryName, this.projectPath);
        }

        @Nullable
        public String getProjectPath() {
            return this.projectPath;
        }

        @Nullable
        public String getLibraryName() {
            return this.libraryName;
        }
    }
}

