/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.output.definitions;

import java.io.File;
import java.util.List;
import org.gradle.foundation.output.FileLink;
import org.gradle.foundation.output.definitions.FileLinkDefinition;
import org.gradle.foundation.output.definitions.PrefixedFileLinkDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionFileLinkDefinition
implements FileLinkDefinition {
    private String expression;
    private String lineNumberDelimiter;
    private String extension;
    private String name;

    public ExtensionFileLinkDefinition(String name, String extension) {
        this(name, extension, null);
    }

    public ExtensionFileLinkDefinition(String name, String extension, String lineNumberDelimiter) {
        this.name = name;
        this.lineNumberDelimiter = lineNumberDelimiter;
        this.extension = extension;
        this.expression = ".*\\" + extension;
        if (lineNumberDelimiter != null) {
            this.expression = this.expression + this.generateLineNumberExpression(lineNumberDelimiter);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected String generateLineNumberExpression(String lineNumberDelimiter) {
        return PrefixedFileLinkDefinition.quoteLiteral(lineNumberDelimiter) + "\\s*\\d*";
    }

    @Override
    public String getSearchExpression() {
        return this.expression;
    }

    @Override
    public int parseFileLink(String fullSearchTest, String matchedText, int start, int end, boolean verifyFileExists, List<FileLink> fileLinks) {
        int extensionIndex = ExtensionFileLinkDefinition.lastIndexOfCaseInsensitive(matchedText, this.extension);
        if (extensionIndex == -1) {
            return -1;
        }
        int prefixIndex = this.getStartOfFile(matchedText);
        int realPathEnd = extensionIndex + this.extension.length();
        String path = matchedText.substring(prefixIndex, realPathEnd).trim();
        File file = new File(path);
        if (verifyFileExists && !file.exists()) {
            return -1;
        }
        String remainder = matchedText.substring(realPathEnd);
        int lineNumber = PrefixedFileLinkDefinition.getLineNumber(remainder, this.lineNumberDelimiter);
        fileLinks.add(new FileLink(file, start + prefixIndex, end, lineNumber, this));
        return end;
    }

    public static int lastIndexOfCaseInsensitive(String sourceText, String alreadyLowerCaseSoughtText) {
        sourceText = sourceText.toLowerCase();
        return sourceText.lastIndexOf(alreadyLowerCaseSoughtText);
    }

    private int getStartOfFile(String matchedText) {
        int index = 0;
        while (Character.isWhitespace(matchedText.charAt(index))) {
            ++index;
        }
        return index;
    }

    public String toString() {
        return "Name: '" + this.name + "'" + " Expression ='" + this.expression + '\'' + " LineNumberDelimter='" + this.lineNumberDelimiter + '\'' + " Extension='" + this.extension + '\'';
    }
}

