/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.internal.component.BuildableJavaComponent;
import org.gradle.api.internal.component.ComponentRegistry;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.reporting.components.ComponentReport;
import org.gradle.api.reporting.model.ModelReport;
import org.gradle.api.tasks.diagnostics.DependencyInsightReportTask;
import org.gradle.api.tasks.diagnostics.DependencyReportTask;
import org.gradle.api.tasks.diagnostics.ProjectReportTask;
import org.gradle.api.tasks.diagnostics.PropertyReportTask;
import org.gradle.api.tasks.diagnostics.TaskReportTask;
import org.gradle.configuration.Help;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.model.Defaults;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class HelpTasksPlugin
implements Plugin<ProjectInternal> {
    public static final String HELP_GROUP = "help";
    public static final String PROPERTIES_TASK = "properties";
    public static final String DEPENDENCIES_TASK = "dependencies";
    public static final String DEPENDENCY_INSIGHT_TASK = "dependencyInsight";
    public static final String COMPONENTS_TASK = "components";
    public static final String MODEL_TASK = "model";

    public void apply(ProjectInternal project) {
        TaskContainerInternal tasks = project.getTasks();
        String projectName = project.toString();
        tasks.addPlaceholderAction(HELP_GROUP, Help.class, (Action)new HelpAction());
        tasks.addPlaceholderAction("projects", ProjectReportTask.class, (Action)new ProjectReportTaskAction(projectName));
        tasks.addPlaceholderAction("tasks", TaskReportTask.class, (Action)new TaskReportTaskAction(projectName, project.getChildProjects().isEmpty()));
        tasks.addPlaceholderAction(PROPERTIES_TASK, PropertyReportTask.class, (Action)new PropertyReportTaskAction(projectName));
        tasks.addPlaceholderAction(DEPENDENCY_INSIGHT_TASK, DependencyInsightReportTask.class, (Action)new DependencyInsightReportTaskAction(projectName));
        tasks.addPlaceholderAction(DEPENDENCIES_TASK, DependencyReportTask.class, (Action)new DependencyReportTaskAction(projectName));
        tasks.addPlaceholderAction(COMPONENTS_TASK, ComponentReport.class, (Action)new ComponentReportAction(projectName));
        tasks.addPlaceholderAction(MODEL_TASK, ModelReport.class, (Action)new ModelReportAction(projectName));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelReportAction
    implements Action<ModelReport> {
        private final String projectName;

        public ModelReportAction(String projectName) {
            this.projectName = projectName;
        }

        public void execute(ModelReport task) {
            task.setDescription("Displays the configuration model of " + this.projectName + ". [incubating]");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComponentReportAction
    implements Action<ComponentReport> {
        private final String projectName;

        public ComponentReportAction(String projectName) {
            this.projectName = projectName;
        }

        public void execute(ComponentReport task) {
            task.setDescription("Displays the components produced by " + this.projectName + ". [incubating]");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DependencyReportTaskAction
    implements Action<DependencyReportTask> {
        private final String projectName;

        public DependencyReportTaskAction(String projectName) {
            this.projectName = projectName;
        }

        public void execute(DependencyReportTask task) {
            task.setDescription("Displays all dependencies declared in " + this.projectName + ".");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DependencyInsightReportTaskAction
    implements Action<DependencyInsightReportTask> {
        private final String projectName;

        public DependencyInsightReportTaskAction(String projectName) {
            this.projectName = projectName;
        }

        public void execute(DependencyInsightReportTask task) {
            task.setDescription("Displays the insight into a specific dependency in " + this.projectName + ".");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyReportTaskAction
    implements Action<PropertyReportTask> {
        private final String projectName;

        public PropertyReportTaskAction(String projectName) {
            this.projectName = projectName;
        }

        public void execute(PropertyReportTask task) {
            task.setDescription("Displays the properties of " + this.projectName + ".");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskReportTaskAction
    implements Action<TaskReportTask> {
        private final String projectName;
        private final boolean noChildren;

        public TaskReportTaskAction(String projectName, boolean noChildren) {
            this.projectName = projectName;
            this.noChildren = noChildren;
        }

        public void execute(TaskReportTask task) {
            String description = this.noChildren ? "Displays the tasks runnable from " + this.projectName + "." : "Displays the tasks runnable from " + this.projectName + " (some of the displayed tasks may belong to subprojects).";
            task.setDescription(description);
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectReportTaskAction
    implements Action<ProjectReportTask> {
        private final String project;

        public ProjectReportTaskAction(String projectName) {
            this.project = projectName;
        }

        public void execute(ProjectReportTask task) {
            task.setDescription("Displays the sub-projects of " + this.project + ".");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HelpAction
    implements Action<Help> {
        private HelpAction() {
        }

        public void execute(Help task) {
            task.setDescription("Displays a help message.");
            task.setGroup(HelpTasksPlugin.HELP_GROUP);
            task.setImpliesSubProjects(true);
        }
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Defaults
        void addDefaultDependenciesReportConfiguration(@Path(value="tasks.dependencyInsight") DependencyInsightReportTask task, final ServiceRegistry services) {
            new DslObject((Object)task).getConventionMapping().map("configuration", (Callable)new Callable<Object>(){

                @Override
                public Object call() {
                    BuildableJavaComponent javaProject = ((ComponentRegistry)services.get(ComponentRegistry.class)).getMainComponent();
                    return javaProject == null ? null : javaProject.getCompileDependencies();
                }
            });
        }
    }
}

