/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.ExtendableContainer;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.Graphic;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.MetaDataUseDef;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.Projection;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.Unit;
import ch.interlis.ili2c.metamodel.View;
import ch.interlis.ili2c.metamodel.Viewable;
import java.beans.PropertyVetoException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractPatternDef
extends ExtendableContainer {
    protected List contents = new ArrayList();
    static /* synthetic */ Class class$0;

    public void addBefore(Object o, Object next) {
        if (((ElementDelegate)this.elements).check(o)) {
            try {
                ((Element)o).setBeanContext(this);
            }
            catch (PropertyVetoException pve) {
                throw new IllegalArgumentException(pve.getLocalizedMessage());
            }
            int idx = this.contents.indexOf(next);
            if (idx > -1) {
                this.contents.add(idx, o);
            } else {
                this.contents.add(o);
            }
        }
    }

    public void addAfter(Object o, Object previous) {
        if (((ElementDelegate)this.elements).check(o)) {
            try {
                ((Element)o).setBeanContext(this);
            }
            catch (PropertyVetoException pve) {
                throw new IllegalArgumentException(pve.getLocalizedMessage());
            }
            int idx = this.contents.indexOf(previous);
            if (idx > -1 && idx + 1 < this.contents.size()) {
                this.contents.add(idx + 1, o);
            } else {
                this.contents.add(o);
            }
        }
    }

    protected Collection createElements() {
        return new ElementDelegate();
    }

    public List getViewables() {
        LinkedList result = new LinkedList();
        HashSet<Element> hiddenViewables = new HashSet<Element>();
        AbstractPatternDef t = this;
        while (t != null) {
            Iterator iter = t.iterator();
            LinkedList<Element> tresult = new LinkedList<Element>();
            while (iter.hasNext()) {
                Element obj = (Element)iter.next();
                if (!(obj instanceof Viewable)) continue;
                if (obj instanceof Table && ((Table)obj).isExtended()) {
                    hiddenViewables.add(((Table)obj).getExtending());
                } else if (obj instanceof AssociationDef && ((AssociationDef)obj).isExtended()) {
                    hiddenViewables.add(((AssociationDef)obj).getExtending());
                }
                if (hiddenViewables.contains(obj)) continue;
                tresult.add(obj);
            }
            tresult.addAll(result);
            result = tresult;
            t = (AbstractPatternDef)t.getRealExtending();
        }
        return result;
    }

    public List getTransferViewables() {
        LinkedList<Viewable> result = new LinkedList<Viewable>();
        Iterator iter = this.getViewables().iterator();
        while (iter.hasNext()) {
            Viewable v = (Viewable)iter.next();
            if (AbstractPatternDef.suppressViewableInTransfer(v)) continue;
            result.add(v);
        }
        return result;
    }

    public static boolean suppressViewableInTransfer(Viewable v) {
        if (v == null) {
            return true;
        }
        if (v.isAbstract()) {
            return true;
        }
        if (v instanceof AssociationDef) {
            AssociationDef assoc = (AssociationDef)v;
            if (assoc.isLightweight()) {
                return true;
            }
            if (assoc.getDerivedFrom() != null) {
                return true;
            }
        }
        if (v instanceof View) {
            Topic topic;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("ch.interlis.ili2c.metamodel.Topic");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((topic = (Topic)v.getContainer(clazz)) != null && !topic.isViewTopic()) {
                return true;
            }
        }
        return v instanceof Table && !((Table)v).isIdentifiable();
    }

    private Element getElement(String name) {
        if (name == null) {
            return null;
        }
        Iterator it = this.contents.iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (!name.equals(e.getName())) continue;
            return e;
        }
        if (this.extending != null) {
            return ((AbstractPatternDef)this.extending).getElement(name);
        }
        return null;
    }

    protected class ElementDelegate
    extends AbstractCollection {
        static /* synthetic */ Class class$0;

        protected ElementDelegate() {
        }

        public Iterator iterator() {
            return AbstractPatternDef.this.contents.iterator();
        }

        public int size() {
            return AbstractPatternDef.this.contents.size();
        }

        public boolean add(Object o) {
            if (this.check(o)) {
                return AbstractPatternDef.this.contents.add(o);
            }
            return false;
        }

        private boolean check(Object o) {
            Element e = (Element)o;
            if (o instanceof MetaDataUseDef) {
                Element conflicting = AbstractPatternDef.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(AbstractPatternDef.formatMessage("err_nonuniqueMetaDataUseDefName", e.getName(), AbstractPatternDef.this.toString()));
                }
                return true;
            }
            if (o instanceof Unit) {
                Element conflicting = AbstractPatternDef.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(AbstractPatternDef.formatMessage("err_duplicateUnitName", e.getName(), AbstractPatternDef.this.toString()));
                }
                return true;
            }
            if (o instanceof Domain) {
                Element conflicting = AbstractPatternDef.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(AbstractPatternDef.formatMessage("err_duplicateDomainName", e.getName(), AbstractPatternDef.this.toString()));
                }
                return true;
            }
            if (o instanceof AssociationDef) {
                AssociationDef toInsert = (AssociationDef)o;
                Element conflicting = AbstractPatternDef.this.getElement(e.getName());
                if (conflicting != null && conflicting != e && !toInsert.isExtended() && !toInsert.isExtending(conflicting)) {
                    throw new Ili2cSemanticException(AbstractPatternDef.formatMessage("err_association_nonunique", e.getName(), AbstractPatternDef.this.toString()));
                }
                return true;
            }
            if (o instanceof Table) {
                Table toInsert = (Table)o;
                Element.checkNameSanity(toInsert.getName(), false);
                Element conflicting = AbstractPatternDef.this.getElement(e.getName());
                if (conflicting != null && conflicting != e && !toInsert.isExtended() && !toInsert.isExtending(conflicting)) {
                    throw new Ili2cSemanticException(AbstractPatternDef.formatMessage("err_table_nonunique", e.getName(), AbstractPatternDef.this.toString()));
                }
                if (!toInsert.isAbstract() && toInsert.isIdentifiable() && AbstractPatternDef.this instanceof Topic && ((Topic)AbstractPatternDef.this).isViewTopic()) {
                    throw new Ili2cSemanticException(AbstractPatternDef.formatMessage("err_topic_addNormalTableInViewTopic", toInsert.toString(), AbstractPatternDef.this.toString()));
                }
                return true;
            }
            if (o instanceof View) {
                Element conflicting = AbstractPatternDef.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(AbstractPatternDef.formatMessage("err_view_nonunique", e.getName(), AbstractPatternDef.this.toString()));
                }
                return true;
            }
            if (o instanceof Function) {
                Model enclosingModel;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("ch.interlis.ili2c.metamodel.Model");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!(enclosingModel = (Model)AbstractPatternDef.this.getContainer(clazz)).isContracted() && !(enclosingModel instanceof PredefinedModel)) {
                    throw new Ili2cSemanticException(AbstractPatternDef.formatMessage("err_model_functionButNoContract", e.toString(), enclosingModel.toString()));
                }
                Element conflicting = AbstractPatternDef.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(AbstractPatternDef.formatMessage("err_function_duplicateName", e.getName(), AbstractPatternDef.this.toString(), conflicting.toString()));
                }
                return true;
            }
            if (o instanceof Projection) {
                Element conflicting = AbstractPatternDef.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(AbstractPatternDef.formatMessage("err_projection_nonunique", e.getName(), AbstractPatternDef.this.toString()));
                }
                return true;
            }
            if (o instanceof Graphic) {
                Element conflicting = AbstractPatternDef.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(AbstractPatternDef.formatMessage("err_graphic_nonunique", e.getName(), AbstractPatternDef.this.toString()));
                }
                return true;
            }
            throw new Ili2cSemanticException(AbstractPatternDef.formatMessage("err_container_cannotContain", AbstractPatternDef.this.toString(), o.toString()));
        }
    }
}

