/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Map;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M34;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.script.SV;

public class Escape {
    public static String escapeColor(int n) {
        return n == 0 ? null : "[x" + Escape.getHexColorFromRGB(n) + "]";
    }

    public static String getHexColorFromRGB(int n) {
        if (n == 0) {
            return null;
        }
        String string = "00" + Integer.toHexString(n >> 16 & 0xFF);
        string = string.substring(string.length() - 2);
        String string2 = "00" + Integer.toHexString(n >> 8 & 0xFF);
        string2 = string2.substring(string2.length() - 2);
        String string3 = "00" + Integer.toHexString(n & 0xFF);
        string3 = string3.substring(string3.length() - 2);
        return string + string2 + string3;
    }

    public static String eP(T3 t3) {
        if (t3 == null) {
            return "null";
        }
        return "{" + t3.x + " " + t3.y + " " + t3.z + "}";
    }

    public static String matrixToScript(Object object) {
        return PT.replaceAllCharacters(object.toString(), "\n\r ", "").replace('\t', ' ');
    }

    public static String eP4(P4 p4) {
        return "{" + p4.x + " " + p4.y + " " + p4.z + " " + p4.w + "}";
    }

    public static String drawQuat(Quat quat, String string, String string2, P3 p3, float f) {
        String string3 = " VECTOR " + Escape.eP(p3) + " ";
        if (f == 0.0f) {
            f = 1.0f;
        }
        return "draw " + string + "x" + string2 + string3 + Escape.eP(quat.getVectorScaled(0, f)) + " color red\n" + "draw " + string + "y" + string2 + string3 + Escape.eP(quat.getVectorScaled(1, f)) + " color green\n" + "draw " + string + "z" + string2 + string3 + Escape.eP(quat.getVectorScaled(2, f)) + " color blue\n";
    }

    public static String e(Object object) {
        if (object == null) {
            return "null";
        }
        if (PT.isNonStringPrimitive(object)) {
            return object.toString();
        }
        if (object instanceof String) {
            return PT.esc((String)object);
        }
        if (object instanceof Lst) {
            return Escape.eV((Lst)object);
        }
        if (object instanceof Map) {
            return Escape.escapeMap((Map)object);
        }
        if (object instanceof BS) {
            return Escape.eBS((BS)object);
        }
        if (object instanceof T3) {
            return Escape.eP((T3)object);
        }
        if (object instanceof P4) {
            return Escape.eP4((P4)object);
        }
        if (AU.isAP(object)) {
            return Escape.eAP((T3[])object);
        }
        if (AU.isAS(object)) {
            return Escape.eAS((String[])object, true);
        }
        if (object instanceof M34) {
            return PT.rep(object.toString(), "\t", ",\t");
        }
        if (object instanceof A4) {
            A4 a4 = (A4)object;
            return "{" + a4.x + " " + a4.y + " " + a4.z + " " + (float)((double)a4.angle * 180.0 / Math.PI) + "}";
        }
        if (object instanceof Quat) {
            return ((Quat)object).toString();
        }
        String string = PT.nonArrayString(object);
        return string == null ? PT.toJSON(null, object) : string;
    }

    public static String eV(Lst<SV> lst) {
        if (lst == null) {
            return PT.esc("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < lst.size(); ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.append(Escape.escapeNice(((SV)lst.get(i)).asString()));
        }
        sB.append("]");
        return sB.toString();
    }

    public static String escapeMap(Map<String, Object> map) {
        SB sB = new SB();
        sB.append("{ ");
        String string = "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string2 = entry.getKey();
            sB.append(string).append(PT.esc(string2)).appendC(':');
            Object object = entry.getValue();
            if (!(object instanceof SV)) {
                object = SV.getVariable(object);
            }
            sB.append(((SV)object).escape());
            string = ",";
        }
        sB.append(" }");
        return sB.toString();
    }

    public static String escapeFloatA(float[] fArray, boolean bl) {
        if (bl) {
            return PT.toJSON(null, fArray);
        }
        SB sB = new SB();
        for (int i = 0; i < fArray.length; ++i) {
            if (i > 0) {
                sB.appendC('\n');
            }
            sB.appendF(fArray[i]);
        }
        return sB.toString();
    }

    public static String escapeFloatAA(float[][] fArray, boolean bl) {
        SB sB = new SB();
        String string = bl ? ";\n" : "\n";
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == null) continue;
            if (i > 0) {
                sB.append(string);
            }
            for (int j = 0; j < fArray[i].length; ++j) {
                sB.appendF(fArray[i][j]).appendC('\t');
            }
        }
        return sB.toString();
    }

    public static String escapeFloatAAA(float[][][] fArray, boolean bl) {
        String string;
        SB sB = new SB();
        String string2 = string = bl ? ";\n" : "\n";
        if (fArray[0] == null || fArray[0][0] == null) {
            return "0 0 0" + string;
        }
        sB.appendI(fArray.length).append(" ").appendI(fArray[0].length).append(" ").appendI(fArray[0][0].length);
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == null) continue;
            sB.append(string);
            for (int j = 0; j < fArray[i].length; ++j) {
                if (fArray[i][j] == null) continue;
                sB.append(string);
                for (int k = 0; k < fArray[i][j].length; ++k) {
                    sB.appendF(fArray[i][j][k]).appendC('\t');
                }
            }
        }
        return sB.toString();
    }

    public static String eAS(String[] stringArray, boolean bl) {
        if (stringArray == null) {
            return PT.esc("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.append(bl ? Escape.escapeNice(stringArray[i]) : PT.esc(stringArray[i]));
        }
        sB.append("]");
        return sB.toString();
    }

    public static String eAI(int[] nArray) {
        if (nArray == null) {
            return PT.esc("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.appendI(nArray[i]);
        }
        return sB.append("]").toString();
    }

    public static String eAD(double[] dArray) {
        if (dArray == null) {
            return PT.esc("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.appendD(dArray[i]);
        }
        return sB.append("]").toString();
    }

    public static String eAF(float[] fArray) {
        if (fArray == null) {
            return PT.esc("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < fArray.length; ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.appendF(fArray[i]);
        }
        return sB.append("]").toString();
    }

    public static String eAP(T3[] t3Array) {
        if (t3Array == null) {
            return PT.esc("");
        }
        SB sB = new SB();
        sB.append("[");
        for (int i = 0; i < t3Array.length; ++i) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.append(Escape.eP(t3Array[i]));
        }
        return sB.append("]").toString();
    }

    private static String escapeNice(String string) {
        if (string == null) {
            return "null";
        }
        float f = PT.parseFloatStrict(string);
        return Float.isNaN(f) ? PT.esc(string) : string;
    }

    public static Object uABsM(String string) {
        if (string.charAt(0) == '{') {
            return Escape.uP(string);
        }
        if ((Escape.isStringArray(string) || string.startsWith("[{") && string.indexOf("[{") == string.lastIndexOf("[{")) && string.indexOf(44) < 0 && string.indexOf(46) < 0 && string.indexOf(45) < 0) {
            return BS.unescape(string);
        }
        if (string.startsWith("[[")) {
            return Escape.unescapeMatrix(string);
        }
        return string;
    }

    public static boolean isStringArray(String string) {
        return string.startsWith("({") && string.lastIndexOf("({") == 0 && string.indexOf("})") == string.length() - 2;
    }

    public static Object uP(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string.replace('\n', ' ').trim();
        if (string2.charAt(0) != '{' || string2.charAt(string2.length() - 1) != '}') {
            return string;
        }
        float[] fArray = new float[5];
        string2 = string2.substring(1, string2.length() - 1);
        int[] nArray = new int[1];
        for (n = 0; n < 5; ++n) {
            fArray[n] = PT.parseFloatNext(string2, nArray);
            if (!Float.isNaN(fArray[n])) continue;
            if (nArray[0] >= string2.length() || string2.charAt(nArray[0]) != ',') break;
            nArray[0] = nArray[0] + 1;
            --n;
        }
        if (n == 3) {
            return P3.new3(fArray[0], fArray[1], fArray[2]);
        }
        if (n == 4) {
            return P4.new4(fArray[0], fArray[1], fArray[2], fArray[3]);
        }
        return string;
    }

    public static Object unescapeMatrix(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string.replace('\n', ' ').trim();
        if (string2.lastIndexOf("[[") != 0 || string2.indexOf("]]") != string2.length() - 2) {
            return string;
        }
        float[] fArray = new float[16];
        string2 = string2.substring(2, string2.length() - 2).replace('[', ' ').replace(']', ' ').replace(',', ' ');
        int[] nArray = new int[1];
        for (n = 0; n < 16; ++n) {
            fArray[n] = PT.parseFloatNext(string2, nArray);
            if (Float.isNaN(fArray[n])) break;
        }
        if (!Float.isNaN(PT.parseFloatNext(string2, nArray))) {
            return string;
        }
        if (n == 9) {
            return M3.newA9(fArray);
        }
        if (n == 16) {
            return M4.newA16(fArray);
        }
        return string;
    }

    public static String eBS(BS bS) {
        return BS.escape(bS, '(', ')');
    }

    public static String eBond(BS bS) {
        return BS.escape(bS, '[', ']');
    }

    public static String toReadable(String string, Object object) {
        SB sB = new SB();
        String string2 = "";
        if (object == null) {
            return "null";
        }
        if (PT.isNonStringPrimitive(object)) {
            return Escape.packageReadable(string, null, object.toString());
        }
        if (object instanceof String) {
            return Escape.packageReadable(string, null, PT.esc((String)object));
        }
        if (object instanceof SV) {
            return Escape.packageReadable(string, null, ((SV)object).escape());
        }
        if (AU.isAS(object)) {
            sB.append("[");
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(PT.esc(((String[])object)[i]));
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "String[" + n + "]", sB);
        }
        if (AU.isAI(object)) {
            sB.append("[");
            int n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).appendI(((int[])object)[i]);
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "int[" + n + "]", sB);
        }
        if (AU.isAF(object)) {
            sB.append("[");
            int n = ((float[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).appendF(((float[])object)[i]);
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "float[" + n + "]", sB);
        }
        if (AU.isAD(object)) {
            sB.append("[");
            int n = ((double[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).appendD(((double[])object)[i]);
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "double[" + n + "]", sB);
        }
        if (AU.isAP(object)) {
            sB.append("[");
            int n = ((T3[])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.eP(((T3[])object)[i]));
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "point3f[" + n + "]", sB);
        }
        if (AU.isASS(object)) {
            sB.append("[");
            int n = ((String[][])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.toReadable(null, ((String[][])object)[i]));
                string2 = ",\n";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "String[" + n + "][]", sB);
        }
        if (AU.isAII(object)) {
            sB.append("[");
            int n = ((int[][])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.toReadable(null, ((int[][])object)[i]));
                string2 = ",";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "int[" + n + "][]", sB);
        }
        if (AU.isAFF(object)) {
            sB.append("[\n");
            int n = ((float[][])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.toReadable(null, ((float[][])object)[i]));
                string2 = ",\n";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "float[][]", sB);
        }
        if (AU.isADD(object)) {
            sB.append("[\n");
            int n = ((double[][])object).length;
            for (int i = 0; i < n; ++i) {
                sB.append(string2).append(Escape.toReadable(null, ((double[][])object)[i]));
                string2 = ",\n";
            }
            sB.append("]");
            return Escape.packageReadableSb(string, "double[][]", sB);
        }
        if (object instanceof Lst) {
            int n = ((Lst)object).size();
            for (int i = 0; i < n; ++i) {
                sB.append(Escape.toReadable(string + "[" + (i + 1) + "]", ((Lst)object).get(i)));
            }
            return Escape.packageReadableSb(string, "List[" + n + "]", sB);
        }
        if (object instanceof M34 || object instanceof T3 || object instanceof P4 || object instanceof A4) {
            sB.append(Escape.e(object));
            return Escape.packageReadableSb(string, null, sB);
        }
        if (object instanceof Map) {
            for (String string3 : ((Map)object).keySet()) {
                sB.append(Escape.toReadable((string == null ? "" : string + ".") + string3, ((Map)object).get(string3)));
            }
            return sB.toString();
        }
        return Escape.packageReadable(string, null, PT.toJSON(null, object));
    }

    private static String packageReadableSb(String string, String string2, SB sB) {
        return Escape.packageReadable(string, string2, sB.toString());
    }

    private static String packageReadable(String string, String string2, String string3) {
        String string4;
        String string5 = string4 = string2 == null ? "" : string2 + "\t";
        if (string == null) {
            return string4 + string3;
        }
        return "\n" + string + "\t" + (string2 == null ? "" : "*" + string2 + "\t") + string3;
    }

    public static String escapeModelFileNumber(int n) {
        return "" + n / 1000000 + "." + n % 1000000;
    }

    public static String encapsulateData(String string, Object object, int n) {
        String string2;
        switch (n) {
            case 1: {
                string2 = Escape.escapeFloatA((float[])object, false) + ";\n";
                break;
            }
            case 2: {
                string2 = Escape.escapeFloatAA((float[][])object, true) + ";\n";
                break;
            }
            case 3: {
                string2 = Escape.escapeFloatAAA((float[][][])object, true) + ";\n";
                break;
            }
            default: {
                string2 = object.toString();
            }
        }
        return "  DATA \"" + string + "\"\n" + string2 + "    END \"" + string + "\";\n";
    }

    public static String unescapeUnicode(String string) {
        int n = string.length();
        SB sB = SB.newN(n);
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) == '\\' && n2 < n) {
                c = string.charAt(n2++);
                switch (c) {
                    case 'u': {
                        char c2;
                        int n3;
                        if (n2 >= n) break;
                        int n4 = 0;
                        int n5 = 4;
                        while (--n5 >= 0 && n2 < n && (n3 = Escape.getHexitValue(c2 = string.charAt(n2))) >= 0) {
                            n4 <<= 4;
                            n4 += n3;
                            ++n2;
                        }
                        c = (char)n4;
                    }
                }
            }
            sB.appendC(c);
        }
        return sB.toString();
    }

    public static int getHexitValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        return -1;
    }

    public static String[] unescapeStringArray(String string) {
        if (string == null || !string.startsWith("[") || !string.endsWith("]")) {
            return null;
        }
        Lst<String> lst = new Lst<String>();
        int[] nArray = new int[]{1};
        while (nArray[0] < string.length()) {
            String string2 = PT.getQuotedStringNext(string, nArray);
            if (string2 == null) {
                return null;
            }
            lst.addLast(PT.rep(string2, "\\\"", "\""));
            while (nArray[0] < string.length() && string.charAt(nArray[0]) != '\"') {
                nArray[0] = nArray[0] + 1;
            }
        }
        return lst.toArray(new String[lst.size()]);
    }

    public static boolean isAV(Object object) {
        return object instanceof SV[];
    }

    public static Object escapeHelical(String string, int n, P3 p3, P3 p32, T3[] t3Array) {
        switch (n) {
            case 134217751: {
                return t3Array == null ? new P3() : t3Array[0];
            }
            case 1073741854: 
            case 1665140738: {
                return t3Array == null ? new V3() : t3Array[n == 1073741854 ? 1 : 2];
            }
            case 0x8000001: {
                return Float.valueOf(t3Array == null ? Float.NaN : t3Array[3].x);
            }
            case 135176: {
                return t3Array == null ? "" : "draw ID \"" + string + "\" VECTOR " + Escape.eP(t3Array[0]) + " " + Escape.eP(t3Array[1]) + " color " + (t3Array[3].x < 0.0f ? "{255.0 200.0 0.0}" : "{255.0 0.0 128.0}");
            }
            case 1745489939: {
                return (t3Array == null ? "" : "measure " + Escape.eP(p3) + Escape.eP(t3Array[0]) + Escape.eP(t3Array[4])) + Escape.eP(p32);
            }
        }
        return t3Array == null ? new T3[]{} : t3Array;
    }
}

