/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.java.BS;
import org.jmol.script.T;
import org.jmol.shape.Mesh;
import org.jmol.shape.Shape;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.StateManager;

public abstract class MeshCollection
extends Shape {
    public int meshCount;
    public Mesh[] meshes = new Mesh[4];
    public Mesh currentMesh;
    public boolean isFixed;
    public int nUnnamed;
    public short colix;
    public boolean explicitID;
    protected String previousMeshID;
    protected Mesh linkedMesh;
    protected int modelIndex;
    protected float displayWithinDistance2;
    protected boolean isDisplayWithinNot;
    protected Lst<P3> displayWithinPoints;
    protected BS bsDisplay;
    public String[] title;
    protected Mesh pickedMesh;
    protected int pickedModel;
    protected int pickedVertex;
    protected T3 pickedPt;
    protected int[] connections;
    protected Map<String, Mesh> htObjects;
    protected int color;
    public static final String PREVIOUS_MESH_ID = "+PREVIOUS_MESH+";

    private Mesh setMesh(String string) {
        this.linkedMesh = null;
        if (string == null || PT.isWild(string)) {
            if (string != null) {
                this.previousMeshID = string;
            }
            this.currentMesh = null;
            return null;
        }
        this.currentMesh = this.getMesh(string);
        if (this.currentMesh == null) {
            this.allocMesh(string, null);
        } else if (string.equals(PREVIOUS_MESH_ID)) {
            this.linkedMesh = this.currentMesh.linkedMesh;
        }
        if (this.currentMesh.thisID == null) {
            if (this.nUnnamed == 0 || this.getMesh(this.myType + this.nUnnamed) != null) {
                ++this.nUnnamed;
            }
            this.currentMesh.thisID = this.myType + this.nUnnamed;
            if (this.htObjects != null) {
                this.htObjects.put(this.currentMesh.thisID.toUpperCase(), this.currentMesh);
            }
        }
        this.previousMeshID = this.currentMesh.thisID;
        return this.currentMesh;
    }

    public void allocMesh(String string, Mesh mesh) {
        int n = this.meshCount++;
        this.meshes = (Mesh[])AU.ensureLength(this.meshes, this.meshCount * 2);
        this.meshes[n] = mesh == null ? new Mesh().mesh1(this.vwr, string, this.colix, n) : mesh;
        this.currentMesh = this.meshes[n];
        this.currentMesh.color = this.color;
        this.currentMesh.index = n;
        if (string != null && this.htObjects != null) {
            this.htObjects.put(string.toUpperCase(), this.currentMesh);
        }
        this.previousMeshID = null;
    }

    public void merge(MeshCollection meshCollection) {
        for (int i = 0; i < meshCollection.meshCount; ++i) {
            if (meshCollection.meshes[i] == null) continue;
            Mesh mesh = meshCollection.meshes[i];
            Mesh mesh2 = this.getMesh(mesh.thisID);
            if (mesh2 == null) {
                this.allocMesh(mesh.thisID, mesh);
                continue;
            }
            this.meshes[mesh2.index] = mesh;
            mesh.index = mesh2.index;
        }
        this.previousMeshID = null;
        this.currentMesh = null;
    }

    @Override
    public void initShape() {
        this.colix = (short)5;
        this.color = -1;
    }

    protected void setPropMC(String string, Object object, BS bS) {
        if ("init" == string) {
            this.title = null;
            return;
        }
        if ("link" == string) {
            if (this.meshCount >= 2 && this.currentMesh != null) {
                this.currentMesh.linkedMesh = this.meshes[this.meshCount - 2];
            }
            return;
        }
        if ("lattice" == string) {
            if (this.currentMesh != null) {
                this.currentMesh.lattice = (P3)object;
            }
            return;
        }
        if ("symops" == string) {
            if (this.currentMesh != null) {
                this.currentMesh.symops = (M4[])object;
                if (this.currentMesh.symops == null) {
                    return;
                }
                int n = this.currentMesh.symops.length;
                this.currentMesh.symopColixes = new short[n];
                int n2 = n;
                while (--n2 >= 0) {
                    this.currentMesh.symopColixes[n2] = C.getColix(this.vwr.cm.ce.getArgbMinMax(n2 + 1, 1.0f, n));
                }
            }
            return;
        }
        if ("variables" == string) {
            if (this.currentMesh != null && this.currentMesh.scriptCommand != null && !this.currentMesh.scriptCommand.startsWith("{")) {
                this.currentMesh.scriptCommand = "{\n" + StateManager.getVariableList((Map)object, 0, false, false) + "\n" + this.currentMesh.scriptCommand;
            }
            return;
        }
        if ("thisID" == string) {
            String string2 = (String)object;
            this.setMesh(string2);
            this.checkExplicit(string2);
            return;
        }
        if ("title" == string) {
            if (object == null) {
                this.title = null;
            } else if (object instanceof String) {
                int n = 1;
                String string3 = (String)object;
                int n3 = string3.length();
                while (--n3 >= 0) {
                    if (string3.charAt(n3) != '|') continue;
                    ++n;
                }
                this.title = new String[n];
                n = 0;
                n3 = -1;
                for (int i = 0; i < string3.length(); ++i) {
                    if (string3.charAt(i) != '|') continue;
                    this.title[n++] = string3.substring(n3 + 1, i);
                    n3 = i;
                }
                this.title[n] = string3.substring(n3 + 1);
            } else {
                this.title = (String[])object;
            }
            return;
        }
        if ("delete" == string) {
            this.deleteMesh();
            return;
        }
        if ("reset" == string) {
            String string4 = (String)object;
            if (this.setMesh(string4) == null) {
                return;
            }
            this.setMesh(string4);
            return;
        }
        if ("color" == string) {
            if (object == null) {
                return;
            }
            this.colix = C.getColixO(object);
            this.color = (Integer)object;
            if (this.currentMesh != null) {
                this.currentMesh.color = this.color;
            }
            this.setTokenProperty(1765808134, false, false);
            return;
        }
        if ("translucency" == string) {
            this.setTokenProperty(603979967, ((String)object).equals("translucent"), false);
            return;
        }
        if ("hidden" == string) {
            object = (Boolean)object != false ? 1073742334 : 1073742335;
            string = "token";
        }
        if ("token" == string) {
            int n = (Integer)object;
            int n4 = 0;
            boolean bl = true;
            switch (n) {
                case 1073741862: 
                case 1073741938: 
                case 1073741958: 
                case 0x40000088: 
                case 1073741964: 
                case 1073742182: 
                case 1073742335: 
                case 1112150019: 
                case 1610625028: {
                    break;
                }
                case 1073742334: {
                    bl = false;
                    n = 1073742335;
                    break;
                }
                case 0x4000004A: {
                    n4 = 1073742018;
                    break;
                }
                case 1073742039: {
                    bl = false;
                    n = 0x4000004A;
                    n4 = 1073742018;
                    break;
                }
                case 1073742018: {
                    n4 = 0x4000004A;
                    break;
                }
                case 0x400000E4: {
                    bl = false;
                    n = 1073742018;
                    n4 = 0x4000004A;
                    break;
                }
                case 1073742042: {
                    bl = false;
                    n = 1112150019;
                    break;
                }
                case 1073742046: {
                    bl = false;
                    n = 1073741938;
                    break;
                }
                case 1073742060: {
                    bl = false;
                    n = 1073742182;
                    break;
                }
                case 1073742058: {
                    bl = false;
                    n = 0x40000088;
                    break;
                }
                default: {
                    Logger.error("PROBLEM IN MESHCOLLECTION: token? " + T.nameOf(n));
                }
            }
            this.setTokenProperty(n, bl, false);
            if (n4 != 0) {
                this.setTokenProperty(n4, bl, true);
            }
            return;
        }
        this.setPropS(string, object, bS);
    }

    protected void checkExplicit(String string) {
        if (this.explicitID) {
            return;
        }
        boolean bl = this.explicitID = string != null && !string.equals(PREVIOUS_MESH_ID);
        if (this.explicitID) {
            this.previousMeshID = string;
        }
    }

    protected void setTokenProperty(int n, boolean bl, boolean bl2) {
        if (this.currentMesh == null) {
            String string = this.explicitID && PT.isWild(this.previousMeshID) ? this.previousMeshID : null;
            Lst<Mesh> lst = this.getMeshList(string, false);
            int n2 = lst.size();
            while (--n2 >= 0) {
                this.setMeshTokenProperty((Mesh)lst.get(n2), n, bl, bl2);
            }
        } else {
            this.setMeshTokenProperty(this.currentMesh, n, bl, bl2);
            if (this.linkedMesh != null) {
                this.setMeshTokenProperty(this.linkedMesh, n, bl, bl2);
            }
        }
    }

    private void setMeshTokenProperty(Mesh mesh, int n, boolean bl, boolean bl2) {
        if (bl2 && (!mesh.havePlanarContours || mesh.drawTriangles == mesh.showContourLines)) {
            return;
        }
        switch (n) {
            case 1610625028: {
                mesh.bsDisplay = this.bsDisplay;
                if (this.bsDisplay == null && this.displayWithinPoints != null) {
                    mesh.setShowWithin(this.displayWithinPoints, this.displayWithinDistance2, this.isDisplayWithinNot);
                }
                return;
            }
            case 1073742335: {
                mesh.visible = bl;
                return;
            }
            case 1765808134: {
                mesh.colix = this.colix;
                return;
            }
            case 603979967: {
                mesh.setTranslucent(bl, this.translucentLevel);
                if (bl && mesh.bsSlabGhost != null) {
                    mesh.resetSlab();
                }
                return;
            }
        }
        mesh.setTokenProperty(n, bl);
    }

    protected boolean getPropDataMC(String string, Object[] objectArray) {
        if (string == "getNames") {
            Map map = (Map)objectArray[0];
            boolean bl = (Boolean)objectArray[1];
            int n = this.meshCount;
            while (--n >= 0) {
                if (this.meshes[n] == null || this.meshes[n].vc == 0) continue;
                map.put((bl ? "$" : "") + this.meshes[n].thisID, T.tokenOr);
            }
            return true;
        }
        if (string == "getVertices") {
            Mesh mesh = this.getMesh((String)objectArray[0]);
            if (mesh == null) {
                return false;
            }
            objectArray[1] = mesh.vs;
            objectArray[2] = mesh.getVisibleVertexBitSet();
            return true;
        }
        if (string == "checkID") {
            String string2 = (String)objectArray[0];
            Lst<Mesh> lst = this.getMeshList(string2, true);
            if (lst.size() == 0) {
                return false;
            }
            objectArray[1] = ((Mesh)lst.get((int)0)).thisID;
            return true;
        }
        if (string == "getCenter") {
            String string3 = (String)objectArray[0];
            int n = (Integer)objectArray[1];
            Mesh mesh = this.getMesh(string3);
            if (mesh == null || mesh.vs == null) {
                return false;
            }
            objectArray[2] = n == Integer.MAX_VALUE ? P3.new3(mesh.index + 1, this.meshCount, mesh.vc) : mesh.vs[mesh.getVertexIndexFromNumber(n)];
            return true;
        }
        return false;
    }

    protected Lst<Mesh> getMeshList(String string, boolean bl) {
        Lst<Mesh> lst = new Lst<Mesh>();
        if (string != null) {
            string = string.length() == 0 ? null : string.toUpperCase();
        }
        boolean bl2 = PT.isWild(string);
        int n = this.meshCount;
        while (--n >= 0) {
            String string2;
            if (string != null && !(string2 = this.meshes[n].thisID.toUpperCase()).equals(string) && (!bl2 || !PT.isMatch(string2, string, true, true))) continue;
            lst.addLast(this.meshes[n]);
            if (!bl) continue;
            break;
        }
        return lst;
    }

    protected Object getPropMC(String string) {
        if (string == "count") {
            int n = 0;
            for (int i = 0; i < this.meshCount; ++i) {
                Mesh mesh = this.meshes[i];
                if (mesh == null || mesh.vc <= 0) continue;
                ++n;
            }
            return n;
        }
        if (string == "ID") {
            return this.currentMesh == null ? null : this.currentMesh.thisID;
        }
        if (string.startsWith("list")) {
            boolean bl;
            this.clean();
            SB sB = new SB();
            int n = 0;
            boolean bl2 = bl = string.length() > 5;
            String string2 = string.equals("list") ? null : (bl ? string.substring(5) : (this.currentMesh == null ? null : this.currentMesh.thisID));
            for (int i = 0; i < this.meshCount; ++i) {
                Object object;
                Mesh mesh = this.meshes[i];
                if (string2 != null && !string2.equalsIgnoreCase(mesh.thisID)) continue;
                sB.appendI(++n).append(" id:" + mesh.thisID).append("; model:" + this.vwr.getModelNumberDotted(mesh.modelIndex)).append("; vertices:" + mesh.vc).append("; polygons:" + mesh.pc).append("; visible:" + mesh.visible);
                float[] fArray = (float[])this.getProperty("dataRange", 0);
                if (fArray != null) {
                    sB.append("; dataRange:").append(Escape.eAF(fArray));
                }
                if (mesh.title != null) {
                    object = "";
                    for (int j = 0; j < mesh.title.length; ++j) {
                        object = (String)object + (j == 0 ? "; title:" : " | ") + mesh.title[j];
                    }
                    if (((String)object).length() > 10000) {
                        object = ((String)object).substring(0, 10000) + "...";
                    }
                    sB.append((String)object);
                }
                sB.appendC('\n');
                if (!bl || (object = this.getProperty("jvxlFileInfo", 0)) == null) continue;
                sB.append((String)object).appendC('\n');
            }
            return sB.toString();
        }
        if (string == "vertices") {
            return this.getVertices(this.currentMesh);
        }
        if (string == "getInfo") {
            return this.currentMesh == null ? null : this.currentMesh.getInfo(false);
        }
        if (string == "getData") {
            return this.currentMesh == null ? null : this.currentMesh.getInfo(true);
        }
        return null;
    }

    private Object getVertices(Mesh mesh) {
        if (mesh == null) {
            return null;
        }
        return mesh.vs;
    }

    protected void clean() {
        int n = this.meshCount;
        while (--n >= 0) {
            if (this.meshes[n] != null && this.meshes[n].vc != 0) continue;
            this.deleteMeshI(n);
        }
    }

    private void deleteMesh() {
        if (this.explicitID && this.currentMesh != null) {
            this.deleteMeshI(this.currentMesh.index);
        } else {
            this.deleteMeshKey(this.explicitID && this.previousMeshID != null && PT.isWild(this.previousMeshID) ? this.previousMeshID : null);
        }
        this.currentMesh = null;
    }

    protected void deleteMeshKey(String string) {
        if (string == null || string.length() == 0) {
            int n = this.meshCount;
            while (--n >= 0) {
                this.meshes[n] = null;
            }
            this.meshCount = 0;
            this.nUnnamed = 0;
            if (this.htObjects != null) {
                this.htObjects.clear();
            }
        } else {
            Lst<Mesh> lst = this.getMeshList(string, false);
            int n = lst.size();
            for (int i = 0; i < n; ++i) {
                this.deleteMeshI(((Mesh)lst.get((int)i)).index);
            }
        }
    }

    public void deleteMeshI(int n) {
        if (this.htObjects != null) {
            this.htObjects.remove(this.meshes[n].thisID.toUpperCase());
        }
        for (int i = n + 1; i < this.meshCount; ++i) {
            this.meshes[--this.meshes[i].index] = this.meshes[i];
        }
        this.meshes[--this.meshCount] = null;
    }

    protected void resetObjects() {
        this.htObjects.clear();
        int n = 0;
        while (n < this.meshCount) {
            Mesh mesh = this.meshes[n];
            mesh.index = n++;
            this.htObjects.put(mesh.thisID.toUpperCase(), mesh);
        }
    }

    public Mesh getMesh(String string) {
        int n = this.getIndexFromName(string);
        return n < 0 ? null : this.meshes[n];
    }

    @Override
    public int getIndexFromName(String string) {
        if (PREVIOUS_MESH_ID.equals(string)) {
            return this.previousMeshID == null ? this.meshCount - 1 : this.getIndexFromName(this.previousMeshID);
        }
        if (PT.isWild(string)) {
            Lst<Mesh> lst = this.getMeshList(string, true);
            return lst.size() == 0 ? -1 : ((Mesh)lst.get((int)0)).index;
        }
        if (this.htObjects != null) {
            Mesh mesh = this.htObjects.get(string.toUpperCase());
            return mesh == null ? -1 : mesh.index;
        }
        int n = this.meshCount;
        while (--n >= 0) {
            if (this.meshes[n] == null || this.meshes[n].vc == 0 || !string.equalsIgnoreCase(this.meshes[n].thisID)) continue;
            return n;
        }
        return -1;
    }

    @Override
    public void setModelVisibilityFlags(BS bS) {
        BS bS2 = this.vwr.slm.bsDeleted;
        int n = this.meshCount;
        while (--n >= 0) {
            Mesh mesh = this.meshes[n];
            mesh.visibilityFlags = mesh.visible && mesh.isValid && (mesh.modelIndex < 0 || bS.get(mesh.modelIndex) && (mesh.atomIndex < 0 || !this.ms.isAtomHidden(mesh.atomIndex) && (bS2 == null || !bS2.get(mesh.atomIndex)))) ? this.vf : 0;
        }
    }

    protected void setStatusPicked(int n, T3 t3, Map<String, Object> map) {
        this.vwr.setStatusAtomPicked(n, "[\"" + this.myType + "\"," + PT.esc(this.pickedMesh.thisID) + "," + this.pickedModel + "," + this.pickedVertex + "," + t3.x + "," + t3.y + "," + t3.z + "," + (this.pickedMesh.title == null ? "\"\"" : PT.esc(this.pickedMesh.title[0])) + "]", map);
    }

    protected Map<String, Object> getPickedPoint(T3 t3, int n) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (t3 != null) {
            hashtable.put("pt", t3);
            hashtable.put("modelIndex", n);
            hashtable.put("model", this.vwr.getModelNumberDotted(n));
            hashtable.put("id", this.pickedMesh.thisID);
            hashtable.put("vertex", this.pickedVertex + 1);
            hashtable.put("type", this.myType);
        }
        return hashtable;
    }
}

