/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.awt.Point;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class TemplatedWMSTileSource
extends TMSTileSource
implements TemplatedTileSource {
    private final Map<String, String> headers = new ConcurrentHashMap<String, String>();
    private final Set<String> serverProjections;
    private EastNorth topLeftCorner;
    private Bounds worldBounds;
    private int[] tileXMax;
    private int[] tileYMax;
    private double[] degreesPerTile;
    private static final Pattern PATTERN_HEADER = Pattern.compile("\\{header\\(([^,]+),([^}]+)\\)\\}");
    private static final Pattern PATTERN_PROJ = Pattern.compile("\\{proj\\}");
    private static final Pattern PATTERN_BBOX = Pattern.compile("\\{bbox\\}");
    private static final Pattern PATTERN_W = Pattern.compile("\\{w\\}");
    private static final Pattern PATTERN_S = Pattern.compile("\\{s\\}");
    private static final Pattern PATTERN_E = Pattern.compile("\\{e\\}");
    private static final Pattern PATTERN_N = Pattern.compile("\\{n\\}");
    private static final Pattern PATTERN_WIDTH = Pattern.compile("\\{width\\}");
    private static final Pattern PATTERN_HEIGHT = Pattern.compile("\\{height\\}");
    private static final Pattern PATTERN_PARAM = Pattern.compile("\\{([^}]+)\\}");
    private static final NumberFormat latLonFormat = new DecimalFormat("###0.0000000", new DecimalFormatSymbols(Locale.US));
    private static final Pattern[] ALL_PATTERNS = new Pattern[]{PATTERN_HEADER, PATTERN_PROJ, PATTERN_BBOX, PATTERN_W, PATTERN_S, PATTERN_E, PATTERN_N, PATTERN_WIDTH, PATTERN_HEIGHT};
    private static final float SCALE_DENOMINATOR_ZOOM_LEVEL_1 = 5.5908224E8f;

    public TemplatedWMSTileSource(ImageryInfo imageryInfo) {
        super(imageryInfo);
        this.serverProjections = new TreeSet<String>(imageryInfo.getServerProjections());
        this.handleTemplate();
        this.initProjection();
        this.tileSize = WMSLayer.PROP_IMAGE_SIZE.get();
    }

    public void initProjection() {
        this.initProjection(Main.getProjection());
    }

    public void initProjection(Projection projection) {
        this.worldBounds = TemplatedWMSTileSource.getWorldBounds();
        EastNorth eastNorth = projection.latlon2eastNorth(this.worldBounds.getMin());
        EastNorth eastNorth2 = projection.latlon2eastNorth(this.worldBounds.getMax());
        this.topLeftCorner = new EastNorth(eastNorth.east(), eastNorth2.north());
        LatLon latLon = new LatLon(this.worldBounds.getMinLat(), this.worldBounds.getMaxLon());
        double d = 0.07168 / projection.getMetersPerUnit();
        this.tileXMax = new int[this.getMaxZoom() + 1];
        this.tileYMax = new int[this.getMaxZoom() + 1];
        this.degreesPerTile = new double[this.getMaxZoom() + 1];
        for (int i = 1; i <= this.getMaxZoom(); ++i) {
            this.degreesPerTile[i] = 5.5908224E8 / Math.pow(2.0, i - 1) * d;
            TileXY tileXY = this.latLonToTileXY(latLon.toCoordinate(), i);
            this.tileXMax[i] = tileXY.getXIndex();
            this.tileYMax[i] = tileXY.getYIndex();
        }
    }

    @Override
    public int getDefaultTileSize() {
        return WMSLayer.PROP_IMAGE_SIZE.get();
    }

    @Override
    public String getTileUrl(int n, int n2, int n3) {
        Object object;
        String string = Main.getProjection().toCode();
        EastNorth eastNorth = this.getTileEastNorth(n2, n3, n);
        EastNorth eastNorth2 = this.getTileEastNorth(n2 + 1, n3 + 1, n);
        double d = eastNorth.getX();
        double d2 = eastNorth.getY();
        double d3 = eastNorth2.getY();
        double d4 = eastNorth2.getX();
        if (!this.serverProjections.contains(string) && this.serverProjections.contains("EPSG:4326") && "EPSG:3857".equals(string)) {
            LatLon latLon = Main.getProjection().eastNorth2latlon(new EastNorth(d, d3));
            object = Main.getProjection().eastNorth2latlon(new EastNorth(d4, d2));
            string = "EPSG:4326";
            d3 = latLon.lat();
            d = latLon.lon();
            d2 = ((LatLon)object).lat();
            d4 = ((LatLon)object).lon();
        }
        if ("EPSG:4326".equals(string) && !this.serverProjections.contains(string) && this.serverProjections.contains("CRS:84")) {
            string = "CRS:84";
        }
        boolean bl = false;
        if (this.baseUrl.toLowerCase(Locale.US).contains("crs=epsg:4326")) {
            bl = true;
        } else if (this.baseUrl.toLowerCase(Locale.US).contains("crs=")) {
            bl = Main.getProjection().switchXY();
        }
        object = bl ? String.format("%s,%s,%s,%s", latLonFormat.format(d3), latLonFormat.format(d), latLonFormat.format(d2), latLonFormat.format(d4)) : String.format("%s,%s,%s,%s", latLonFormat.format(d), latLonFormat.format(d3), latLonFormat.format(d4), latLonFormat.format(d2));
        StringBuffer stringBuffer = new StringBuffer(this.baseUrl.length());
        Matcher matcher = PATTERN_PARAM.matcher(this.baseUrl);
        while (matcher.find()) {
            Object object2;
            switch (matcher.group(1)) {
                case "proj": {
                    object2 = string;
                    break;
                }
                case "bbox": {
                    object2 = object;
                    break;
                }
                case "w": {
                    object2 = latLonFormat.format(d);
                    break;
                }
                case "s": {
                    object2 = latLonFormat.format(d3);
                    break;
                }
                case "e": {
                    object2 = latLonFormat.format(d4);
                    break;
                }
                case "n": {
                    object2 = latLonFormat.format(d2);
                    break;
                }
                case "width": 
                case "height": {
                    object2 = String.valueOf(this.getTileSize());
                    break;
                }
                default: {
                    object2 = '{' + matcher.group(1) + '}';
                }
            }
            matcher.appendReplacement(stringBuffer, (String)object2);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString().replace(" ", "%20");
    }

    @Override
    public String getTileId(int n, int n2, int n3) {
        return this.getTileUrl(n, n2, n3);
    }

    @Override
    public ICoordinate tileXYToLatLon(Tile tile) {
        return this.tileXYToLatLon(tile.getXtile(), tile.getYtile(), tile.getZoom());
    }

    @Override
    public ICoordinate tileXYToLatLon(TileXY tileXY, int n) {
        return this.tileXYToLatLon(tileXY.getXIndex(), tileXY.getYIndex(), n);
    }

    @Override
    public ICoordinate tileXYToLatLon(int n, int n2, int n3) {
        return Main.getProjection().eastNorth2latlon(this.getTileEastNorth(n, n2, n3)).toCoordinate();
    }

    @Override
    public TileXY latLonToTileXY(double d, double d2, int n) {
        Projection projection = Main.getProjection();
        EastNorth eastNorth = projection.latlon2eastNorth(new LatLon(d, d2));
        double d3 = this.getDegreesPerTile(n);
        return new TileXY((eastNorth.east() - this.topLeftCorner.east()) / d3, (this.topLeftCorner.north() - eastNorth.north()) / d3);
    }

    @Override
    public TileXY latLonToTileXY(ICoordinate iCoordinate, int n) {
        return this.latLonToTileXY(iCoordinate.getLat(), iCoordinate.getLon(), n);
    }

    @Override
    public int getTileXMax(int n) {
        return this.tileXMax[n];
    }

    @Override
    public int getTileXMin(int n) {
        return 0;
    }

    @Override
    public int getTileYMax(int n) {
        return this.tileYMax[n];
    }

    @Override
    public int getTileYMin(int n) {
        return 0;
    }

    @Override
    public Point latLonToXY(double d, double d2, int n) {
        double d3 = this.getDegreesPerTile(n) / (double)this.getTileSize();
        EastNorth eastNorth = Main.getProjection().latlon2eastNorth(new LatLon(d, d2));
        return new Point((int)Math.round((eastNorth.east() - this.topLeftCorner.east()) / d3), (int)Math.round((this.topLeftCorner.north() - eastNorth.north()) / d3));
    }

    @Override
    public Point latLonToXY(ICoordinate iCoordinate, int n) {
        return this.latLonToXY(iCoordinate.getLat(), iCoordinate.getLon(), n);
    }

    @Override
    public ICoordinate xyToLatLon(Point point, int n) {
        return this.xyToLatLon(point.x, point.y, n);
    }

    @Override
    public ICoordinate xyToLatLon(int n, int n2, int n3) {
        double d = this.getDegreesPerTile(n3) / (double)this.getTileSize();
        Projection projection = Main.getProjection();
        EastNorth eastNorth = new EastNorth(this.topLeftCorner.east() + (double)n * d, this.topLeftCorner.north() - (double)n2 * d);
        return projection.eastNorth2latlon(eastNorth).toCoordinate();
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static void checkUrl(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "url");
        Matcher matcher = PATTERN_PARAM.matcher(string);
        while (matcher.find()) {
            boolean bl = false;
            for (Pattern pattern : ALL_PATTERNS) {
                if (!pattern.matcher(matcher.group()).matches()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new IllegalArgumentException(I18n.tr("{0} is not a valid WMS argument. Please check this server URL:\n{1}", matcher.group(), string));
        }
    }

    private void handleTemplate() {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = PATTERN_HEADER.matcher(this.baseUrl);
        while (matcher.find()) {
            this.headers.put(matcher.group(1), matcher.group(2));
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        this.baseUrl = stringBuffer.toString();
    }

    protected EastNorth getTileEastNorth(int n, int n2, int n3) {
        double d = this.getDegreesPerTile(n3);
        return new EastNorth(this.topLeftCorner.east() + (double)n * d, this.topLeftCorner.north() - (double)n2 * d);
    }

    private double getDegreesPerTile(int n) {
        return this.degreesPerTile[n];
    }

    private static Bounds getWorldBounds() {
        Projection projection = Main.getProjection();
        Bounds bounds = projection.getWorldBoundsLatLon();
        EastNorth eastNorth = projection.latlon2eastNorth(bounds.getMin());
        EastNorth eastNorth2 = projection.latlon2eastNorth(bounds.getMax());
        if (Math.abs(eastNorth.getX() - eastNorth2.getX()) < 1.0 && bounds.equals(new Bounds(new LatLon(-90.0, -180.0), new LatLon(90.0, 180.0)))) {
            return new Bounds(new LatLon(-85.05112877980659, bounds.getMinLon()), new LatLon(85.05112877980659, bounds.getMaxLon()));
        }
        return bounds;
    }
}

