/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public final class User {
    private static long uidCounter;
    private static Map<Long, User> userMap;
    private static final User anonymous;
    private static User lastUser;
    private final Set<String> names = new HashSet<String>();
    private final long uid;

    private static long getNextLocalUid() {
        return --uidCounter;
    }

    public static synchronized User createLocalUser(String string) {
        for (long i = -1L; i >= uidCounter; --i) {
            User user = User.getById(i);
            if (user == null || !user.hasName(string)) continue;
            return user;
        }
        User user = new User(User.getNextLocalUid(), string);
        userMap.put(user.getId(), user);
        return user;
    }

    public static synchronized User createOsmUser(long l, String string) {
        if (lastUser != null && lastUser.getId() == l) {
            return lastUser;
        }
        Long l2 = l;
        User user = userMap.get(l2);
        if (user == null) {
            user = new User(l, string);
            userMap.put(l2, user);
        }
        if (string != null) {
            user.addName(string);
        }
        lastUser = user;
        return user;
    }

    public static synchronized void clearUserMap() {
        userMap.clear();
    }

    public static synchronized User getById(long l) {
        return userMap.get(l);
    }

    public static synchronized List<User> getByName(String string) {
        if (string == null) {
            string = "";
        }
        ArrayList<User> arrayList = new ArrayList<User>();
        for (User user : userMap.values()) {
            if (!user.hasName(string)) continue;
            arrayList.add(user);
        }
        return arrayList;
    }

    public static User getAnonymous() {
        return anonymous;
    }

    public String getName() {
        return Utils.join("/", this.names);
    }

    public List<String> getNames() {
        return new ArrayList<String>(this.names);
    }

    public void addName(String string) {
        this.names.add(string);
    }

    public boolean hasName(String string) {
        return this.names.contains(string);
    }

    public long getId() {
        return this.uid;
    }

    private User(long l, String string) {
        this.uid = l;
        if (string != null) {
            this.addName(string);
        }
    }

    public boolean isOsmUser() {
        return this.uid > 0L;
    }

    public boolean isLocalUser() {
        return this.uid < 0L;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.getName().hashCode();
        n = 31 * n + (int)(this.uid ^ this.uid >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof User)) {
            return false;
        }
        User user = (User)object;
        return this.uid == user.uid;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id:").append(this.uid);
        if (this.names.size() == 1) {
            stringBuilder.append(" name:").append(this.getName());
        } else if (this.names.size() > 1) {
            stringBuilder.append(String.format(" %d names:%s", this.names.size(), this.getName()));
        }
        return stringBuilder.toString();
    }

    static {
        userMap = new HashMap<Long, User>();
        anonymous = User.createLocalUser(I18n.tr("<anonymous>", new Object[0]));
    }
}

