/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Iterator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.data.osm.visitor.paint.AbstractMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.LineClip;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.NavigatableComponent;

public class WireframeMapRenderer
extends AbstractMapRenderer
implements Visitor {
    protected Color dfltWayColor;
    protected Color relationColor;
    protected Color untaggedWayColor;
    protected Color taggedColor;
    protected Color connectionColor;
    protected Color taggedConnectionColor;
    protected boolean showDirectionArrow;
    protected boolean showOnewayArrow;
    protected boolean showHeadArrowOnly;
    protected boolean showOrderNumber;
    protected boolean fillSelectedNode;
    protected boolean fillUnselectedNode;
    protected boolean fillTaggedNode;
    protected boolean fillConnectionNode;
    protected int selectedNodeSize;
    protected int unselectedNodeSize;
    protected int connectionNodeSize;
    protected int taggedNodeSize;
    protected Color currentColor;
    protected GeneralPath currentPath = new GeneralPath();
    private DataSet ds;
    private static final double PHI = Math.toRadians(20.0);
    private static final double cosPHI = Math.cos(PHI);
    private static final double sinPHI = Math.sin(PHI);
    private Stroke relatedWayStroke = new BasicStroke(4.0f, 2, 2);

    public WireframeMapRenderer(Graphics2D graphics2D, NavigatableComponent navigatableComponent, boolean bl) {
        super(graphics2D, navigatableComponent, bl);
    }

    @Override
    public void getColors() {
        super.getColors();
        this.dfltWayColor = PaintColors.DEFAULT_WAY.get();
        this.relationColor = PaintColors.RELATION.get();
        this.untaggedWayColor = PaintColors.UNTAGGED_WAY.get();
        this.highlightColor = PaintColors.HIGHLIGHT_WIREFRAME.get();
        this.taggedColor = PaintColors.TAGGED.get();
        this.connectionColor = PaintColors.CONNECTION.get();
        this.taggedConnectionColor = this.taggedColor != this.nodeColor ? this.taggedColor : this.connectionColor;
    }

    @Override
    protected void getSettings(boolean bl) {
        super.getSettings(bl);
        MapPaintSettings mapPaintSettings = MapPaintSettings.INSTANCE;
        this.showDirectionArrow = mapPaintSettings.isShowDirectionArrow();
        this.showOnewayArrow = mapPaintSettings.isShowOnewayArrow();
        this.showHeadArrowOnly = mapPaintSettings.isShowHeadArrowOnly();
        this.showOrderNumber = mapPaintSettings.isShowOrderNumber();
        this.selectedNodeSize = mapPaintSettings.getSelectedNodeSize();
        this.unselectedNodeSize = mapPaintSettings.getUnselectedNodeSize();
        this.connectionNodeSize = mapPaintSettings.getConnectionNodeSize();
        this.taggedNodeSize = mapPaintSettings.getTaggedNodeSize();
        this.fillSelectedNode = mapPaintSettings.isFillSelectedNode();
        this.fillUnselectedNode = mapPaintSettings.isFillUnselectedNode();
        this.fillConnectionNode = mapPaintSettings.isFillConnectionNode();
        this.fillTaggedNode = mapPaintSettings.isFillTaggedNode();
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.pref.getBoolean("mappaint.wireframe.use-antialiasing", false) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public void render(DataSet dataSet, boolean bl, Bounds bounds) {
        BBox bBox = bounds.toBBox();
        this.ds = dataSet;
        this.getSettings(bl);
        for (Relation object22 : dataSet.searchRelations(bBox)) {
            if (!object22.isDrawable() || this.ds.isSelected(object22) || object22.isDisabledAndHidden()) continue;
            object22.accept(this);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        for (Way way : dataSet.searchWays(bBox)) {
            if (!way.isDrawable() || this.ds.isSelected(way) || way.isDisabledAndHidden()) continue;
            if (way.isHighlighted()) {
                arrayList.add(way);
                continue;
            }
            if (!way.isTagged()) {
                arrayList2.add(way);
                continue;
            }
            way.accept(this);
        }
        this.displaySegments();
        ArrayList arrayList3 = new ArrayList(arrayList2);
        arrayList3.addAll(arrayList);
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            Way way = (Way)iterator.next();
            way.accept(this);
        }
        arrayList3.clear();
        this.displaySegments();
        for (OsmPrimitive osmPrimitive : dataSet.getSelected()) {
            if (!osmPrimitive.isDrawable()) continue;
            osmPrimitive.accept(this);
        }
        this.displaySegments();
        for (OsmPrimitive osmPrimitive : dataSet.searchNodes(bBox)) {
            if (!osmPrimitive.isDrawable() || this.ds.isSelected(osmPrimitive) || osmPrimitive.isDisabledAndHidden()) continue;
            osmPrimitive.accept(this);
        }
        this.drawVirtualNodes(dataSet, bBox);
        for (WaySegment waySegment : dataSet.getHighlightedWaySegments()) {
            this.drawSegment(this.nc.getPoint(waySegment.getFirstNode()), this.nc.getPoint(waySegment.getSecondNode()), this.highlightColor, false);
        }
        this.displaySegments();
    }

    private static int max(int n, int n2, int n3, int n4) {
        return Math.max(Math.max(n, n2), Math.max(n3, n4));
    }

    @Override
    public void visit(Node node) {
        if (node.isIncomplete()) {
            return;
        }
        if (node.isHighlighted()) {
            this.drawNode(node, this.highlightColor, this.selectedNodeSize, this.fillSelectedNode);
        } else {
            Color color = this.isInactiveMode || node.isDisabled() ? this.inactiveColor : (node.isSelected() ? this.selectedColor : (node.isMemberOfSelected() ? this.relationSelectedColor : (node.isConnectionNode() ? (WireframeMapRenderer.isNodeTagged(node) ? this.taggedConnectionColor : this.connectionColor) : (WireframeMapRenderer.isNodeTagged(node) ? this.taggedColor : this.nodeColor))));
            int n = WireframeMapRenderer.max(this.ds.isSelected(node) ? this.selectedNodeSize : 0, WireframeMapRenderer.isNodeTagged(node) ? this.taggedNodeSize : 0, node.isConnectionNode() ? this.connectionNodeSize : 0, this.unselectedNodeSize);
            boolean bl = this.ds.isSelected(node) && this.fillSelectedNode || WireframeMapRenderer.isNodeTagged(node) && this.fillTaggedNode || node.isConnectionNode() && this.fillConnectionNode || this.fillUnselectedNode;
            this.drawNode(node, color, n, bl);
        }
    }

    private static boolean isNodeTagged(Node node) {
        return node.isTagged() || node.isAnnotated();
    }

    @Override
    public void visit(Way way) {
        boolean bl;
        if (way.isIncomplete() || way.getNodesCount() < 2) {
            return;
        }
        boolean bl2 = this.ds.isSelected(way) || this.showDirectionArrow;
        boolean bl3 = bl = bl2 && !this.ds.isSelected(way) && this.showHeadArrowOnly;
        Color color = this.isInactiveMode || way.isDisabled() ? this.inactiveColor : (way.isHighlighted() ? this.highlightColor : (way.isSelected() ? this.selectedColor : (way.isMemberOfSelected() ? this.relationSelectedColor : (!way.isTagged() ? this.untaggedWayColor : this.dfltWayColor))));
        Iterator<Node> iterator = way.getNodes().iterator();
        if (iterator.hasNext()) {
            Point point = this.nc.getPoint(iterator.next());
            int n = 1;
            while (iterator.hasNext()) {
                Point point2 = this.nc.getPoint(iterator.next());
                this.drawSegment(point, point2, color, bl ? !iterator.hasNext() : bl2);
                if (this.showOrderNumber && !this.isInactiveMode) {
                    this.drawOrderNumber(point, point2, n, this.g.getColor());
                }
                point = point2;
                ++n;
            }
        }
    }

    @Override
    public void visit(Relation relation) {
        if (relation.isIncomplete()) {
            return;
        }
        Color color = this.isInactiveMode || relation.isDisabled() ? this.inactiveColor : (relation.isSelected() ? this.selectedColor : (relation.isMultipolygon() && relation.isMemberOfSelected() ? this.relationSelectedColor : this.relationColor));
        this.g.setColor(color);
        for (RelationMember relationMember : relation.getMembers()) {
            Cloneable cloneable;
            if (relationMember.getMember().isIncomplete() || !relationMember.getMember().isDrawable()) continue;
            if (relationMember.isNode()) {
                cloneable = this.nc.getPoint(relationMember.getNode());
                if (((Point)cloneable).x < 0 || ((Point)cloneable).y < 0 || ((Point)cloneable).x > this.nc.getWidth() || ((Point)cloneable).y > this.nc.getHeight()) continue;
                this.g.drawOval(((Point)cloneable).x - 4, ((Point)cloneable).y - 4, 9, 9);
                continue;
            }
            if (!relationMember.isWay()) continue;
            cloneable = new GeneralPath();
            boolean bl = true;
            for (Node node : relationMember.getWay().getNodes()) {
                if (!node.isDrawable()) continue;
                Point point = this.nc.getPoint(node);
                if (bl) {
                    ((Path2D.Float)cloneable).moveTo(point.x, point.y);
                    bl = false;
                    continue;
                }
                ((Path2D.Float)cloneable).lineTo(point.x, point.y);
            }
            this.g.draw(this.relatedWayStroke.createStrokedShape((Shape)((Object)cloneable)));
        }
    }

    @Override
    public void visit(Changeset changeset) {
    }

    @Override
    public void drawNode(Node node, Color color, int n, boolean bl) {
        if (n > 1) {
            int n2 = n / 2;
            Point point = this.nc.getPoint(node);
            if (point.x < 0 || point.y < 0 || point.x > this.nc.getWidth() || point.y > this.nc.getHeight()) {
                return;
            }
            this.g.setColor(color);
            if (bl) {
                this.g.fillRect(point.x - n2, point.y - n2, n, n);
                this.g.drawRect(point.x - n2, point.y - n2, n, n);
            } else {
                this.g.drawRect(point.x - n2, point.y - n2, n, n);
            }
        }
    }

    protected void drawSegment(GeneralPath generalPath, Point point, Point point2, boolean bl) {
        Rectangle rectangle = this.g.getClipBounds();
        rectangle.grow(100, 100);
        LineClip lineClip = new LineClip(point, point2, rectangle);
        if (lineClip.execute()) {
            point = lineClip.getP1();
            point2 = lineClip.getP2();
            generalPath.moveTo(point.x, point.y);
            generalPath.lineTo(point2.x, point2.y);
            if (bl) {
                double d = 10.0 / point.distance(point2);
                double d2 = d * (double)(point.x - point2.x);
                double d3 = d * (double)(point.y - point2.y);
                generalPath.lineTo(point2.x + (int)Math.round(cosPHI * d2 - sinPHI * d3), point2.y + (int)Math.round(sinPHI * d2 + cosPHI * d3));
                generalPath.moveTo(point2.x + (int)Math.round(cosPHI * d2 + sinPHI * d3), point2.y + (int)Math.round(-sinPHI * d2 + cosPHI * d3));
                generalPath.lineTo(point2.x, point2.y);
            }
        }
    }

    protected void drawSegment(Point point, Point point2, Color color, boolean bl) {
        if (color != this.currentColor) {
            this.displaySegments(color);
        }
        this.drawSegment(this.currentPath, point, point2, bl);
    }

    protected void displaySegments() {
        this.displaySegments(null);
    }

    protected void displaySegments(Color color) {
        if (this.currentPath != null) {
            this.g.setColor(this.currentColor);
            this.g.draw(this.currentPath);
            this.currentPath = new GeneralPath();
            this.currentColor = color;
        }
    }
}

