/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.bbox.BBoxChooser;
import org.openstreetmap.josm.gui.bbox.SlippyMapBBoxChooser;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.I18n;

public class SlippyMapChooser
extends JPanel
implements DownloadSelection,
PropertyChangeListener {
    private DownloadDialog iGui;
    private final SlippyMapBBoxChooser pnlSlippyMapBBoxChooser = new SlippyMapBBoxChooser();
    private Dimension iDownloadDialogDimension;

    public SlippyMapChooser() {
        this.pnlSlippyMapBBoxChooser.addPropertyChangeListener(this);
    }

    @Override
    public void addGui(DownloadDialog downloadDialog) {
        this.iGui = downloadDialog;
        this.iGui.addDownloadAreaSelector(this.pnlSlippyMapBBoxChooser, I18n.tr("Slippy map", new Object[0]));
    }

    @Override
    public void setDownloadArea(Bounds bounds) {
        this.pnlSlippyMapBBoxChooser.setBoundingBox(bounds);
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(BBoxChooser.BBOX_PROP)) {
            if (this.iGui != null) {
                this.iGui.boundingBoxChanged((Bounds)propertyChangeEvent.getNewValue(), this);
            }
        } else if (propertyChangeEvent.getPropertyName().equals(SlippyMapBBoxChooser.RESIZE_PROP)) {
            int n;
            int n2;
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            if (this.iDownloadDialogDimension == null) {
                n2 = dimension.width * 90 / 100;
                n = dimension.height * 90 / 100;
                this.iDownloadDialogDimension = this.iGui.getSize();
            } else {
                n2 = this.iDownloadDialogDimension.width;
                n = this.iDownloadDialogDimension.height;
                this.iDownloadDialogDimension = null;
            }
            this.iGui.setBounds((dimension.width - n2) / 2, (dimension.height - n) / 2, n2, n);
            this.repaint();
        }
    }

    public final void refreshTileSources() {
        if (this.pnlSlippyMapBBoxChooser != null) {
            this.pnlSlippyMapBBoxChooser.refreshTileSources();
        }
    }

    public final ActionMap getNavigationComponentActionMap() {
        return this.pnlSlippyMapBBoxChooser.getActionMap();
    }
}

