/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierListener;
import org.openstreetmap.josm.tools.I18n;

public class AdvancedKeyPressDetector
implements AWTEventListener {
    private final Set<Integer> set = new TreeSet<Integer>();
    private KeyEvent releaseEvent;
    private Timer timer;
    private final List<KeyPressReleaseListener> keyListeners = new CopyOnWriteArrayList<KeyPressReleaseListener>();
    private final List<ModifierListener> modifierListeners = new CopyOnWriteArrayList<ModifierListener>();
    private int previousModifiers;
    private boolean enabled = true;

    public void addKeyListener(KeyPressReleaseListener keyPressReleaseListener) {
        this.keyListeners.add(keyPressReleaseListener);
    }

    public void addModifierListener(ModifierListener modifierListener) {
        this.modifierListeners.add(modifierListener);
    }

    public void removeKeyListener(KeyPressReleaseListener keyPressReleaseListener) {
        this.keyListeners.remove(keyPressReleaseListener);
    }

    public void removeModifierListener(ModifierListener modifierListener) {
        this.modifierListeners.remove(modifierListener);
    }

    public void register() {
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            Main.warn(securityException);
        }
        this.timer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedKeyPressDetector.this.timer.stop();
                if (AdvancedKeyPressDetector.this.set.remove(AdvancedKeyPressDetector.this.releaseEvent.getKeyCode()) && AdvancedKeyPressDetector.this.enabled && AdvancedKeyPressDetector.isFocusInMainWindow()) {
                    for (KeyPressReleaseListener keyPressReleaseListener : AdvancedKeyPressDetector.this.keyListeners) {
                        keyPressReleaseListener.doKeyReleased(AdvancedKeyPressDetector.this.releaseEvent);
                    }
                }
            }
        });
    }

    public void unregister() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.set.clear();
        if (!this.keyListeners.isEmpty()) {
            Main.warn(I18n.tr("Some of the key listeners forgot to remove themselves: {0}", new Object[0]), this.keyListeners.toString());
        }
        if (!this.modifierListeners.isEmpty()) {
            Main.warn(I18n.tr("Some of the key modifier listeners forgot to remove themselves: {0}", new Object[0]), this.modifierListeners.toString());
        }
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            Main.warn(securityException);
        }
    }

    private void processKeyEvent(KeyEvent keyEvent) {
        if (Main.isDebugEnabled()) {
            Main.debug("AdvancedKeyPressDetector enabled=" + this.enabled + " => processKeyEvent(" + keyEvent + ") from " + new Exception().getStackTrace()[2]);
        }
        if (keyEvent.getID() == 401) {
            if (this.timer.isRunning()) {
                this.timer.stop();
            } else if (this.set.add(keyEvent.getKeyCode()) && this.enabled && AdvancedKeyPressDetector.isFocusInMainWindow()) {
                for (KeyPressReleaseListener keyPressReleaseListener : this.keyListeners) {
                    if (Main.isDebugEnabled()) {
                        Main.debug(keyPressReleaseListener + " => doKeyPressed(" + keyEvent + ')');
                    }
                    keyPressReleaseListener.doKeyPressed(keyEvent);
                }
            }
        } else if (keyEvent.getID() == 402) {
            if (this.timer.isRunning()) {
                this.timer.stop();
                if (this.set.remove(keyEvent.getKeyCode()) && this.enabled && AdvancedKeyPressDetector.isFocusInMainWindow()) {
                    for (KeyPressReleaseListener keyPressReleaseListener : this.keyListeners) {
                        if (Main.isDebugEnabled()) {
                            Main.debug(keyPressReleaseListener + " => doKeyReleased(" + keyEvent + ')');
                        }
                        keyPressReleaseListener.doKeyReleased(keyEvent);
                    }
                }
            } else {
                this.releaseEvent = keyEvent;
                this.timer.restart();
            }
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof KeyEvent)) {
            return;
        }
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        int n = keyEvent.getModifiers();
        if (this.previousModifiers != n) {
            this.previousModifiers = n;
            for (ModifierListener modifierListener : this.modifierListeners) {
                modifierListener.modifiersChanged(n);
            }
        }
        this.processKeyEvent(keyEvent);
    }

    public boolean isKeyPressed(int n) {
        return this.set.contains(n);
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
        if (Main.isDebugEnabled()) {
            Main.debug("AdvancedKeyPressDetector enabled=" + bl + " from " + new Exception().getStackTrace()[1]);
        }
    }

    private static boolean isFocusInMainWindow() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return component != null && SwingUtilities.getWindowAncestor(component) instanceof JFrame;
    }
}

