/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.GpsDirectory;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.date.PrimaryDateParser;

public final class ExifReader {
    private ExifReader() {
    }

    public static Date readTime(File file) throws ParseException {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(file);
            String string = null;
            block3: for (Directory directory : metadata.getDirectories()) {
                for (Tag tag : directory.getTags()) {
                    if (tag.getTagType() == 36867 && !tag.getDescription().matches("\\[[0-9]+ .+\\]")) {
                        string = tag.getDescription();
                        break block3;
                    }
                    if (tag.getTagType() != 306 && tag.getTagType() != 36868) continue;
                    string = tag.getDescription();
                }
            }
            if (string != null) {
                string = string.replace('/', ':');
                return new PrimaryDateParser().parse(string);
            }
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            Main.error(exception);
        }
        return null;
    }

    public static Integer readOrientation(File file) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(file);
            ExifIFD0Directory exifIFD0Directory = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
            return exifIFD0Directory.getInt(274);
        }
        catch (JpegProcessingException | MetadataException | IOException exception) {
            Main.error(exception);
            return null;
        }
    }

    public static LatLon readLatLon(File file) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(file);
            GpsDirectory gpsDirectory = metadata.getFirstDirectoryOfType(GpsDirectory.class);
            return ExifReader.readLatLon(gpsDirectory);
        }
        catch (JpegProcessingException jpegProcessingException) {
            Main.error(jpegProcessingException);
        }
        catch (IOException iOException) {
            Main.error(iOException);
        }
        catch (MetadataException metadataException) {
            Main.error(metadataException);
        }
        return null;
    }

    public static LatLon readLatLon(GpsDirectory gpsDirectory) throws MetadataException {
        if (gpsDirectory != null) {
            double d = ExifReader.readAxis(gpsDirectory, 2, 1, 'S');
            double d2 = ExifReader.readAxis(gpsDirectory, 4, 3, 'W');
            return new LatLon(d, d2);
        }
        return null;
    }

    public static Double readDirection(File file) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(file);
            GpsDirectory gpsDirectory = metadata.getFirstDirectoryOfType(GpsDirectory.class);
            return ExifReader.readDirection(gpsDirectory);
        }
        catch (JpegProcessingException jpegProcessingException) {
            Main.error(jpegProcessingException);
        }
        catch (IOException iOException) {
            Main.error(iOException);
        }
        return null;
    }

    public static Double readDirection(GpsDirectory gpsDirectory) {
        Rational rational;
        if (gpsDirectory != null && (rational = gpsDirectory.getRational(17)) != null) {
            return rational.doubleValue();
        }
        return null;
    }

    private static double readAxis(GpsDirectory gpsDirectory, int n, int n2, char c) throws MetadataException {
        double d;
        Rational[] rationalArray = gpsDirectory.getRationalArray(n);
        if (rationalArray != null) {
            double d2 = rationalArray[0].doubleValue();
            double d3 = rationalArray[1].doubleValue();
            double d4 = rationalArray[2].doubleValue();
            if (Double.isNaN(d2) && Double.isNaN(d3) && Double.isNaN(d4)) {
                throw new IllegalArgumentException("deg, min and sec are NaN");
            }
            double d5 = Double.isNaN(d2) ? 0.0 : (d = d2 + (Double.isNaN(d3) ? 0.0 : d3 / 60.0) + (Double.isNaN(d4) ? 0.0 : d4 / 3600.0));
            if (gpsDirectory.getString(n2).charAt(0) == c) {
                d = -d;
            }
        } else {
            d = gpsDirectory.getDouble(n);
        }
        return d;
    }

    public static AffineTransform getRestoreOrientationTransform(int n, int n2, int n3) {
        double d;
        double d2;
        int n4;
        switch (n) {
            case 8: {
                n4 = -1;
                d2 = (double)n2 / 2.0;
                d = (double)n2 / 2.0;
                break;
            }
            case 3: {
                n4 = 2;
                d2 = (double)n2 / 2.0;
                d = (double)n3 / 2.0;
                break;
            }
            case 6: {
                n4 = 1;
                d2 = (double)n3 / 2.0;
                d = (double)n3 / 2.0;
                break;
            }
            default: {
                n4 = 0;
                d2 = 0.0;
                d = 0.0;
            }
        }
        return AffineTransform.getQuadrantRotateInstance(n4, d2, d);
    }

    public static boolean orientationSwitchesDimensions(int n) {
        return n == 6 || n == 8;
    }

    public static boolean orientationNeedsCorrection(int n) {
        return n == 3 || n == 6 || n == 8;
    }
}

