// Generated by IcedCoffeeScript 1.7.1-g
(function() {
  var ChainLink, E, KeyState, ParsedKeys, SIG_ID_SUFFIX, SigChain, UID_LEN, a_json_parse, athrow, bad_whitespace_sig_ids, bufeq_secure, check_buffers_equal, check_link_payload_format, current_time_seconds, error_names, errors_map, hardcoded_resets, iced, ie, kbpgp, known_buggy_reverse_sigs, make_esc, name, proofs, strip_final_newline, trim, __iced_k, __iced_k_noop, _i, _len, _ref,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  iced = require('iced-runtime');
  __iced_k = __iced_k_noop = function() {};

  _ref = require('iced-utils').util, bufeq_secure = _ref.bufeq_secure, athrow = _ref.athrow, a_json_parse = _ref.a_json_parse;

  make_esc = require('iced-error').make_esc;

  kbpgp = require('kbpgp');

  proofs = require('keybase-proofs');

  ie = require('iced-error');

  trim = require('pgp-utils').util.trim;

  UID_LEN = 32;

  exports.SIG_ID_SUFFIX = SIG_ID_SUFFIX = "0f";

  strip_final_newline = function(buf) {
    var s;
    s = buf.toString('utf8');
    if (s.slice(-1) === "\n") {
      return new Buffer(s.slice(0, -1), "utf8");
    } else {
      return buf;
    }
  };

  bad_whitespace_sig_ids = {
    "595a73fc649c2c8ccc1aa79384e0b3e7ab3049d8df838f75ef0edbcb5bbc42990f": true,
    "e256078702afd7a15a24681259935b48342a49840ab6a90291b300961669790f0f": true,
    "30831001edee5e01c3b5f5850043f9ef7749a1ed8624dc703ae0922e1d0f16dd0f": true,
    "88e6c581dbccbf390559bcb30ca21548ba0ec4861ec2d666217bd4ed4a4a8c3f0f": true,
    "4db0fe3973b3a666c7830fcb39d93282f8bc414eca1d535033a5cc625eabda0c0f": true,
    "9ba23a9a1796fb22b3c938f1edf5aba4ca5be7959d9151895eb6aa7a8d8ade420f": true,
    "df0005f6c61bd6efd2867b320013800781f7f047e83fd44d484c2cb2616f019f0f": true,
    "a32692af33e559e00a40aa3bb4004744d2c1083112468ed1c8040eaacd15c6eb0f": true,
    "3e61901f50508aba72f12740fda2be488571afc51d718d845e339e5d1d1b531d0f": true,
    "de43758b653b3383aca640a96c7890458eadd35242e8f8531f29b606890a14ea0f": true,
    "b9ee3b46c97d48742a73e35494d3a373602460609e3c6c54a553fc4d83b659e40f": true,
    "0ff29c1d036c3f4841f3f485e28d77351abb3eeeb52d2f8d802fd15e383d9a5f0f": true,
    "eb1a13c6b6e42bb7470e222b51d36144a25ffc4fbc0b32e9a1ec11f059001bc80f": true,
    "9c189d6d644bad9596f78519d870a685624f813afc1d0e49155073d3b0521f970f": true,
    "aea7c8f7726871714e777ac730e77e1905a38e9587f9504b739ff9b77ef2d5cc0f": true,
    "ac6e225b8324c1fcbe814382e198495bea801dfeb56cb22b9e89066cc52ab03b0f": true,
    "3034e8b7d75861fc28a478b4992a8592b5478d4cbc7b87150d0b59573d731d870f": true,
    "140f1b7b7ba32f34ad6302d0ed78692cf1564760d78c082965dc3b8b5f7e27f10f": true,
    "833f27edcf54cc489795df1dc7d9f0cbea8253e1b84f5e82749a7a2a4ffc295c0f": true,
    "110a64513b4188eca2af6406a8a6dbf278dfce324b8879b5cb67e8626ff2af180f": true,
    "3042dbe45383b0c2eafe13a73da35c4e721be026d7908dfcef6eb121d95b75b10f": true,
    "50ba350ddc388f7c6fdba032a7d283e4caa0ca656f92f69257213222dd7deeaf0f": true,
    "803854b4074d668e1761ee9c533c0fc576bd0404cf26ff7545e14512f3b9002f0f": true,
    "2e08f0b9566e15fa1f9e67b236e5385cdb38d57ff51d7ab3e568532867c9f8890f": true,
    "cb97f4b62f2e817e8db8c6193440214ad20f906571e4851db186869f0b4c0e310f": true,
    "a5c4a30d1eaaf752df424bf813c5a907a5cf94fd371e280d39e0a3d078310fba0f": true,
    "c7d26afbc1957ecca890d8d9001a9cc4863490161720ad76a2aedeb8c2d50df70f": true,
    "b385c0c76d790aba156ff68fd571171fc7cb85f75e7fc9d1561d7960d8875acb0f": true,
    "47d349b8bb3c8457449390ca2ed5e489a70ad511ab3edb4c7f0af27eed8c65d30f": true,
    "2785b24acd6869e1e7d38a91793af549f3c35cd0729127d200b66f8c0ffba59b0f": true,
    "503df567f98cf5910ba44cb95e157e656afe95d159a15c7df4e88ac6016c948f0f": true,
    "2892863758cdaf9796fb36e2466093762efda94e74eb51e3ab9d6bec54064b8a0f": true,
    "e1d60584995e677254f7d913b3f40060b5500241d6de0c5822ba1282acc5e08b0f": true,
    "031b506b705926ea962e59046bfe1720dcf72c85310502020e2ae836b294fcde0f": true,
    "1454fec21489f17a6d78927af1c9dca4209360c6ef6bfa569d8b62d32e668ea30f": true,
    "ba68052597a3782f64079d7d9ec821ea9785c0868e44b597a04c9cd8bf634c1e0f": true,
    "db8d59151b2f78c82c095c9545f1e4d39947a0c0bcc01b907e0ace14517d39970f": true,
    "e088beccfee26c5df39239023d1e4e0cbcd63fd50d0bdc4bf2c2ba25ef1a8fe40f": true,
    "8182f385c347fe57d3c46fe40e8df0e2d6cabdac38f490417b313050249be9dc0f": true,
    "2415e1c77b0815661452ea683e366c6d9dfd2008a7dbc907004c3a33e56cf6190f": true,
    "44847743878bd56f5cd74980475e8f4e95d0d6ec1dd8722fd7cfc7761698ec780f": true,
    "70c4026afec66312456b6820492b7936bff42b58ca7a035729462700677ef4190f": true,
    "7591a920a5050de28faad24b5fe3336f658b964e0e64464b70878bfcf04537420f": true,
    "10a45e10ff2585b03b9b5bc449cb1a7a44fbb7fcf25565286cb2d969ad9b89ae0f": true,
    "062e6799f211177023bc310fd6e4e28a8e2e18f972d9b037d24434a203aca7240f": true,
    "db9a0afaab297048be0d44ffd6d89a3eb6a003256426d7fd87a60ab59880f8160f": true,
    "58bf751ddd23065a820449701f8a1a0a46019e1c54612ea0867086dbd405589a0f": true,
    "062e6799f211177023bc310fd6e4e28a8e2e18f972d9b037d24434a203aca7240f": true,
    "10a45e10ff2585b03b9b5bc449cb1a7a44fbb7fcf25565286cb2d969ad9b89ae0f": true,
    "44847743878bd56f5cd74980475e8f4e95d0d6ec1dd8722fd7cfc7761698ec780f": true,
    "58bf751ddd23065a820449701f8a1a0a46019e1c54612ea0867086dbd405589a0f": true,
    "70c4026afec66312456b6820492b7936bff42b58ca7a035729462700677ef4190f": true,
    "7591a920a5050de28faad24b5fe3336f658b964e0e64464b70878bfcf04537420f": true,
    "db9a0afaab297048be0d44ffd6d89a3eb6a003256426d7fd87a60ab59880f8160f": true
  };

  known_buggy_reverse_sigs = {
    "2a0da9730f049133ce728ba30de8c91b6658b7a375e82c4b3528d7ddb1a21f7a0f": true,
    "eb5c7e7d3cf8370bed8ab55c0d8833ce9d74fd2c614cf2cd2d4c30feca4518fa0f": true,
    "0f175ef0d3b57a9991db5deb30f2432a85bc05922bbe727016f3fb660863a1890f": true,
    "48267f0e3484b2f97859829503e20c2f598529b42c1d840a8fc1eceda71458400f": true
  };

  hardcoded_resets = {
    "11111487aa193b9fafc92851176803af8ed005983cad1eaf5d6a49a459b8fffe0f": true,
    "df0005f6c61bd6efd2867b320013800781f7f047e83fd44d484c2cb2616f019f0f": true,
    "32eab86aa31796db3200f42f2553d330b8a68931544bbb98452a80ad2b0003d30f": true,
    "5ed7a3356fd0f759a4498fc6fed1dca7f62611eb14f782a2a9cda1b836c58db50f": true,
    "d5fe2c5e31958fe45a7f42b325375d5bd8916ef757f736a6faaa66a6b18bec780f": true,
    "1e116e81bc08b915d9df93dc35c202a75ead36c479327cdf49a15f3768ac58f80f": true
  };

  exports.debug = {
    unbox_count: 0
  };

  exports.ParsedKeys = ParsedKeys = ParsedKeys = (function() {
    ParsedKeys.parse = function(_arg, cb) {
      var bundle, default_eldest_kid_for_testing, esc, key_bundles, key_manager, opts, parsed_keys, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      key_bundles = _arg.key_bundles;
      esc = make_esc(cb, "ParsedKeys.parse");
      default_eldest_kid_for_testing = null;
      opts = {
        time_travel: true
      };
      parsed_keys = new ParsedKeys;
      (function(_this) {
        return (function(__iced_k) {
          var _i, _len, _ref1, _results, _while;
          _ref1 = key_bundles;
          _len = _ref1.length;
          _i = 0;
          _results = [];
          _while = function(__iced_k) {
            var _break, _continue, _next;
            _break = function() {
              return __iced_k(_results);
            };
            _continue = function() {
              return iced.trampoline(function() {
                ++_i;
                return _while(__iced_k);
              });
            };
            _next = function(__iced_next_arg) {
              _results.push(__iced_next_arg);
              return _continue();
            };
            if (!(_i < _len)) {
              return _break();
            } else {
              bundle = _ref1[_i];
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                  funcname: "ParsedKeys.parse"
                });
                kbpgp.ukm.import_armored_public({
                  armored: bundle,
                  opts: opts
                }, esc(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return key_manager = arguments[0];
                    };
                  })(),
                  lineno: 116
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                    funcname: "ParsedKeys.parse"
                  });
                  parsed_keys._add_key({
                    key_manager: key_manager
                  }, esc(__iced_deferrals.defer({
                    lineno: 117
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  return _next(default_eldest_kid_for_testing || (default_eldest_kid_for_testing = key_manager.get_ekid().toString("hex")));
                });
              });
            }
          };
          _while(__iced_k);
        });
      })(this)((function(_this) {
        return function() {
          return cb(null, parsed_keys, default_eldest_kid_for_testing);
        };
      })(this));
    };

    function ParsedKeys() {
      this._kids_to_merged_pgp_key_managers = {};
      this._kids_to_pgp_key_managers_by_hash = {};
      this._kids_to_nacl_keys = {};
    }

    ParsedKeys.prototype._add_key = function(_arg, cb) {
      var esc, existing, hash, key_manager, kid, kid_str, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      key_manager = _arg.key_manager;
      esc = make_esc("ParsedKeys._add_key");
      kid = key_manager.get_ekid();
      kid_str = kid.toString("hex");
      (function(_this) {
        return (function(__iced_k) {
          if (key_manager.pgp != null) {
            if ((existing = _this._kids_to_merged_pgp_key_managers[kid_str]) != null) {
              existing.merge_everything(key_manager);
            } else {
              _this._kids_to_merged_pgp_key_managers[kid_str] = key_manager;
            }
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                funcname: "ParsedKeys._add_key"
              });
              key_manager.pgp_full_hash({}, esc(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return hash = arguments[0];
                  };
                })(),
                lineno: 141
              })));
              __iced_deferrals._fulfill();
            })(function() {
              var _base;
              return __iced_k(((_base = _this._kids_to_pgp_key_managers_by_hash)[kid_str] || (_base[kid_str] = {}))[hash] = key_manager);
            });
          } else {
            return __iced_k(_this._kids_to_nacl_keys[kid_str] = key_manager);
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb();
        };
      })(this));
    };

    ParsedKeys.prototype.get_merged_pgp_key_manager = function(kid) {
      return this._kids_to_merged_pgp_key_managers[kid];
    };

    ParsedKeys.prototype.get_pgp_key_manager_with_hash = function(kid, hash) {
      var _ref1;
      return (_ref1 = this._kids_to_pgp_key_managers_by_hash[kid]) != null ? _ref1[hash] : void 0;
    };

    ParsedKeys.prototype.get_nacl_key_manager = function(kid) {
      return this._kids_to_nacl_keys[kid];
    };

    return ParsedKeys;

  })();

  KeyState = (function() {
    function KeyState(_arg) {
      this.parsed_keys = _arg.parsed_keys;
      this._kid_to_hash = {};
    }

    KeyState.prototype.set_key_hash = function(_arg, cb) {
      var hash, kid;
      kid = _arg.kid, hash = _arg.hash;
      if (this.parsed_keys.get_pgp_key_manager_with_hash(kid, hash) == null) {
        cb(new E.NoKeyWithThisHashError("No PGP key with kid " + kid + " and hash " + hash + " exists"));
        return;
      }
      this._kid_to_hash[kid] = hash;
      return cb();
    };

    KeyState.prototype.get_key_manager = function(kid) {
      var hash, key;
      if ((key = this.parsed_keys.get_nacl_key_manager(kid)) != null) {
        return key;
      }
      if ((hash = this._kid_to_hash[kid]) != null) {
        return this.parsed_keys.get_pgp_key_manager_with_hash(kid, hash);
      }
      return this.parsed_keys.get_merged_pgp_key_manager(kid);
    };

    return KeyState;

  })();

  ChainLink = (function() {
    ChainLink.parse = function(_arg, cb) {
      var esc, key_state, payload, payload_hash, sig_blob, sig_cache, sig_id, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      sig_blob = _arg.sig_blob, key_state = _arg.key_state, sig_cache = _arg.sig_cache;
      esc = make_esc(cb, "ChainLink.parse");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
            funcname: "ChainLink.parse"
          });
          _this._unbox_payload({
            sig_blob: sig_blob,
            key_state: key_state,
            sig_cache: sig_cache
          }, esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                payload = arguments[0];
                sig_id = arguments[1];
                return payload_hash = arguments[2];
              };
            })(),
            lineno: 197
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
              funcname: "ChainLink.parse"
            });
            check_link_payload_format({
              payload: payload
            }, esc(__iced_deferrals.defer({
              lineno: 199
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                funcname: "ChainLink.parse"
              });
              _this._check_payload_against_server_kid({
                sig_blob: sig_blob,
                payload: payload,
                key_state: key_state
              }, esc(__iced_deferrals.defer({
                lineno: 202
              })));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                if (!known_buggy_reverse_sigs[sig_id]) {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                      funcname: "ChainLink.parse"
                    });
                    _this._check_reverse_signatures({
                      payload: payload,
                      key_state: key_state
                    }, esc(__iced_deferrals.defer({
                      lineno: 206
                    })));
                    __iced_deferrals._fulfill();
                  })(__iced_k);
                } else {
                  return __iced_k();
                }
              })(function() {
                return cb(null, new ChainLink({
                  kid: sig_blob.kid,
                  sig_id: sig_id,
                  payload: payload,
                  payload_hash: payload_hash
                }));
              });
            });
          });
        };
      })(this));
    };

    ChainLink._unbox_payload = function(_arg, cb) {
      var ctime_seconds, err, esc, hash_input, key_manager, key_state, kid, payload, payload_hash, payload_json, sig_blob, sig_body, sig_cache, sig_eng, sig_id, unverified_buffer, verified_buffer, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      sig_blob = _arg.sig_blob, key_state = _arg.key_state, sig_cache = _arg.sig_cache;
      esc = make_esc(cb, "ChainLink._unbox_payload");
      kid = sig_blob.kid;
      key_manager = key_state.get_key_manager(kid);
      (function(_this) {
        return (function(__iced_k) {
          if (key_manager == null) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                funcname: "ChainLink._unbox_payload"
              });
              athrow(new E.NonexistentKidError("link signed by nonexistent kid " + kid), esc(__iced_deferrals.defer({
                lineno: 218
              })));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          sig_eng = key_manager.make_sig_eng();
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
              funcname: "ChainLink._unbox_payload"
            });
            sig_eng.get_body_and_unverified_payload({
              armored: sig_blob.sig
            }, esc(__iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  sig_body = arguments[0];
                  return unverified_buffer = arguments[1];
                };
              })(),
              lineno: 224
            })));
            __iced_deferrals._fulfill();
          })(function() {
            sig_id = kbpgp.hash.SHA256(sig_body).toString("hex") + SIG_ID_SUFFIX;
            payload_json = unverified_buffer.toString('utf8');
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                funcname: "ChainLink._unbox_payload"
              });
              a_json_parse(payload_json, esc(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return payload = arguments[0];
                  };
                })(),
                lineno: 227
              })));
              __iced_deferrals._fulfill();
            })(function() {
              ctime_seconds = payload.ctime;
              (function(__iced_k) {
                if (sig_cache != null) {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                      funcname: "ChainLink._unbox_payload"
                    });
                    sig_cache.get({
                      sig_id: sig_id
                    }, esc(__iced_deferrals.defer({
                      assign_fn: (function() {
                        return function() {
                          return verified_buffer = arguments[0];
                        };
                      })(),
                      lineno: 231
                    })));
                    __iced_deferrals._fulfill();
                  })(__iced_k);
                } else {
                  return __iced_k();
                }
              })(function() {
                (function(__iced_k) {
                  if (typeof verified_buffer === "undefined" || verified_buffer === null) {
                    exports.debug.unbox_count++;
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                        funcname: "ChainLink._unbox_payload"
                      });
                      key_manager.make_sig_eng().unbox(sig_blob.sig, __iced_deferrals.defer({
                        assign_fn: (function() {
                          return function() {
                            err = arguments[0];
                            return verified_buffer = arguments[1];
                          };
                        })(),
                        lineno: 236
                      }), {
                        now: ctime_seconds
                      });
                      __iced_deferrals._fulfill();
                    })(function() {
                      (function(__iced_k) {
                        if (typeof err !== "undefined" && err !== null) {
                          (function(__iced_k) {
                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                              parent: ___iced_passed_deferral,
                              filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                              funcname: "ChainLink._unbox_payload"
                            });
                            athrow(new E.VerifyFailedError(err.message), esc(__iced_deferrals.defer({
                              lineno: 239
                            })));
                            __iced_deferrals._fulfill();
                          })(__iced_k);
                        } else {
                          return __iced_k();
                        }
                      })(function() {
                        (function(__iced_k) {
                          if (sig_cache != null) {
                            (function(__iced_k) {
                              __iced_deferrals = new iced.Deferrals(__iced_k, {
                                parent: ___iced_passed_deferral,
                                filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                                funcname: "ChainLink._unbox_payload"
                              });
                              sig_cache.put({
                                sig_id: sig_id,
                                payload_buffer: verified_buffer
                              }, esc(__iced_deferrals.defer({
                                lineno: 241
                              })));
                              __iced_deferrals._fulfill();
                            })(__iced_k);
                          } else {
                            return __iced_k();
                          }
                        })(__iced_k);
                      });
                    });
                  } else {
                    return __iced_k();
                  }
                })(function() {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                      funcname: "ChainLink._unbox_payload"
                    });
                    check_buffers_equal(verified_buffer, unverified_buffer, esc(__iced_deferrals.defer({
                      lineno: 246
                    })));
                    __iced_deferrals._fulfill();
                  })(function() {
                    hash_input = bad_whitespace_sig_ids[sig_id] ? strip_final_newline(verified_buffer) : verified_buffer;
                    payload_hash = kbpgp.hash.SHA256(hash_input).toString("hex");
                    return cb(null, payload, sig_id, payload_hash);
                  });
                });
              });
            });
          });
        };
      })(this));
    };

    ChainLink._check_payload_against_server_kid = function(_arg, cb) {
      var err, key_state, payload, payload_fingerprint, payload_kid, sig_blob, signing_fingerprint, signing_kid, _ref1;
      sig_blob = _arg.sig_blob, payload = _arg.payload, key_state = _arg.key_state;
      signing_kid = sig_blob.kid;
      signing_fingerprint = (_ref1 = key_state.get_key_manager(signing_kid).get_pgp_fingerprint()) != null ? _ref1.toString('hex') : void 0;
      payload_kid = payload.body.key.kid;
      payload_fingerprint = payload.body.key.fingerprint;
      err = null;
      if ((payload_kid != null) && payload_kid !== signing_kid) {
        err = new E.KidMismatchError("signing kid (" + signing_kid + ") and payload kid (" + payload_kid + ") mismatch");
      } else if ((payload_fingerprint != null) && payload_fingerprint !== signing_fingerprint) {
        err = new E.FingerprintMismatchError("signing fingerprint (" + signing_fingerprint + ") and payload fingerprint (" + payload_fingerprint + ") mismatch");
      }
      return cb(err);
    };

    ChainLink._check_reverse_signatures = function(_arg, cb) {
      var err, esc, full_hash, key_state, kid, payload, sibkey_key_manager, sibkey_proof, subkey_key_manager, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      payload = _arg.payload, key_state = _arg.key_state;
      esc = make_esc(cb, "ChainLink._check_reverse_signatures");
      (function(_this) {
        return (function(__iced_k) {
          if (payload.body.sibkey != null) {
            kid = payload.body.sibkey.kid;
            full_hash = payload.body.sibkey.full_hash;
            sibkey_key_manager = full_hash != null ? key_state.parsed_keys.get_pgp_key_manager_with_hash(kid, full_hash) : key_state.get_key_manager(kid);
            (function(__iced_k) {
              if (sibkey_key_manager == null) {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                    funcname: "ChainLink._check_reverse_signatures"
                  });
                  athrow(new E.NonexistentKidError("link reverse-signed by nonexistent kid " + kid), esc(__iced_deferrals.defer({
                    lineno: 281
                  })));
                  __iced_deferrals._fulfill();
                })(__iced_k);
              } else {
                return __iced_k();
              }
            })(function() {
              sibkey_proof = new proofs.Sibkey({});
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                  funcname: "ChainLink._check_reverse_signatures"
                });
                sibkey_proof.reverse_sig_check({
                  json: payload,
                  subkm: sibkey_key_manager
                }, __iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return err = arguments[0];
                    };
                  })(),
                  lineno: 283
                }));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  if (typeof err !== "undefined" && err !== null) {
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                        funcname: "ChainLink._check_reverse_signatures"
                      });
                      athrow(new E.ReverseSigVerifyFailedError(err.message), esc(__iced_deferrals.defer({
                        lineno: 285
                      })));
                      __iced_deferrals._fulfill();
                    })(__iced_k);
                  } else {
                    return __iced_k();
                  }
                })(__iced_k);
              });
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (payload.body.subkey != null) {
              kid = payload.body.subkey.kid;
              subkey_key_manager = key_state.get_key_manager(kid);
              (function(__iced_k) {
                if (subkey_key_manager == null) {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                      funcname: "ChainLink._check_reverse_signatures"
                    });
                    athrow(new E.NonexistentKidError("link delegates nonexistent subkey " + kid), esc(__iced_deferrals.defer({
                      lineno: 290
                    })));
                    __iced_deferrals._fulfill();
                  })(__iced_k);
                } else {
                  return __iced_k();
                }
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            return cb(null);
          });
        };
      })(this));
    };

    function ChainLink(_arg) {
      var _ref1, _ref2, _ref3, _ref4, _ref5, _ref6, _ref7, _ref8, _ref9;
      this.kid = _arg.kid, this.sig_id = _arg.sig_id, this.payload = _arg.payload, this.payload_hash = _arg.payload_hash;
      this.uid = this.payload.body.key.uid;
      this.username = this.payload.body.key.username;
      this.seqno = this.payload.seqno;
      this.prev = this.payload.prev;
      this.fingerprint = this.payload.body.key.fingerprint;
      this.eldest_kid = this.payload.body.key.eldest_kid || this.kid;
      this.ctime_seconds = this.payload.ctime;
      this.etime_seconds = this.ctime_seconds + this.payload.expire_in;
      this.type = this.payload.body.type;
      this.signing_key_hash = this.payload.body.key.full_hash;
      this.sibkey_delegation = (_ref1 = this.payload.body.sibkey) != null ? _ref1.kid : void 0;
      this.sibkey_hash = (_ref2 = this.payload.body.sibkey) != null ? _ref2.full_hash : void 0;
      this.subkey_delegation = (_ref3 = this.payload.body.subkey) != null ? _ref3.kid : void 0;
      this.pgp_update_kid = (_ref4 = this.payload.body.pgp_update) != null ? _ref4.kid : void 0;
      this.pgp_update_hash = (_ref5 = this.payload.body.pgp_update) != null ? _ref5.full_hash : void 0;
      this.key_revocations = [];
      if (((_ref6 = this.payload.body.revoke) != null ? _ref6.kids : void 0) != null) {
        this.key_revocations = this.payload.body.revoke.kids;
      }
      if (((_ref7 = this.payload.body.revoke) != null ? _ref7.kid : void 0) != null) {
        this.key_revocations.push(this.payload.body.revoke.kid);
      }
      this.sig_revocations = [];
      if (((_ref8 = this.payload.body.revoke) != null ? _ref8.sig_ids : void 0) != null) {
        this.sig_revocations = this.payload.body.revoke.sig_ids;
      }
      if (((_ref9 = this.payload.body.revoke) != null ? _ref9.sig_id : void 0) != null) {
        this.sig_revocations.push(this.payload.body.revoke.sig_id);
      }
    }

    return ChainLink;

  })();

  exports.check_link_payload_format = check_link_payload_format = function(_arg, cb) {
    var esc, payload, uid, ___iced_passed_deferral, __iced_deferrals, __iced_k;
    __iced_k = __iced_k_noop;
    ___iced_passed_deferral = iced.findDeferral(arguments);
    payload = _arg.payload;
    esc = make_esc(cb, "check_link_payload_format");
    uid = payload.body.key.uid;
    (function(_this) {
      return (function(__iced_k) {
        if (uid.length !== UID_LEN) {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced"
            });
            athrow(new E.BadLinkFormatError("UID wrong length: " + uid.length), esc(__iced_deferrals.defer({
              lineno: 336
            })));
            __iced_deferrals._fulfill();
          })(__iced_k);
        } else {
          return __iced_k();
        }
      });
    })(this)((function(_this) {
      return function() {
        return cb();
      };
    })(this));
  };

  exports.check_buffers_equal = check_buffers_equal = function(verified_buffer, unverified_buffer, cb) {
    var err, msg;
    err = null;
    if (!bufeq_secure(verified_buffer, unverified_buffer)) {
      msg = "Payload mismatch!\nVerified:\n" + (verified_buffer.toString('hex')) + "\nUnverified:\n" + (unverified_buffer.toString('hex'));
      err = new E.VerifyFailedError(msg);
    }
    return cb(err);
  };

  exports.SigChain = SigChain = (function() {
    SigChain.replay = function(_arg, cb) {
      var eldest_kid, esc, log, parsed_keys, sig_blob, sig_blobs, sig_cache, sigchain, uid, username, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      sig_blobs = _arg.sig_blobs, parsed_keys = _arg.parsed_keys, sig_cache = _arg.sig_cache, uid = _arg.uid, username = _arg.username, eldest_kid = _arg.eldest_kid, log = _arg.log;
      log = log || (function() {});
      log("+ libkeybase: replay(username: " + username + ", uid: " + uid + ", eldest: " + eldest_kid + ")");
      esc = make_esc(cb, "SigChain.replay");
      (function(_this) {
        return (function(__iced_k) {
          if (eldest_kid == null) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                funcname: "SigChain.replay"
              });
              athrow(new Error("eldest_kid parameter is required"), esc(__iced_deferrals.defer({
                lineno: 385
              })));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          sigchain = new SigChain({
            uid: uid,
            username: username,
            eldest_kid: eldest_kid,
            parsed_keys: parsed_keys
          });
          (function(__iced_k) {
            var _i, _len, _ref1, _results, _while;
            _ref1 = sig_blobs;
            _len = _ref1.length;
            _i = 0;
            _results = [];
            _while = function(__iced_k) {
              var _break, _continue, _next;
              _break = function() {
                return __iced_k(_results);
              };
              _continue = function() {
                return iced.trampoline(function() {
                  ++_i;
                  return _while(__iced_k);
                });
              };
              _next = function(__iced_next_arg) {
                _results.push(__iced_next_arg);
                return _continue();
              };
              if (!(_i < _len)) {
                return _break();
              } else {
                sig_blob = _ref1[_i];
                log("| libkeybase: replaying signature " + sig_blob.seqno + ": " + sig_blob.sig_id);
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                    funcname: "SigChain.replay"
                  });
                  sigchain._add_new_link({
                    sig_blob: sig_blob,
                    sig_cache: sig_cache,
                    log: log
                  }, esc(__iced_deferrals.defer({
                    lineno: 391
                  })));
                  __iced_deferrals._fulfill();
                })(_next);
              }
            };
            _while(__iced_k);
          })(function() {
            if (eldest_kid !== sigchain._current_subchain_eldest) {
              sigchain._reset_subchain(eldest_kid);
            }
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                funcname: "SigChain.replay"
              });
              sigchain._enforce_eldest_key_ownership({}, esc(__iced_deferrals.defer({
                lineno: 398
              })));
              __iced_deferrals._fulfill();
            })(function() {
              log("- libkeybase: replay finished");
              return cb(null, sigchain);
            });
          });
        };
      })(this));
    };

    function SigChain(_arg) {
      var eldest_kid, parsed_keys, uid, username;
      uid = _arg.uid, username = _arg.username, eldest_kid = _arg.eldest_kid, parsed_keys = _arg.parsed_keys;
      this._uid = uid;
      this._username = username;
      this._eldest_kid = eldest_kid;
      this._parsed_keys = parsed_keys;
      this._next_seqno = 1;
      this._next_payload_hash = null;
      this._reset_subchain(null);
    }

    SigChain.prototype._reset_subchain = function(current_subchain_eldest) {
      this._current_subchain = [];
      this._current_subchain_eldest = current_subchain_eldest;
      this._key_state = new KeyState({
        parsed_keys: this._parsed_keys
      });
      this._unrevoked_links = {};
      this._valid_sibkeys = {};
      this._valid_sibkeys[current_subchain_eldest] = true;
      this._sibkey_order = [current_subchain_eldest];
      this._valid_subkeys = {};
      this._subkey_order = [];
      this._kid_to_etime_seconds = {};
      return this._update_kid_pgp_etime({
        kid: current_subchain_eldest
      });
    };

    SigChain.prototype.get_links = function() {
      var link;
      return (function() {
        var _i, _len, _ref1, _results;
        _ref1 = this._current_subchain;
        _results = [];
        for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
          link = _ref1[_i];
          if (link.sig_id in this._unrevoked_links) {
            _results.push(link);
          }
        }
        return _results;
      }).call(this);
    };

    SigChain.prototype.get_sibkeys = function(_arg) {
      var etime, expired, kid, now, ret, _i, _len, _ref1;
      now = _arg.now;
      now = now || current_time_seconds();
      ret = [];
      _ref1 = this._sibkey_order;
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        kid = _ref1[_i];
        etime = this._kid_to_etime_seconds[kid];
        expired = (etime != null) && now > etime;
        if (this._valid_sibkeys[kid] && !expired) {
          ret.push(this._key_state.get_key_manager(kid));
        }
      }
      return ret;
    };

    SigChain.prototype.get_subkeys = function(_arg) {
      var etime, expired, kid, now, ret, _i, _len, _ref1;
      now = _arg.now;
      now = now || current_time_seconds();
      ret = [];
      _ref1 = this._subkey_order;
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        kid = _ref1[_i];
        etime = this._kid_to_etime_seconds[kid];
        expired = (etime != null) && now > etime;
        if (this._valid_subkeys[kid] && !expired) {
          ret.push(this._key_state.get_key_manager(kid));
        }
      }
      return ret;
    };

    SigChain.prototype._add_new_link = function(_arg, cb) {
      var esc, link, log, sig_blob, sig_cache, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      sig_blob = _arg.sig_blob, sig_cache = _arg.sig_cache, log = _arg.log;
      esc = make_esc(cb, "SigChain._add_new_link");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
            funcname: "SigChain._add_new_link"
          });
          ChainLink.parse({
            sig_blob: sig_blob,
            key_state: _this._key_state,
            sig_cache: sig_cache
          }, esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return link = arguments[0];
              };
            })(),
            lineno: 459
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          log("| libkeybase: chain link parsed, type '" + link.payload.body.type + "'");
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
              funcname: "SigChain._add_new_link"
            });
            _this._check_link_belongs_here({
              link: link
            }, esc(__iced_deferrals.defer({
              lineno: 464
            })));
            __iced_deferrals._fulfill();
          })(function() {
            if (link.eldest_kid !== _this._current_subchain_eldest || link.type === "eldest" || hardcoded_resets[link.sig_id]) {
              log("| libkeybase: starting new subchain");
              _this._reset_subchain(link.eldest_kid);
            }
            if (known_buggy_reverse_sigs[link.sig_id]) {
              cb(null);
              return;
            }
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                funcname: "SigChain._add_new_link"
              });
              _this._check_key_is_valid({
                link: link
              }, esc(__iced_deferrals.defer({
                lineno: 494
              })));
              __iced_deferrals._fulfill();
            })(function() {
              log("| libkeybase: signing key is valid (" + link.kid + ")");
              _this._current_subchain.push(link);
              _this._unrevoked_links[link.sig_id] = link;
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                  funcname: "SigChain._add_new_link"
                });
                _this._delegate_keys({
                  link: link,
                  log: log
                }, esc(__iced_deferrals.defer({
                  lineno: 501
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                    funcname: "SigChain._add_new_link"
                  });
                  _this._revoke_keys_and_sigs({
                    link: link,
                    log: log
                  }, esc(__iced_deferrals.defer({
                    lineno: 502
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  return cb(null);
                });
              });
            });
          });
        };
      })(this));
    };

    SigChain.prototype._check_link_belongs_here = function(_arg, cb) {
      var err, link;
      link = _arg.link;
      err = null;
      if (link.uid !== this._uid) {
        err = new E.WrongUidError("Link doesn't refer to the right uid, expected: " + link.uid + " got: " + this._uid);
      } else if (link.username.toLowerCase() !== this._username.toLowerCase()) {
        err = new E.WrongUsernameError("Link doesn't refer to the right username, expected: " + link.username + " got: " + this._username);
      } else if (link.seqno !== this._next_seqno) {
        err = new E.WrongSeqnoError("Link sequence number is wrong, expected: " + this._next_seqno + " got: " + link.seqno);
      } else if ((this._next_payload_hash != null) && link.prev !== this._next_payload_hash) {
        err = new E.WrongPrevError("Previous payload hash doesn't match, expected: " + this._next_payload_hash + " got: " + link.prev);
      }
      this._next_seqno++;
      this._next_payload_hash = link.payload_hash;
      return cb(err);
    };

    SigChain.prototype._check_key_is_valid = function(_arg, cb) {
      var err, kid, link;
      link = _arg.link;
      err = null;
      if (!(link.kid in this._valid_sibkeys)) {
        err = new E.InvalidSibkeyError("not a valid sibkey: " + link.kid + ", valid sibkeys: " + (JSON.stringify((function() {
          var _results;
          _results = [];
          for (kid in this._valid_sibkeys) {
            _results.push(kid);
          }
          return _results;
        }).call(this))));
      } else if (link.ctime_seconds > this._kid_to_etime_seconds[link.kid]) {
        err = new E.ExpiredSibkeyError("expired sibkey: " + link.kid);
      }
      return cb(err);
    };

    SigChain.prototype._delegate_keys = function(_arg, cb) {
      var esc, link, log, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      link = _arg.link, log = _arg.log;
      esc = make_esc(cb, 'SigChain._delegate_keys');
      (function(_this) {
        return (function(__iced_k) {
          if (_this._current_subchain.length === 1) {
            log("| libkeybase: delegating eldest key " + link.kid);
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                funcname: "SigChain._delegate_keys"
              });
              _this._delegate_sibkey({
                kid: link.kid,
                etime_seconds: link.etime_seconds,
                full_hash: link.signing_key_hash
              }, esc(__iced_deferrals.defer({
                lineno: 547
              })));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (link.sibkey_delegation != null) {
              log("| libkeybase: delegating sibkey " + link.sibkey_delegation);
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                  funcname: "SigChain._delegate_keys"
                });
                _this._delegate_sibkey({
                  kid: link.sibkey_delegation,
                  etime_seconds: link.etime_seconds,
                  full_hash: link.sibkey_hash
                }, esc(__iced_deferrals.defer({
                  lineno: 555
                })));
                __iced_deferrals._fulfill();
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            (function(__iced_k) {
              if (link.subkey_delegation != null) {
                log("| libkeybase: delegating subkey " + link.subkey_delegation);
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                    funcname: "SigChain._delegate_keys"
                  });
                  _this._delegate_subkey({
                    kid: link.subkey_delegation,
                    etime_seconds: link.etime_seconds
                  }, esc(__iced_deferrals.defer({
                    lineno: 562
                  })));
                  __iced_deferrals._fulfill();
                })(__iced_k);
              } else {
                return __iced_k();
              }
            })(function() {
              (function(__iced_k) {
                if ((link.pgp_update_kid != null) && (link.pgp_update_hash != null) && (_this._valid_sibkeys[link.pgp_update_kid] != null)) {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                      funcname: "SigChain._delegate_keys"
                    });
                    _this._key_state.set_key_hash({
                      kid: link.pgp_update_kid,
                      hash: link.pgp_update_hash
                    }, esc(__iced_deferrals.defer({
                      lineno: 566
                    })));
                    __iced_deferrals._fulfill();
                  })(__iced_k);
                } else {
                  return __iced_k();
                }
              })(function() {
                return cb();
              });
            });
          });
        };
      })(this));
    };

    SigChain.prototype._delegate_sibkey = function(_arg, cb) {
      var esc, etime_seconds, full_hash, kid, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      kid = _arg.kid, etime_seconds = _arg.etime_seconds, full_hash = _arg.full_hash;
      esc = make_esc(cb, 'SigChain._delegate_sibkey');
      this._valid_sibkeys[kid] = true;
      if (__indexOf.call(this._sibkey_order, kid) < 0) {
        this._sibkey_order.push(kid);
      }
      this._update_kid_etime({
        kid: kid,
        etime_seconds: etime_seconds
      });
      this._update_kid_pgp_etime({
        kid: kid
      });
      (function(_this) {
        return (function(__iced_k) {
          if (full_hash != null) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                funcname: "SigChain._delegate_sibkey"
              });
              _this._key_state.set_key_hash({
                kid: kid,
                hash: full_hash
              }, esc(__iced_deferrals.defer({
                lineno: 577
              })));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(null);
        };
      })(this));
    };

    SigChain.prototype._delegate_subkey = function(_arg, cb) {
      var esc, etime_seconds, kid;
      kid = _arg.kid, etime_seconds = _arg.etime_seconds;
      esc = make_esc(cb, 'SigChain._delegate_subkey');
      this._valid_subkeys[kid] = true;
      if (__indexOf.call(this._subkey_order, kid) < 0) {
        this._subkey_order.push(kid);
      }
      this._update_kid_etime({
        kid: kid,
        etime_seconds: etime_seconds
      });
      return cb(null);
    };

    SigChain.prototype._update_kid_pgp_etime = function(_arg) {
      var etime_seconds, key_manager, kid, lifespan, _ref1;
      kid = _arg.kid;
      key_manager = this._key_state.get_key_manager(kid);
      lifespan = key_manager != null ? (_ref1 = key_manager.primary) != null ? _ref1.lifespan : void 0 : void 0;
      if ((lifespan != null ? lifespan.expire_in : void 0) != null) {
        etime_seconds = lifespan.generated + lifespan.expire_in;
        return this._update_kid_etime({
          kid: kid,
          etime_seconds: etime_seconds
        });
      }
    };

    SigChain.prototype._update_kid_etime = function(_arg) {
      var etime_seconds, kid;
      kid = _arg.kid, etime_seconds = _arg.etime_seconds;
      if (this._kid_to_etime_seconds[kid] == null) {
        return this._kid_to_etime_seconds[kid] = etime_seconds;
      } else {
        return this._kid_to_etime_seconds[kid] = Math.min(etime_seconds, this._kid_to_etime_seconds[kid]);
      }
    };

    SigChain.prototype._revoke_keys_and_sigs = function(_arg, cb) {
      var kid, link, log, revoked_link, revoked_sibkey, revoked_subkey, sig_id, _i, _j, _len, _len1, _ref1, _ref2;
      link = _arg.link, log = _arg.log;
      _ref1 = link.key_revocations;
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        kid = _ref1[_i];
        if (kid in this._valid_sibkeys) {
          log("| libkeybase: revoking sibkey " + kid);
          delete this._valid_sibkeys[kid];
        }
        if (kid in this._valid_subkeys) {
          delete this._valid_subkeys[kid];
        }
      }
      _ref2 = link.sig_revocations;
      for (_j = 0, _len1 = _ref2.length; _j < _len1; _j++) {
        sig_id = _ref2[_j];
        if (sig_id in this._unrevoked_links) {
          revoked_link = this._unrevoked_links[sig_id];
          delete this._unrevoked_links[sig_id];
          revoked_sibkey = revoked_link.sibkey_delegation;
          if ((revoked_sibkey != null) && revoked_sibkey in this._valid_sibkeys) {
            log("| libkeybase: revoking sibkey " + revoked_sibkey + " from sig " + sig_id);
            delete this._valid_sibkeys[revoked_sibkey];
          }
          revoked_subkey = revoked_link.subkey_delegation;
          if ((revoked_subkey != null) && revoked_subkey in this._valid_subkeys) {
            delete this._valid_subkeys[revoked_subkey];
          }
        }
      }
      return cb();
    };

    SigChain.prototype._enforce_eldest_key_ownership = function(_arg, cb) {
      var eldest_km, esc, expected_email, identity, userids, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      _arg;
      esc = make_esc(cb, "SigChain._enforce_eldest_key_ownership");
      if (this._current_subchain.length > 0) {
        cb(null);
        return;
      }
      eldest_km = this._key_state.get_key_manager(this._eldest_kid);
      (function(_this) {
        return (function(__iced_k) {
          if (eldest_km == null) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                funcname: "SigChain._enforce_eldest_key_ownership"
              });
              athrow(new E.NonexistentKidError("no key for eldest kid " + _this._eldest_kid), esc(__iced_deferrals.defer({
                lineno: 647
              })));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          userids = eldest_km.get_userids_mark_primary();
          (function(__iced_k) {
            if (userids == null) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
                  funcname: "SigChain._enforce_eldest_key_ownership"
                });
                athrow(new E.KeyOwnershipError("key " + _this._eldest_kid + " is not self-signing"), esc(__iced_deferrals.defer({
                  lineno: 652
                })));
                __iced_deferrals._fulfill();
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            var _i, _len;
            expected_email = _this._username + "@keybase.io";
            for (_i = 0, _len = userids.length; _i < _len; _i++) {
              identity = userids[_i];
              if (identity.get_email() === expected_email) {
                cb(null);
                return;
              }
            }
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/jacko/libkeybase-js/src/sigchain/sigchain.iced",
              funcname: "SigChain._enforce_eldest_key_ownership"
            });
            athrow(new E.KeyOwnershipError("key " + _this._eldest_kid + " is not owned by " + expected_email), esc(__iced_deferrals.defer({
              lineno: 660
            })));
            __iced_deferrals._fulfill();
          });
        };
      })(this));
    };

    return SigChain;

  })();

  error_names = ["BAD_LINK_FORMAT", "EXPIRED_SIBKEY", "FINGERPRINT_MISMATCH", "INVALID_SIBKEY", "KEY_OWNERSHIP", "KID_MISMATCH", "NO_KEY_WITH_THIS_HASH", "NONEXISTENT_KID", "NOT_LATEST_SUBCHAIN", "REVERSE_SIG_VERIFY_FAILED", "VERIFY_FAILED", "WRONG_UID", "WRONG_USERNAME", "WRONG_SEQNO", "WRONG_PREV"];

  errors_map = {};

  for (_i = 0, _len = error_names.length; _i < _len; _i++) {
    name = error_names[_i];
    errors_map[name] = "";
  }

  exports.E = E = ie.make_errors(errors_map);

  current_time_seconds = function() {
    return Math.floor(new Date().getTime() / 1000);
  };

  __iced_k_noop();

}).call(this);
